<?php
$productos = array(
    array('ID' => 1, 'Codigo' => 'ABC123', 'Descripcion' => 'Producto A', 'Cantidad' => 10, 'Costo' => 10.00, 'Precio_1' => 20.50, 'Precio_2' => 18.75, 'Precio_3' => 15.99),
    array('ID' => 2, 'Codigo' => 'DEF456', 'Descripcion' => 'Producto B', 'Cantidad' => 5, 'Costo' => 8.50, 'Precio_1' => 15.75, 'Precio_2' => 13.99, 'Precio_3' => 11.25),
    array('ID' => 3, 'Codigo' => 'GHI789', 'Descripcion' => 'Producto C', 'Cantidad' => 20, 'Costo' => 15.00, 'Precio_1' => 30.99, 'Precio_2' => 28.50, 'Precio_3' => 25.25),
    array('ID' => 4, 'Codigo' => 'JKL012', 'Descripcion' => 'Producto D', 'Cantidad' => 8, 'Costo' => 18.75, 'Precio_1' => 25.25, 'Precio_2' => 23.50, 'Precio_3' => 20.99),
    array('ID' => 5, 'Codigo' => 'MNO345', 'Descripcion' => 'Producto E', 'Cantidad' => 15, 'Costo' => 12.50, 'Precio_1' => 18.99, 'Precio_2' => 16.75, 'Precio_3' => 14.50)
);


$productos = $_SESSION[ "DatosCP" ];
?>

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

<div class="container mt-12">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="punto-de-compra bg-white rounded p-4">
                <div class="form-group campo">
                    <label for="descripcion">Descripción:</label>
                    <input type="text" class="form-control" id="descripcion" name="descripcion" placeholder="Ingrese la descripción">
                </div>

                <button onclick="agregarProducto()" class="btn btn-primary">Agregar</button>
            </div>
        </div>
    </div>
</div>

<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="punto-de-compra bg-white rounded p-4">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Codigo</th>
                            <th>Descripcion</th>
                            <th>Cantidad</th>
                            <th>Costo</th>
                            <th>Precio_1</th>
                            <th>Precio_2</th>
                            <th>Precio_3</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>

                <!-- Botón Guardar -->
                <button onclick="guardarEdicion()" class="btn btn-success">Guardar</button>
            </div>
        </div>
    </div>
</div>

<script>
    // Definir la variable de productos en JavaScript
    var productos = <?php echo json_encode($productos); ?>;

    $(function () {
        $("#descripcion").autocomplete({
            source: <?php echo json_encode(array_column($productos, 'Descripcion')); ?>,
            minLength: 1
        });
    });

function agregarProducto() {
    var descripcion = document.getElementById('descripcion').value.trim();

    // Validar que la descripción no esté vacía
    if (descripcion === '') {
        alert('Por favor, ingrese una descripción.');
        return;
    }

    // Buscar el producto correspondiente en el arreglo
    var productoEncontrado = null;
    for (var i = 0; i < productos.length; i++) {
        if (productos[i].Descripcion.toLowerCase() === descripcion.toLowerCase()) {
            productoEncontrado = productos[i];
            break;
        }
    }

    // Verificar si el producto ya está en la tabla
    var tabla = document.querySelector('table tbody');
    var filas = tabla.querySelectorAll('tr');
    for (var i = 0; i < filas.length; i++) {
        var celdaDescripcion = filas[i].querySelector('td:nth-child(3)');
        if (celdaDescripcion && celdaDescripcion.innerText.toLowerCase() === descripcion.toLowerCase()) {
            alert('Este producto ya ha sido agregado a la tabla.');
            return;
        }
    }

    // Si se encuentra el producto, agregarlo a la tabla
    if (productoEncontrado) {
        agregarFila(productoEncontrado);
    } else {
        alert('No se encontró ningún producto con esa descripción.');
    }

    // Limpiar el campo de descripción
    document.getElementById('descripcion').value = '';
}


    function agregarFila(producto) {
        var tabla = document.querySelector('table tbody');
        var fila = tabla.insertRow(-1);

        for (var clave in producto) {
            var celda = fila.insertCell(-1);

            // Desactivar la edición para Codigo y Descripcion
            if (clave == 'ID' || clave == 'Codigo' || clave == 'Descripcion') {
                celda.innerText = producto[clave];
                celda.contentEditable = false;
            } else {
                celda.innerText = producto[clave];
                // Limitar a valores numéricos
                if (clave != 'ID') {
                    celda.addEventListener('input', function () {
                        this.innerText = this.innerText.replace(/[^0-9.]/g, '');
                    });
                    celda.contentEditable = true;
                } else {
                    celda.contentEditable = false;
                }
            }
        }
    }

    function guardarEdicion() {
		    // Preguntar al usuario si está seguro de hacer la compra
    var confirmacion = confirm('¿Estás seguro de realizar la compra?');
    if (confirmacion) {
    var filas = document.querySelectorAll('tbody tr');
    var productosEditados = [];

    filas.forEach(function (fila) {
        var valoresEditados = {};
        fila.querySelectorAll('td').forEach(function (celda, index) {
            var clave = Object.keys(productos[0])[index];
            valoresEditados[clave] = celda.innerText;
        });
        productosEditados.push(valoresEditados);
    });

    var jsonEditado = JSON.stringify(productosEditados, null, 2);


  

    // Realizar la solicitud AJAX
    $.ajax({
        url: '<?php echo $urlajaxeditarproductos; ?>',
        data: jsonEditado,
        type: "post",
        success: function (respuesta) {
            // Manejar la respuesta del servidor, si es necesario
            console.log(respuesta);
            $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se agregó una aplicación con éxito.</div>');
            setTimeout(function () {
                $('#Mensaje').hide();
            }, 2000);
          
            // Limpiar la tabla
            $('table tbody').empty();
        },
        error: function (error) {
            console.error('Error al agregar producto:', error);
        }
    });
		
		
		     
    }
}

</script>
