<?php
session_start();
include("../conexion.php");

$db = new MySQL();


$tipo = $_POST['tipo']; // "editar" o "cancelar"

// Obtener los valores de la solicitud POST
$evento_id = $_POST['evento_id'];
$nueva_fecha = $_POST['nueva_fecha'];  // Fecha en formato "YYYY-MM-DD"
$nueva_hora = $_POST['nueva_hora'];    // Hora en formato "HH:MM"
$asignado = $_POST['asignado'];
$color = $_POST['color'];  // Obtener el valor de color de la solicitud POST

// Concatenar la fecha y hora en el formato adecuado para MySQL
// Ejemplo: '2024-12-16T12:30' => '2024-12-16 12:30:00'
$fecha_hora_completa = $nueva_fecha . ' ' . $nueva_hora;  // Esto ya es un formato compatible con MySQL



switch ($tipo) {
    case "Editar":
        // Construir la consulta para editar el evento
        $query = $_SESSION["SQLUpdateAgenda"];
        
        // Reemplazar los placeholders con los valores reales
        $query = str_replace('#1', $fecha_hora_completa, $query);
        $query = str_replace('#2', $asignado, $query);
        $query = str_replace('#3', 'Ok', $query);  // Asumiendo que el estado es 'Ok'
        $query = str_replace('#4', $color, $query);  // Reemplazar el placeholder de color
        $query = str_replace('#5', $evento_id, $query);  // Reemplazar el placeholder de evento_id
        
        break;

    case "Cancelar":
        // Construir la consulta para cancelar el evento
        $query = $_SESSION["SQLCancelAgenda"]; // Supongamos que tienes una consulta predefinida para cancelar
        $query = str_replace('#1', $evento_id, $query);   
        break;

    default:
        echo "Tipo de acción no válido.";
        exit; // Detener la ejecución si el tipo no es válido
}

// Mostrar la consulta generada (para depuración)
echo $query;
   echo json_encode(['success' => true, 'message' => $query]);

// Ejecutar la consulta (descomentando la siguiente línea si todo está correcto)
$data = $db->actualizar($query);
?>
