<div class="row page-titles mx-0">
    <h2>Nota</h2>

    <div id="grupo-1" class="input-group mb-3">
        <span class="input-group-text">1</span>
        <input type="number" class="form-control col-1 cantidad" placeholder="Cantidad" min="0" max="999" maxlength="3">
        <input type="text" class="form-control descripcion" placeholder="Descripción" maxlength="50">
        <input type="number" class="form-control col-2 precio" placeholder="Precio">
        <span class="input-group-text">$</span>
        <input type="text" class="form-control col-2 monto" placeholder="Monto" readonly>
    </div>
    <div class="input-group mb-3 agregados"></div>
    
    <div class="input-group justify-content-end">
        <div class="input-group-prepend ml-auto">
            <button class="btn btn-outline-primary agregar btn-lg" type="button">+</button>
            <button class="btn btn-outline-primary eliminar btn-lg" type="button">-</button>
        </div>
    </div>

    <div class="input-group mb-3">
        <span class="input-group-text"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></span>
        <textarea id="observacionesPago" class="form-control observaciones"  placeholder="Observaciones" aria-label="Observaciones"></textarea>
    </div>

    <div class="input-group mb-3 justify-content-end">
        <div class="input-group-prepend ml-auto">
            <span class="input-group-text"><i class="fa fa-usd" aria-hidden="true"></i></span>
        </div>
        <input type="text" class="form-control col-2 total" placeholder="Total" aria-label="Total" readonly>
    </div>

   <button type="button" class="btn btn-success btn-lg btn-block" id="btnCobrar">Cobrar</button>

</div>

<script>
    var contador = 1;
    var nota = [];
    var TotalT = 0;
    var ItemsT = 0;
	var listaProductos = [];
	var catalogoProductos = <?php echo json_encode($productos); ?>;
    
    document.addEventListener('DOMContentLoaded', function() {
        // Manejar la adición y eliminación de grupos dinámicamente
        document.querySelector('.agregar').addEventListener('click', agregarGrupo);
        document.querySelector('.eliminar').addEventListener('click', eliminarGrupo);
        document.querySelector('#btnCobrar').addEventListener('click', cobrar);

        function agregarGrupo() {
            contador++;
            var nuevoGrupo = document.getElementById('grupo-1').cloneNode(true);
            nuevoGrupo.id = 'grupo-' + contador;
            nuevoGrupo.querySelector('.input-group-text').textContent = contador;
            nuevoGrupo.querySelector('.cantidad').value = '';
            nuevoGrupo.querySelector('.descripcion').value = '';
            nuevoGrupo.querySelector('.precio').value = '';
            nuevoGrupo.querySelector('.monto').value = '';
            document.querySelector('.agregados').appendChild(nuevoGrupo);
            agregarEventos(nuevoGrupo); // Agregar eventos al nuevo grupo
            actualizarNota();
        }

        function eliminarGrupo() {
            if (contador > 1) {
                var ultimoGrupo = document.getElementById('grupo-' + contador);
                ultimoGrupo.parentNode.removeChild(ultimoGrupo);
                contador--;
                actualizarNota();
            }
        }

        // Agregar eventos al grupo inicial
        agregarEventos(document.getElementById('grupo-1'));

        // Agregar eventos al grupo
        function agregarEventos(grupo) {
            grupo.querySelector('.cantidad').addEventListener('input', function() {
                calcularMonto(grupo);
            });
            grupo.querySelector('.precio').addEventListener('input', function() {
                calcularMonto(grupo);
            });
            grupo.querySelector('.descripcion').addEventListener('blur', function() {
                actualizarMonto(grupo);
            });
        }

        // Calcula el monto al cambiar la cantidad o el precio
        function calcularMonto(grupo) {
            var cantidad = parseFloat(grupo.querySelector('.cantidad').value) || 0;
            var precio = parseFloat(grupo.querySelector('.precio').value) || 0;
            var monto = cantidad * precio;
            grupo.querySelector('.monto').value = monto.toFixed(2);
            calcularTotal();
            actualizarNota();
        }

        // Actualiza el monto al perder el foco en la descripción
        function actualizarMonto(grupo) {
            calcularMonto(grupo);
        }

        // Calcula el total sumando todos los montos
        function calcularTotal() {
            var total = 0;
            document.querySelectorAll('.monto').forEach(function(montoInput) {
                total += parseFloat(montoInput.value) || 0;
            });
            document.querySelector('.total').value = total.toFixed(2);
            TotalT = total.toFixed(2);
        }

        // Actualiza el arreglo de la nota
        function actualizarNota() {
            nota = [];
            var codigos = []; // Almacenar los códigos existentes
            document.querySelectorAll('.input-group').forEach(function(inputGroup) {
                var cantidadElement = inputGroup.querySelector('.cantidad');
                var descripcionElement = inputGroup.querySelector('.descripcion');
                var precioElement = inputGroup.querySelector('.precio');
                var montoElement = inputGroup.querySelector('.monto');

                if (cantidadElement && descripcionElement && precioElement && montoElement) {
                    var cantidad = cantidadElement.value || 0;
                    var descripcion = descripcionElement.value || '';
                    var precio = precioElement.value || 0;
                    var monto = montoElement.value || 0;
                    var codigo = parseInt(inputGroup.querySelector('.input-group-text').textContent);
                    var id=codigo;
                    // Verificar si el código ya existe en la lista de códigos
                    if (!codigos.includes(codigo)) {
                        nota.push({ id:id, codigo: codigo, cantidad: cantidad, descripcion: descripcion, precio: precio, monto: monto });
                        codigos.push(codigo); // Agregar el código a la lista de códigos
                        listaProductos = nota;
                    }
                }
            });
            
            console.log(TotalT);
        }

        // Función para validar antes de cobrar
        function cobrar() {
            var camposVacios = false;
            var inputsCantidad = document.querySelectorAll('.cantidad');
            var inputsDescripcion = document.querySelectorAll('.descripcion');
            var inputsPrecio = document.querySelectorAll('.precio');

            for (var i = 0; i < inputsCantidad.length; i++) {
                var cantidad = inputsCantidad[i].value.trim();
                var descripcion = inputsDescripcion[i].value.trim();
                var precio = inputsPrecio[i].value.trim();

                if (cantidad === '' || descripcion === '' || precio === '') {
                    camposVacios = true;
                    break;
                }
            }

            if (camposVacios) {
				
                alert('Por favor, complete todos los campos (excepto Observaciones) antes de cobrar.');
            } else {
                           
				  $('#modalCobro').modal('show');
            }
        }
    });
</script>
