
<style>
.pills-rounded .nav-item .nav-link {
    border-radius: 10em;
}
.pills-outline-red .nav-item .nav-link {
    border: 2px solid #fff;
    color: #666;
    background-color: transparent;
	height: 80px;
}
.pills-outline-red .nav-item .nav-link:hover {
    border: 2px solid #eee;
}
.pills-outline-red .nav-item .nav-link.active {
    border: 2px solid #f44336;
    color: #f44336;
}
.pills-outline-red .nav-item .nav-link.active:hover {
    border: 2px solid #f44336;
    color: #f44336;
}
.tabbable .nav-tabs {
    overflow-x: auto;
    overflow-y: hidden;
    flex-wrap: nowrap;
}
.tabbable .nav-tabs .nav-link {
    white-space: nowrap;
}
/* Estilos personalizados */
body {
    background-color: #f0f0f0;
}
.container {
    background-color: #fff;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.2);
	max-width: 100%; 
}
	    .containerTotal {
        background-color: #f0f0f0;
        border-radius: 8px;
        padding: 15px;
        margin-top: 20px;
    }
.product-icon {
    width: 150px;
    height: 150px;
    text-align: center;
    cursor: pointer;
}
.product-icon i {
    font-size: 48px;
}
.product-icon.active {
    background-color: #CCCCCC;
    color: #fff;
}
#product-list {
    background-color: #ffffff;
    border: 1px solid #e0e0e0;
    border-radius: 5px;
    padding: 10px;
}
#total-precio {
    color: #007bff;
}
.btn-checkout {
    background-color: #28a745;
    color: #fff;
    border: none;
}
.remove-product {
    cursor: pointer;
    float: right;
    font-weight: bold;
    color: red;
}
.cantidad-input {
    width: 60px;
    text-align: center;
}
.btn-cantidad {
    font-size: 20px;
}
	#product-list {
    max-height: 300px; /* Altura máxima deseada para la lista */
    overflow-y: auto; /* Habilitar el scroll vertical cuando la lista exceda la altura máxima */
}
</style>
<div class="container">
  <div class="row page-titles mx-0">
    <div class="container-fluid">
		
   <nav class="tabbable">
    <div class="d-flex align-items-center"> <!-- Contenedor flex para alinear elementos -->


        <div class="nav nav-tabs ml-3" id="nav-tab" role="tablist"> <!-- Agregado ml-3 para márgenes a la izquierda -->
            <a class="nav-item nav-link active" id="nav-home-tab" onClick="cliente('Todo*', '0')" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true">
                <i class="icon-arrow-right"></i>
            </a>
            <?php
            // Genera 20 botones en un arreglo
            foreach ($categorias as $fila) {
                foreach ($fila as $valor) {
                    $botones[] = $valor;
                }
            }

            foreach ($botones as $index => $nombre) {
                echo "<a onClick=\"cliente($index, '$nombre')\" class=\"nav-item nav-link\" id=\"nav-$index-tab\" data-toggle=\"tab\" href=\"#nav-$index\" role=\"tab\" aria-controls=\"nav-$index\" aria-selected=\"false\">$nombre</a>";
            }
            ?>
        </div>
    </div>
</nav>

      <div class="tab-content pt-2" id="nav-tabContent">
        <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">Selecciona una Categoría</div>
        <?php
        // Recorre el arreglo de botones para generar los contenedores de botones
        foreach ( $categorias as $index => $nombre ) {
            echo "<div class=\"tab-pane fade\" id=\"nav-$index\" role=\"tabpanel\" aria-labelledby=\"nav-$index-tab\">";
            echo "<div id=\"containers$index\" class=\"slidable-container\">";
            echo "</div>";
            echo "</div>";
        }
        ?>
      </div>
    </div>
  </div>
  <div class="row"> 
    <!-- Lado izquierdo: Matriz de iconos de productos -->
    <div class="col-md-7">
      <h3>Productos Disponibles</h3>
		<div class="form-group">
        <input type="text" id="product-filter" class="form-control" onkeyup="filterProducts()" placeholder="Nombre del Producto">
</div>

      <div id="product-grid" class="row" style="max-height: 550px; overflow-y: auto;"></div>
    </div>
    <!-- Lado derecho: Lista de productos seleccionados -->
    <div class="col-md-5">
      <h3>Carrito</h3>
		<label id="tipoClienteLabel" class="text-muted"></label>

      <ul id="product-list" class="list-group">
      </ul>
		
<div class="containerTotal">
    <h3>Productos: <span id="item-count">0</span></h3>
    <div class="col text-right">
        <h3>Total: <span id="total-precio">$0.00</span></h3>
    </div>
</div>

	<input type="text" name="MetodoP" id="selectedPaymentMethodText" class="form-control" value="Efectivo" readonly style="display: none;">
	<div class="form-group">
    <label for="Observaciones">Observaciones:</label>
    <textarea name="Observaciones" id="Observaciones" class="form-control" rows="3"></textarea>
</div>

	
	
	<div class="btn-group btn-block" role="group" aria-label="Basic example">

  <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modalCobro" id="btnCobrar">
  Cobrar
</button>
</div>
	
		
		
    </div>
  </div>
</div>

<script>
<?php
$productos = [
    ["id" => "1",  "codigo" => "101", "descripcion" => "Producto X", "precio" => "$25.00" ],
    ["id" => "2",  "codigo" => "102", "descripcion" => "Producto Y", "precio" => "$30.00" ],
    // Puedes agregar más productos aquí
];
?>	
	
var catalogoProductos = <?php echo json_encode($productos); ?>;	
	
    // Define una lista de productos con ID, nombre, precio, icono y descripción
    
const productGrid = document.getElementById("product-grid");
	// Define la variable selectedProductsArray antes de la función addToCart
const selectedProductsArray = [];
const products = [];
var TotalT=0;
var ItemsT=0;
var listaProductos = [];
	
var totalt;
	document.addEventListener("DOMContentLoaded", function() {
        actualizarCatalogoProductos();
    });
	  $(document).ready(function() {
        // Abre el modal al hacer clic en el botón "Seleccionar Método de Pago"
        $("#selectPaymentMethod").click(function() {
            $('#paymentMethodModal').modal('show');
        });

        // Captura el método de pago seleccionado al hacer clic en "Confirmar"
        $("#confirmPaymentMethod").click(function() {
            var selectedMethod = $("#paymentMethodSelect").val();
		    var selectedMethodName = $("#paymentMethodSelect option:selected").text();



            if (selectedMethod) {
			  $("#selectPaymentMethod").val(selectedMethod).text("Metodo: " + selectedMethodName);
             $('#selectedPaymentMethodText').val(selectedMethodName);
				 $('#paymentMethodModal').modal('hide');
            } else {
                alert("Por favor, selecciona un método de pago.");
            }
        });
    });
	
	
	// JavaScript para crear dinámicamente la matriz de iconos de productos
products.forEach((product) => {
    const productItem = document.createElement("div");
    productItem.className = "col-md-4 product-icon";
    productItem.innerHTML = `
        <i class="fas ${product.icon}"></i><br>${product.name}<br>$${product.precio.toFixed(2)}<br>${product.descripcion}
    `;

    productItem.addEventListener("click", () => {
        addToCart(product);
        productItem.classList.add("active");
    });

    productGrid.appendChild(productItem);
});


	


// Función para agregar productos al carrito
function addToCart(product) {
    const existingProduct = selectedProductsArray.find(p => p.id === product.id);
    if (existingProduct) {
        existingProduct.cantidad++;
    } else {
        const newProduct = {
            id: product.id,
            name: product.name,
            precio: product.precio,
            descripcion: product.descripcion,
            cantidad: 1
        };
        selectedProductsArray.push(newProduct);
    }

    // Actualiza la lista de productos seleccionados
    renderSelectedProducts();
	

    // Actualiza el total después de agregar un producto
    updateTotal();
}
	
	
// Función para eliminar productos de la lista
function removeProduct(id) {
    const productId = id.toString();  // Convierte el id a cadena
    const index = selectedProductsArray.findIndex(product => product.id === productId);
    if (index !== -1) {
        selectedProductsArray.splice(index, 1);
        // Actualiza la lista y el total
        renderSelectedProducts();
        updateTotal();
    }
}

function renderSelectedProducts() {
    const selectedList = document.getElementById("product-list");
    selectedList.innerHTML = '';

    let itemCount = 0; // Inicializamos el contador de items

    selectedProductsArray.forEach(product => {
        itemCount += product.cantidad; // Incrementamos el contador con la cantidad de cada producto
        const listItem = document.createElement("li");
        listItem.className = "list-group-item d-flex justify-content-between align-items-center";
        listItem.innerHTML = `
            <span class="col-md-6">${product.id} - ${product.name}</span>
            <div class="input-group"> 
                <button class="btn btn-cantidad" onclick="decreasecantidad(${product.id})"><i class="fa fa-minus-circle"></i></button>
                <button class="btn btn-cantidad" onclick="increasecantidad(${product.id})"><i class="fa fa-plus-circle"></i></button>
                <input type="text" class="form-control col-md-4 cantidad-input" value="${product.cantidad}" data-product-id="${product.id}" maxlength="3" size="4" onblur="updatecantidad(this)">
                <button class="btn btn-cantidad" onclick="removeProduct(${product.id})"><i class="fa fa-times-circle btn-danger"></i></button>
            </div>
        `;
        selectedList.appendChild(listItem);
    });
     listaProductos=selectedProductsArray;
	console.log(listaProductos);
    // Actualizamos el contador de items en la interfaz
    const itemCountElement = document.getElementById("item-count");
	ItemsT=itemCount;
    itemCountElement.textContent = itemCount;
}


function updatecantidad(input) {
    const productId = input.getAttribute("data-product-id");
    const product = selectedProductsArray.find(p => p.id === productId);
    
    if (product) {
        const newcantidad = parseInt(input.value, 10);
        
        if (!isNaN(newcantidad) && newcantidad > 0) {
            product.cantidad = newcantidad;
        } else {
            // Si la nueva cantidad no es válida, vuelve a establecer la cantidad original
            input.value = product.cantidad;
        }

        // Actualiza la lista y el total
        renderSelectedProducts();
        updateTotal();
    }
}





    // Array para almacenar los productos seleccionados
    
    const totalElement = document.getElementById("total-precio");



    // Función para actualizar el total
    function updateTotal() {
        const total = selectedProductsArray.reduce((acc, product) => acc + product.precio * product.cantidad, 0);
		//console.log(selectedProductsArray);
		totalt=total;
		TotalT=total;
        totalElement.textContent = `$${total.toFixed(2)}`;
    }

    // Manejar la lógica de pago aquí
    // JavaScript para manejar la lógica de pago

   

// Función para aumentar la cantidad de un producto en la lista
function increasecantidad(id) {
    const product = selectedProductsArray.find(p => p.id === id.toString());
    if (product) {
        product.cantidad++;
        renderSelectedProducts();
        updateTotal();
    }
}

// Función para disminuir la cantidad de un producto en la lista
function decreasecantidad(id) {
    const product = selectedProductsArray.find(p => p.id === id.toString());
    if (product && product.cantidad > 1) {
        product.cantidad--;
        renderSelectedProducts();
        updateTotal();
    }
}

// 
	
	
var productos;
var precio=3;

	
function cliente(id, nombre) {
	console.log(id+" "+nombre);
	//console.log(catalogoProductos);
	// Supongamos que tu arreglo se llama "arreglo"
 	var arregloFiltrado = catalogoProductos.filter(function(item) {
        return item.categoria === nombre;
    });
	
	if(id=='Todo*') arregloFiltrado=catalogoProductos;

    // Ahora "arregloFiltrado" contendrá solo los elementos cuya categoría coincida con "nombre"
    console.log(arregloFiltrado);
    // Vacía el contenido de productGrid antes de agregar nuevos productos
    productGrid.innerHTML = "";
	const products = arregloFiltrado;
			productos=products;
	

            products.forEach((product) => {
                const productItem = document.createElement("div");
                productItem.className = "col-md-3 product-icon";
                productItem.innerHTML = `
                    <i class="fas ${product.icono}"></i><br>${product.id} - ${product.codigo}<br>${product.descripcion}<br>${product.precio}`;

                // Al hacer clic en el icono, asigna las variables a las funciones correspondientes
                productItem.addEventListener("click", () => {
                    // Asegúrate de que addToCart reciba las variables correctas
                    addToCart({
                        id: product.id,
                        name: product.descripcion,
                        precio: parseFloat(product.precio),
                        descripcion: product.descripcion
                    });
                    productItem.classList.add("active");
                });

                productGrid.appendChild(productItem);
            });
        
   
}

function actualizarCatalogoProductos() {	
$.ajax({
    url: ' <?php echo $urlajaxproductos; ?>', // Ruta al script PHP
    method: 'POST',
    dataType: 'json',
success: function (data) {
  //console.log('test:',data);

  // Convertir el objeto a un array de valores
  var arrayDatos = Object.values(data);

  // Verificar que arrayDatos se haya inicializado correctamente
  //console.log('Array de datos:', arrayDatos);

  // Llamar a la función para procesar los datos en el formato esperado
   catalogoProductos = convertirFormatoProductos(arrayDatos);
   console.log('Catalogo de productos:', catalogoProductos);

  // Resto de tu código...
},
    error: function (error) {
      console.error('Error al obtener los productos:', error);
    }
  });
	}	
	
	

	function convertirFormatoProductos(data) {
    var productosConvertidos = [];

    // Iterar sobre los productos recibidos
    data.forEach(function (producto) {
        var icono = ""; // Inicializa icono como una cadena vacía
        try {
            // Intenta parsear el JSON y obtener el icono
            var iconoJSON = JSON.parse(producto[5]);
            if (iconoJSON && iconoJSON.icono) {
                icono = iconoJSON.icono; // Asigna el valor del icono
            }
        } catch (error) {
            console.error('Error al parsear el JSON del icono:', error);
        }

        // Ajusta las claves y tipos según la estructura real de tus datos
        productosConvertidos.push({
            id: String(producto[0]),
            codigo: String(producto[1]),
            descripcion: String(producto[2]),
            precio: parseFloat(producto[3]).toFixed(2),
            categoria: String(producto[4]),
            icono: icono // Asigna el valor del icono
            // Puedes agregar más elementos según sea necesario
        });
    });

    return productosConvertidos;
}

	
	
	
function filterProducts() {
    const input = document.getElementById("product-filter");
    const filter = input.value.toLowerCase();

    const filteredProducts = productos.filter(product => product.descripcion.toLowerCase().includes(filter));

    productGrid.innerHTML = "";

    filteredProducts.forEach(product => {
        const productItem = document.createElement("div");
        productItem.className = "col-md-4 product-icon";
        productItem.innerHTML = `
            <i class="fas ${product.icono}"></i><br>${product.id} - ${product.codigo}<br>${product.descripcion}<br>${product.precio}`;

        productItem.addEventListener("click", () => {
            addToCart({
                id: product.id,
                name: product.descripcion,
                precio: parseFloat(product.precio),
                descripcion: product.descripcion
            });
            productItem.classList.add("active");
        });

        productGrid.appendChild(productItem);
    });
}


</script> 
