<?php
require('tcpdf/tcpdf.php');

class TicketPDF extends TCPDF {
    public function Header() {
        // Encabezado del ticket (puedes agregar un logotipo aquí)
        $this->SetFont('helvetica', 'B', 14);
        $this->Cell(0, 10, 'Ticket de Compra', 0, 0, 'C');
        $this->Ln(10);
    }

    public function Footer() {
        // Número de página
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 8);
        $this->Cell(0, 10, 'Página ' . $this->getAliasNumPage(), 0, 0, 'C');
    }
}

// Crear una instancia de TCPDF personalizada
$pdf = new TicketPDF('P', 'mm', array(80, 297));
$pdf->SetLeftMargin(3); 


// Agregar una página
$pdf->AddPage();

// Contenido del ticket
$pdf->SetFont('helvetica', '', 8);
$pdf->Cell(0, 0, 'Número de Ticket: 12345', 0, 1);
$pdf->Cell(0, 0, 'Fecha: ' . date('Y-m-d H:i:s'), 0, 10);
$pdf->Cell(0, 5, ' ', 0, 10);
$pdf->Cell(0, 2, 'Productos:', 2, 1);
$pdf->SetFont('helvetica', 'B', 8);
$pdf->MultiCell(0, 5, "1. Producto 1 - $10.00\n2. Producto 2 - $20.00\n3. Producto 3 - $15.00", 1, 'L');
$pdf->SetFont('helvetica', '', 14);
$pdf->Cell(0, 10, 'Total: $45.00', 0, 1);

// Generar el PDF
$pdf->Output('ticket.pdf', 'I');
