<?php
session_start();
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Receta Médica PDF</title>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
    }
    #pdf-preview {
      width: 100%;
      height: 600px;
      border: 1px solid #ddd;
    }
  </style>
</head>
<body>
  <h2>Vista Previa de la Receta Médica</h2>
  <iframe id="pdf-preview"></iframe>

  <script>
    const { jsPDF } = window.jspdf;

    
    // Datos JSON proporcionados con saltos de línea sin escapar
let rawJson = <?php echo json_encode($_SESSION[ "datosReceta" ]);?>;
let datosJsonString = rawJson[0].Datos;

// Convertimos la cadena JSON dentro de 'Datos' en un objeto JavaScript
let recetaData = JSON.parse(datosJsonString);

// Parche para reemplazar los saltos de línea no escapados (\n) con \\n
let patchedJson = recetaData.instrucciones.replace(/\\n/g, '\\\\n'); // Reemplazar los saltos de línea sin escapar

// Actualizamos el campo de instrucciones en recetaData
recetaData.instrucciones = patchedJson;

// Ahora puedes trabajar con recetaData
console.log(recetaData);


    function generatePDF() {
      const doc = new jsPDF({
        format: "a5",
        orientation: "landscape"
      });

      const bannerURLA = "http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_A.png";
	  const bannerURLP = "http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_P.png";

      // Agregar banner superior solo en la primera página
      doc.addImage(bannerURLA, "PNG", 0, 0, 210, 24);

      // Datos del paciente y doctor
      const startY = 30;

      doc.setFont("helvetica", "normal");
      doc.setFontSize(10);
      doc.text(`Paciente: ${recetaData.paciente.nombre}`, 10, startY);
      doc.text(`Fecha: ${recetaData.paciente.fecha}`, 10, startY + 5);
      doc.text(`Edad: ${recetaData.paciente.edad}  |  Peso: ${recetaData.paciente.peso}`, 10, startY + 10);
      doc.text(`Teléfono: ${recetaData.paciente.telefono}`, 10, startY + 15);

      doc.text(`Doctor: ${recetaData.doctor.nombre}`, 150, startY);
      doc.text(`Especialidad: ${recetaData.doctor.especialidad}`, 150, startY + 5);
      doc.text(`Cédula: ${recetaData.doctor.cedula}`, 150, startY + 10);

      // Diagnóstico
      let currentY = startY + 25;
      doc.setFont("helvetica", "bold");
      doc.setFontSize(12);
      doc.text("Diagnóstico:", 10, currentY);
      doc.setFont("helvetica", "normal");
      doc.text(recetaData.diagnostico, 10, currentY + 5);

      // Medicamentos organizados con viñetas
      currentY += 15;
      recetaData.medicamentos.forEach((medicamento) => {
        if (currentY > 110) { // Salto de página si se supera el límite
          doc.addPage();
          currentY = 30;
        }

        doc.setFont("helvetica", "bold");
        doc.setFontSize(11);
        doc.text(`• ${medicamento.nombre}`, 10, currentY);

        doc.setFont("helvetica", "normal");
        doc.setFontSize(10);
        doc.text(
          `${medicamento.sustancia} | Cantidad: ${medicamento.cantidad} | Duración: ${medicamento.duracion}`,
          15,
          currentY + 5
        );

        currentY += 15;
      });

      // Instrucciones
      currentY += 15;
      doc.setFont("helvetica", "bold");
      doc.setFontSize(12);
      doc.text("Instrucciones:", 10, currentY);

      doc.setFont("helvetica", "normal");
      doc.setFontSize(10);
      doc.text(recetaData.instrucciones, 10, currentY + 5, { maxWidth: 190 });

      // Generar QR
      const qrCanvas = document.createElement("canvas");
      const qr = new QRious({
        element: qrCanvas,
        value: "http://167.172.224.160/MiSi/",
        size: 80
      });

      doc.addImage(qrCanvas.toDataURL(), "PNG", 180, 95, 30, 30);

      // Agregar banner inferior
      doc.addImage(bannerURLP, "PNG", 0, 125, 210, 24);

      // Convertir PDF en Base64
      const pdfData = doc.output('datauristring');

      // Mostrar el PDF en el iframe
      document.getElementById('pdf-preview').src = pdfData;
    }

    // Generar vista previa al cargar la página
    generatePDF();
  </script>
</body>
</html>
