<?php
session_start();
$_SESSION[ "Contenido" ] = "PacienteExpediente";

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odontograma con Leyenda en PDF</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
</head>
<body> 


    <h1>Vista Previa de Odontograma</h1>
    <iframe id="pdfPreview" src="" frameborder="0" style="width: 100%; height: 600px;"></iframe>



    <script>
        document.addEventListener("DOMContentLoaded", () => { 
            const { jsPDF } = window.jspdf;
            const doc = new jsPDF({
                orientation: "portrait",
                unit: "mm",
                format: "letter",
            });

            // Tamaño de los cuadros, segmentos y espaciado
            const cellSize = 9;
            const segmentSize = cellSize / 3;
            const spacing = 1;
            const fontSize = 4;

            // Dimensiones de la hoja tamaño carta
            const pageWidth = 216;
            const pageHeight = 279;
            const sideMargin = 15;

      
            doc.addImage('http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_A.png', 'JPEG', 0, 0, pageWidth, 25);
			
			
            // Pie de página del PDF
            doc.addImage('http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_P.png', 'JPEG', 0, pageHeight-25 , pageWidth,25);
			
            // Datos del odontograma
            const odontogramaData = <?php echo $_SESSION[ "datosODO" ][0]["Datos"];?>;
            const colorMapping = {
                "caries": "red",
                "fractura": "orange",
                "obturado": "blue",
                "extraccion": "black",
                "vacio": "white"
            };

            // Datos de las filas con los números de los dientes
            const rows = [
                [18, 17, 16, 15, 14, 13, 12, 11, 21, 22, 23, 24, 25, 26, 27, 28],
                [48, 47, 46, 45, 44, 43, 42, 41, 31, 32, 33, 34, 35, 36, 37, 38],
                [],
                [55, 54, 53, 52, 51, 61, 62, 63, 64, 65],
                [85, 84, 83, 82, 81, 71, 72, 73, 74, 75]
            ];

            const totalWidthTopRow = rows[0].length * (cellSize + spacing) - spacing;
            const totalWidthBottomRow = rows[3].length * (cellSize + spacing) - spacing;
            const startXTop = Math.max((pageWidth - totalWidthTopRow) / 2, sideMargin);
            const startXBottom = Math.max((pageWidth - totalWidthBottomRow) / 2, sideMargin);
            const startY = 40;
            const rowSpacing = 8;

            let currentY = startY;

            rows.forEach((row, rowIndex) => {
                if (row.length === 0) {
                    currentY += cellSize + rowSpacing;
                    return;
                }

                const isTopRow = rowIndex < 2;
                const startX = isTopRow ? startXTop : startXBottom;
                let currentX = startX;

                row.forEach((number) => {
                    const toothData = odontogramaData[number]?.caras || {};

                    // Función para dibujar segmento solo si tiene color válido
                    const drawSegment = (x, y, color) => {
                        if (color) {
                            doc.setFillColor(color);
                            doc.rect(x, y, segmentSize, segmentSize, "F");
                        }
                    };

                    drawSegment(currentX + segmentSize, currentY, colorMapping[toothData.superior]); // Superior
                    drawSegment(currentX + 2 * segmentSize, currentY + segmentSize, colorMapping[toothData.distal]); // Derecho
                    drawSegment(currentX + segmentSize, currentY + 2 * segmentSize, colorMapping[toothData.inferior]); // Inferior
                    drawSegment(currentX, currentY + segmentSize, colorMapping[toothData.mesial]); // Izquierdo
                    drawSegment(currentX + segmentSize, currentY + segmentSize, colorMapping[toothData.bucal]); // Central

                    doc.setDrawColor(0, 0, 0);
                    doc.rect(currentX, currentY, cellSize, cellSize);

                    doc.setFontSize(fontSize);
                    doc.text(String(number), currentX + cellSize / 2, currentY + cellSize + 2.5, {
                        align: "center",
                    });

                    currentX += cellSize + spacing;
                });

                currentY += cellSize + rowSpacing;
            });
		
		 // Agregar Título de la Tabla
          
            doc.setFontSize(16);
            doc.setTextColor(0, 0, 0);
            doc.text("Odontograma", 95, pageHeight - 245);

		
		

            // Leyenda de colores
            const legendStartY = pageHeight - 60; // Espacio para la leyenda
            const legendStartX = sideMargin;
            const legendSpacingY = 8;
            const legendColors = [
                { color: "red", label: "Caries" },
                { color: "orange", label: "Fractura" },
                { color: "blue", label: "Obturación" },
                { color: "black", label: "Pérdida Temprana" },
                { color: "white", label: "Sin Daño" },
            ];

            doc.setFontSize(10);
            doc.text("Leyenda de Colores:", legendStartX, legendStartY);

            legendColors.forEach((item, index) => {
                const y = legendStartY + (index + 1) * legendSpacingY;

                if (item.color) {
                    doc.setFillColor(item.color);
                    doc.rect(legendStartX, y - 4, 6, 6, "F");
                } else {
                    doc.setDrawColor(0, 0, 0);
                    doc.rect(legendStartX, y - 4, 6, 6); // Cuadro vacío
                }

                doc.text(item.label, legendStartX + 10, y);
            });

            // Agregar Título de la Tabla
            const tableStartY = pageHeight - 130;
            doc.setFontSize(12);
            doc.setTextColor(0, 0, 0);
         

           // Datos de la tabla
const tableData = [
    ["", ""],
    ["", ""],
    ["", ""],
    ["", ""],
];

const tableWidth = 180; // Ancho total de la tabla
const columnWidth = tableWidth / 2; // Ancho de cada columna
const headerHeight = 10; // Altura del encabezado
const rowHeight = 12; // Altura de las filas
let currentYTable = tableStartY ; // Posición inicial de la tabla

// Títulos de las columnas con fondo gris
doc.setFillColor(200, 200, 200); // Gris claro
doc.rect(15, currentYTable, columnWidth, headerHeight, "F");
doc.rect(15 + columnWidth, currentYTable, columnWidth, headerHeight, "F");

// Títulos de las columnas
doc.setFontSize(10);
doc.setTextColor(0, 0, 0); // Color del texto
doc.text("Tratamiento", 20, currentYTable + 6);
doc.text("Presupuesto", 20 + columnWidth, currentYTable + 6);

currentYTable += headerHeight; // Desplazamos hacia abajo para las filas

// Dibujar celdas de datos
tableData.forEach(row => {
    // Dibujar las celdas
    doc.rect(15, currentYTable, columnWidth, rowHeight); // Columna 1
    doc.rect(15 + columnWidth, currentYTable, columnWidth, rowHeight); // Columna 2

    // Insertar los datos dentro de las celdas
    doc.setTextColor(0, 0, 0); // Color del texto
    doc.text(row[0], 20, currentYTable + 8); // Texto para "Tratamiento"
    doc.text(row[1], 20 + columnWidth, currentYTable + 8); // Texto para "Presupuesto"

    currentYTable += rowHeight; // Desplazamos hacia abajo para la siguiente fila
});

		
		// Datos de la tabla de Firma
const tableFirmaData = [
    ["Nombre y Firma del Odontologo", ""],
];

// Modificar el ancho y la posición para la tabla de Firma
const tableFirmaWidth = 90; // Ancho total de la tabla de firma
const firmaColumnWidth = tableFirmaWidth / 2; // Ancho de cada columna
const firmaStartX = 105; // Posición en X para la tabla de firma
let currentYFirma = tableStartY+70; // Posición inicial de la tabla de firma

// Títulos de las columnas para la tabla de firma con fondo gris
doc.setFillColor(200, 200, 200); // Gris claro
doc.rect(firmaStartX, currentYFirma, firmaColumnWidth, headerHeight, "F");
doc.rect(firmaStartX + firmaColumnWidth, currentYFirma, firmaColumnWidth, headerHeight, "F");
		
doc.rect(firmaStartX, currentYFirma+15, firmaColumnWidth, headerHeight, "F");
doc.rect(firmaStartX + firmaColumnWidth, currentYFirma+15, firmaColumnWidth, headerHeight, "F");

// Títulos de las columnas
doc.setFontSize(7);
doc.setTextColor(0, 0, 0); // Color del texto
doc.text("Nombre y Firma Parciente", firmaStartX + 5, currentYFirma + 6); // Título de la columna "Firma"
		
doc.text("Nombre y Firma Parciente", firmaStartX + 5, currentYFirma + 21); // Título de la columna "Firma"		

currentYFirma += headerHeight; // Desplazamos hacia abajo para las filas


 
            // Generar el PDF y visualizarlo en un iframe
            const pdfDataUri = doc.output("datauristring");
            document.getElementById("pdfPreview").src = pdfDataUri;
        });
    </script>
</body>
</html>
