<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Ficha Clínica PDF - Vista Previa</title>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.15/jspdf.plugin.autotable.min.js"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
    }
    #pdfPreview {
      width: 100%;
      height: 600px;
      border: 1px solid #ccc;
      margin-top: 20px;
    }
    button {
      padding: 10px 20px;
      font-size: 16px;
      cursor: pointer;
    }
  </style>
</head>
<body>
  <h1>Vista Previa de Ficha Clínica</h1>

  <iframe id="pdfPreview" src="" frameborder="0"></iframe>
  
  <button id="downloadBtn">Descargar PDF</button>
<?php
	session_start();
// Arreglo de ejemplo
 $data = $_SESSION[ "datosHC" ];
//print_r($data);
// Extraer y reorganizar los datos
// Paso 1: Extraer la sección "Datos" del arreglo y decodificarlo como JSON
$datosJSON = json_decode($data[0]['Datos'], true); // Convertimos "Datos" en un array PHP

// Paso 2: Hacer una salida JSON final con formato dinámico
 $jsonData = json_encode($datosJSON, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>

  <script>
    const jsonData = <?php echo $jsonData;?>;

    const { jsPDF } = window.jspdf;

    function generatePDF() {
      const doc = new jsPDF();
       const bannerURLA = "http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_A.png";
		 const bannerURLP = "http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_P.png";
      doc.addImage(bannerURLA, "PNG", 10, 10, 190, 24);

      const tablePositions = [
        { section: "Ficha Identificación", startX: 10, startY: 40, fullWidth: true },
        { section: "Motivo de Consulta", startX: 110, startY: 120, fullWidth: false },
        { section: "Antecedentes personales no patológicos", startX: 110, startY: 140, fullWidth: false },
        { section: "Hábitos", startX: 110, startY: 230, fullWidth: false },
        { section: "Antecedentes personales patológicos", startX: 10, startY: 120, fullWidth: false },
        { section: "Antecedentes patológicos y hereditarios", startX: 10, startY: 30, fullWidth: true },
        { section: "Condiciones Femeninas", startX: 10, startY: 80, fullWidth: false },
        { section: "Consentimiento Informado", startX: 110, startY: 80, fullWidth: false },
        { section: "Términos de Consentimiento", startX: 10, startY: 150, fullWidth: true }
      ];

      tablePositions.forEach((config) => {
        const { section, startX, startY, fullWidth } = config;
        const content = jsonData[section];

        doc.setFont("helvetica", "bold");
        doc.setFontSize(12);
        doc.text(section, startX, startY);

        const tableData = Object.entries(content).map(([key, value]) => [
          key.replace(/_/g, " "),
          Array.isArray(value) ? value.join(", ") : typeof value === "boolean" ? (value ? "Sí" : "No") : value
        ]);

        doc.autoTable({
          body: tableData,
          startY: startY + 5,
          theme: "striped",
          styles: { fontSize: 10 },
          margin: { left: startX },
          tableWidth: fullWidth ? 190 : 90
        });

        if (doc.lastAutoTable.finalY > 270) {
          doc.addPage();
        }
      });

      doc.addImage(bannerURLP, "PNG", 10, 270, 190, 24);

      // Generar el PDF como blob y mostrarlo en el iframe
      const pdfOutput = doc.output("bloburl");
      document.getElementById("pdfPreview").src = pdfOutput;
    }

    // Llamar a la función para generar el PDF al cargar la página
    window.onload = generatePDF;

    // Descargar PDF cuando se haga clic en el botón
    document.getElementById("downloadBtn").addEventListener("click", () => {
      const doc = new jsPDF();
      const bannerURL = "http://167.172.224.160/MiSi/librerias/Archivos/BAN/800x100.png";
      doc.addImage(bannerURL, "PNG", 10, 10, 190, 24);
      
      // Repetir el proceso de generación de PDF (omitido por brevedad)
      
      doc.save("Ficha_Clinica.pdf");
    });
  </script>
</body>
</html>
