<?php
session_start();
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Cotización PDF</title>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
    }
    #pdf-preview {
      width: 100%;
      height: 600px;
      border: 1px solid #ddd;
    }
  </style>
</head>
<body>
  <h2>Vista Previa de la Cotización</h2>
  <iframe id="pdf-preview"></iframe>

  <script>
    const { jsPDF } = window.jspdf;

// Datos JSON proporcionados con saltos de línea sin escapar
let rawJson = <?php echo json_encode($_SESSION["datosCotizacion"]); ?>;
let datosJsonString = rawJson[0].Datos;

// Convertimos la cadena JSON dentro de 'Datos' en un objeto JavaScript
let cotizacionData = JSON.parse(datosJsonString);

// Parche para reemplazar los saltos de línea no escapados (\n) con \\n
let patchedJson = cotizacionData.map(item => {
  if (item.descripcion) {
    item.descripcion = item.descripcion.replace(/\\n/g, '\\\\n'); // Reemplazar saltos de línea sin escapar
  }
  return item;
});

// Ahora puedes trabajar con cotizacionData
console.log(cotizacionData);

function generatePDF() {
  // Configuramos la página en formato media carta (5.5 x 8.5 pulgadas) en orientación horizontal
  const doc = new jsPDF({
    format: [210, 127],  // Medidas en milímetros de media carta (5.5 x 8.5 pulgadas)
    orientation: "landscape"  // Configuramos en orientación horizontal
  });

   const bannerURLA = "http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_A.png";
   const bannerURLP = "http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_P.png";

  // Agregar banner superior solo en la primera página
  doc.addImage(bannerURLA, "PNG", 0, 0, 210, 24);

  // Datos de la cotización
  const startY = 30;
  doc.setFont("helvetica", "normal");
  doc.setFontSize(12);

  doc.text(`ID de Cotización: ${rawJson[0].IDPa}`, 10, startY);
  doc.text(`Fecha: ${rawJson[0].TimeStamp}`, 10, startY + 5);
  doc.text(`Observaciones: ${rawJson[0].Observaciones}`, 10, startY + 10);

  // Productos de la cotización
  let currentY = startY + 20;
  doc.setFont("helvetica", "bold");
  doc.text("Productos Cotizados:", 10, currentY);

  // Lista de productos
  currentY += 10;
  patchedJson.forEach((producto) => {
    if (currentY > 260) { // Salto de página si se supera el límite
      doc.addPage();
      currentY = 30;
    }

    doc.setFont("helvetica", "normal");
    doc.setFontSize(10);
    doc.text(`- ${producto.descripcion}`, 10, currentY);
    doc.text(`Cantidad: ${producto.cantidad} | Precio Unitario: $${producto.precio_unitario} | Total: $${producto.total}`, 15, currentY + 5);

    currentY += 15;
  });

  // Total de la cotización
  const total = patchedJson.reduce((acc, item) => acc + item.total, 0);
  currentY += 15;
  doc.setFont("helvetica", "bold");
  doc.text(`Total: $${total}`, 10, currentY);

  // Generar QR
  const qrCanvas = document.createElement("canvas");
  const qr = new QRious({
    element: qrCanvas,
    value: "http://167.172.224.160/MiSi/",
    size: 80
  });

  

  // Agregar banner inferior
  doc.addImage(bannerURLP, "PNG", 0, 105, 210, 24);

  // Convertir PDF en Base64
  const pdfData = doc.output('datauristring');

  // Mostrar el PDF en el iframe
  document.getElementById('pdf-preview').src = pdfData;
}

// Generar vista previa al cargar la página
generatePDF();

  </script>
</body>
</html>
