<?php

class NtfyNotifier {
    private $server;
    private $topic;

    public function __construct($server, $topic) {
        $this->server = $server;
        $this->topic = $topic;
    }

    public function sendNotification($message) {
        $url = "$this->server/$this->topic";
        $headers = ['Content-Type: text/plain'];

        $options = [
            'http' => [
                'method'  => 'POST',
                'header'  => implode("\r\n", $headers),
                'content' => $message
            ]
        ];

        $context = stream_context_create($options);
        $response = file_get_contents($url, false, $context);

        return $response !== FALSE ? "✅ Notificación enviada correctamente" : "❌ Error al enviar la notificación";
    }
}

?>
