
<!-- Modal Placeholder -->
<div id="modalContainer"></div>

<script>
    // Convertir el arreglo PHP a JSON y asignarlo a una variable en JavaScript
    const orders = <?php echo json_encode($datos); ?>;

    // Función para convertir saltos de línea a <br> tags
    function nl2br(str) {
        return str.replace(/\n/g, '<br>');
    }

	function TablaPaginaMensaje(id) {
    // Convertir id a cadena
    const idStr = id.toString();
    console.log('ID recibido:', id, 'Tipo:', typeof id);

    // Verificar el contenido de orders
    console.log('Contenido de orders:', orders);

    // Buscar el pedido en el arreglo
    const order = orders.find(order => {
        console.log(`Comparando ID: order.id = ${order.id} (${typeof order.id}) con id recibido = ${idStr} (${typeof idStr})`);
        return order.id === idStr;
    });

    console.log('Pedido encontrado:', order);

    if (order) {
        try {
            // Limpiar caracteres de escape adicionales y parsear el mensaje JSON
            const cleanedMessage = order.Mensaje.replace(/\\n/g, '').replace(/^"|"$/g, '');
            const orderData = JSON.parse(cleanedMessage);
            console.log('Datos del pedido:', orderData);

            // Construir el contenido del modal
            const modalContent = `
                <div class="modal fade" id="infoModal" tabindex="-1" aria-labelledby="infoModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="infoModalLabel">Información del Pedido</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <h6>Cliente</h6>
                                <p>${nl2br(orderData.client.replace(/u00e9/g, 'é').replace(/u00f3/g, 'ó'))}</p>
                                
                                <h6>Tipo de Entrega</h6>
                                <p>${orderData.deliveryType}</p>
                                
                                <h6>Observaciones</h6>
                                <p>${orderData.observations}</p>
                                
                                <h6>Productos</h6>
                                <ul class="list-group">
                                    ${orderData.products.map(product => `
                                        <li class="list-group-item">
                                            <strong>${product.name}</strong><br>
                                            Precio: $${product.price}
                                        </li>
                                    `).join('')}
                                </ul>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                            </div>
                        </div>
                    </div>
                </div>
            `;

            // Insertar el contenido del modal en el contenedor
            document.getElementById('modalContainer').innerHTML = modalContent;

            // Mostrar el modal
            $('#infoModal').modal('show');
        } catch (error) {
            console.error('Error al parsear el mensaje JSON:', error);
        }
    } else {
        console.error('Pedido no encontrado');
    }
}

</script>
