<?php 
  $urlajaxSelectInfoV= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
?><div class="modal fade" id="modalNotaVenta" tabindex="-1" aria-labelledby="modalNotaVentaLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalNotaVentaLabel">Nota de Venta</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Card de Datos del Cliente -->
                <div class="card border-primary">
                    <div class="card-header bg-light border-primary text-primary">
                        <i class="fa fa-user"></i> <strong>Datos del Cliente</strong>
                    </div>
                    <div class="card-body" id="datosCliente">
                        <div class="row">
                            <div class="col-md-6">
                                <p class="card-title fw-bold"><i class="fa fa-id-card"></i> Nombre:</p>
                                <p class="card-text"><i class="fa fa-phone"></i> Teléfono:</p>
                                <p class="card-text"><i class="fa fa-id-badge"></i> ID Cliente:</p>
                                <p class="card-text"><i class="fa fa-exclamation-circle"></i> Observaciones:</p>
                            </div>
                            <div class="col-md-6">
                                <p class="card-text"><i class="fa fa-calendar"></i> Fecha:</p>
                                <p class="card-text"><i class="fa fa-info-circle"></i> Estado:</p>
                                <p class="card-text"><i class="fa fa-key"></i> Token:</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Card de Datos de la Nota -->
                <div class="card border-success mt-3">
                    <div class="card-header bg-light border-success text-success">
                        <i class="fa fa-receipt"></i> <strong>Datos de la Nota</strong>
                    </div>
                    <div class="card-body" id="datosNota">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Cantidad</th>
                                    <th>Descripción</th>
                                    <th>Precio</th>
                                </tr>
                            </thead>
                            <tbody id="tablaProductos">
                                <!-- Aquí se llenarán los productos dinámicamente -->
                            </tbody>
                        </table>
                        <p class="text-end fs-4 fw-bold"><strong>Total:</strong> <span class="text-dark" id="totalNota">$0.00</span></p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Cerrar</button>
            </div>
        </div>
    </div>
</div>

<script>
function TablaInformacionV(id) {
    var myModal = new bootstrap.Modal(document.getElementById('modalNotaVenta'));
    myModal.show();
    generarContenidoModal(id);
}

function generarContenidoModal(id) {
    var formData1 = {
        id: id,
        nco: 1, 
        funcion: "selectM"
    };

    //Consulta 1
    $.ajax({
        url: '<?php echo $urlajaxSelectInfoV; ?>',
        type: 'POST',
        data: formData1,
        success: function(response) {
            // Parsea la respuesta JSON
            var data1 = JSON.parse(response);
            console.log(data1);

            // Llenar datos del cliente
            $('#datosCliente .card-title').html('<i class="fa fa-id-card"></i> Nombre: ' + data1[0].Nombre);
            $('#datosCliente .card-text:eq(0)').html('<i class="fa fa-phone"></i> Teléfono: ' + data1[0].Telefono);
            $('#datosCliente .card-text:eq(1)').html('<i class="fa fa-id-badge"></i> ID Cliente: ' + data1[0].IDC);
            $('#datosCliente .card-text:eq(2)').html('<i class="fa fa-key"></i> Token: ' + data1[0].Token);
            $('#datosCliente .card-text:eq(3)').html('<i class="fa fa-calendar"></i> Fecha: ' + data1[0].TimeStamp);
            $('#datosCliente .card-text:eq(4)').html('<i class="fa fa-exclamation-circle"></i> Observaciones: ' + data1[0].Observaciones);
            $('#datosCliente .card-text:eq(5)').html('<i class="fa fa-info-circle"></i> Estado: ' + data1[0].Estado);

            // Mostrar total de la nota
            $('#totalNota').html('$' + data1[0].Total.toFixed(2));
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });

    //Consulta 2
    var formData2 = {
        id: id,
        nco: 2,
        funcion: "selectM"
    };

    $.ajax({
        url: '<?php echo $urlajaxSelectInfoV; ?>',
        type: 'POST',
        data: formData2,
        success: function(response) {
            // Parsea la respuesta JSON
            var data2 = JSON.parse(response);
            console.log(data2);

            // Llenar tabla de productos
            $('#tablaProductos').empty();
            $.each(data2, function(index, item) {
                var row = '<tr>';
                row += '<td>' + item.Cantidad + '</td>';
                row += '<td>' + item.Descrpicion + '</td>';
                row += '<td>$' + item.Precio + '</td>';
                row += '</tr>';
                $('#tablaProductos').append(row);
            });
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}
</script>
