<?php 
	//print_r($datosReporte);
?>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.25/jspdf.plugin.autotable.min.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.5);
        }
        .modal-content {
            background-color: white;
            margin: 10% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-height: 80%;
            overflow: auto;
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        iframe {
            width: 100%;
            height: 500px;
            border: none;
        }
    </style>
</head>
<body>
   

    <!-- Modal -->
    <div id="pdfModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <iframe id="pdfPreview"></iframe>
        </div>
    </div>

    <?php
	$datosReporte = $db->tablasDB2( $Reporte );
    // PHP para definir el arreglo
    $data = $datosReporte;
    ?>
    
    <script>
        document.getElementById('mmreporte').addEventListener('click', () => {
            const { jsPDF } = window.jspdf;

            // Obtener los datos de PHP
            const data = <?php echo json_encode($data); ?>;

            // Agrupar por estado (Conjunto_B)
            const groupedData = data.reduce((acc, item) => {
                acc[item.Conjunto_B] = acc[item.Conjunto_B] || [];
                acc[item.Conjunto_B].push(item);
                return acc;
            }, {});

            // Crear el PDF
            const pdf = new jsPDF();
            pdf.setFontSize(16);
            pdf.text('Reporte de Servicios', 105, 10, { align: 'center' });

            let startY = 20;
            let grandTotal = 0;

           Object.keys(groupedData).forEach((key) => {
    const items = groupedData[key];
    let subtotal = 0;

    // Sección del grupo
    pdf.setFontSize(14);
    pdf.setTextColor(0, 0, 255); // Azul
    pdf.text(`Estado: ${key}`, 10, startY);
    startY += 10;

    // Tabla del grupo
    pdf.autoTable({
        head: [['IDN', 'Nombre', 'Descripción', 'Precio', 'Observaciones']],
        body: items.map(item => {
            // Asegurarse de que Precio sea numérico
            const precio = parseFloat(item.Precio) || 0;
            subtotal += precio;
            return [item.IDN, item.Nombre, item.Descrpicion, `$${precio.toFixed(2)}`, item.Observaciones];
        }),
        startY: startY,
        theme: 'striped',
    });

    startY = pdf.lastAutoTable.finalY + 10;

    // Subtotal del grupo
    pdf.setFontSize(12);
    pdf.setTextColor(0, 128, 0); // Verde
    pdf.text(`Subtotal (${key}): $${subtotal.toFixed(2)}`, 10, startY);
    startY += 10;

    grandTotal += subtotal;
});

// Gran total
pdf.setFontSize(14);
pdf.setTextColor(255, 0, 0); // Rojo
pdf.text(`Gran Total: $${grandTotal.toFixed(2)}`, 10, startY);


           
            // Generar el PDF y mostrarlo en el modal
            const pdfData = pdf.output('datauristring');
            const modal = document.getElementById('pdfModal');
            const iframe = document.getElementById('pdfPreview');
            iframe.src = pdfData;
            modal.style.display = 'block';
        });

        // Cerrar el modal
        document.querySelector('.close').addEventListener('click', () => {
            document.getElementById('pdfModal').style.display = 'none';
        });
    </script>
