    <style>
        .modal-body {
            
            overflow-y: auto;
        }
    </style>
<!-- Modal -->
<div class="modal fade" id="compraModal" tabindex="-1" role="dialog" aria-labelledby="compraModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="compraModalLabel">Lista de Compras</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Contenido del formulario de compra -->
                <div class="row page-titles mx-0">
                    <h2>Lista de Compras</h2>

                    <div id="grupo-1" class="input-group mb-3">
                        <span class="input-group-text">1</span>
                        <input type="number" class="form-control col-1 cantidad" placeholder="Cantidad" min="0" max="999" maxlength="3">
                        <select id="selectProducto" class="form-control col descripcion" placeholder="Descripción"></select>
                        <input type="number" class="form-control col-2 precio" placeholder="Precio">
                        <span class="input-group-text">$</span>
                        <input type="text" class="form-control col-2 monto" placeholder="Monto" readonly>
                        <input type="hidden" class="selected-option">
                    </div>

                    <div class="input-group mb-3 agregados"></div>

                    <div class="input-group justify-content-end">
                        <div class="input-group-prepend ml-auto">
                            <button class="btn btn-outline-primary agregar btn-lg" type="button">+</button>
                            <button class="btn btn-outline-primary eliminar btn-lg" type="button">-</button>
                        </div>
                    </div>

                    <div class="input-group mb-3">
                        <span class="input-group-text"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></span>
                        <textarea id="observacionesG" class="form-control observaciones" placeholder="Observaciones" aria-label="Observaciones"></textarea>
                    </div>

                    <div class="input-group mb-3 justify-content-end">
                        <div class="input-group-prepend ml-auto">
                            <span class="input-group-text"><i class="fa fa-usd" aria-hidden="true"></i></span>
                        </div>
                        <input type="text" class="form-control col-2 total" placeholder="Total" aria-label="Total" readonly>
                    </div>

                    <button type="button" class="btn btn-success btn-lg btn-block" id="btnCobrar">Comprar</button>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    function abrirModalCompra() {
        $('#compraModal').modal('show');
    }

    var contador = 1;
    var nota = [];
    var TotalT = 0;
    var ItemsT = 0;
    var listaProductos = [];
    var catalogoProductos = <?php echo json_encode($productos); ?>;

    document.addEventListener('DOMContentLoaded', function() {
        actualizarCatalogoProductos();
        document.querySelector('.agregar').addEventListener('click', agregarGrupo);
        document.querySelector('.eliminar').addEventListener('click', eliminarGrupo);
        document.querySelector('#btnCobrar').addEventListener('click', cobrar);

        function agregarGrupo() {
            contador++;
            var nuevoGrupo = document.getElementById('grupo-1').cloneNode(true);
            nuevoGrupo.id = 'grupo-' + contador;
            nuevoGrupo.querySelector('.input-group-text').textContent = contador;
            nuevoGrupo.querySelector('.cantidad').value = '';
            nuevoGrupo.querySelector('.descripcion').value = '';
            nuevoGrupo.querySelector('.precio').value = '';
            nuevoGrupo.querySelector('.monto').value = '';
            document.querySelector('.agregados').appendChild(nuevoGrupo);
            agregarEventos(nuevoGrupo);
            actualizarNota();
        }

        function eliminarGrupo() {
            if (contador > 1) {
                var ultimoGrupo = document.getElementById('grupo-' + contador);
                ultimoGrupo.parentNode.removeChild(ultimoGrupo);
                contador--;
                actualizarNota();
            }
        }

        agregarEventos(document.getElementById('grupo-1'));

        function agregarEventos(grupo) {
            grupo.querySelector('.cantidad').addEventListener('input', function() {
                calcularMonto(grupo);
            });
            grupo.querySelector('.precio').addEventListener('input', function() {
                calcularMonto(grupo);
            });
            grupo.querySelector('.descripcion').addEventListener('blur', function() {
                actualizarMonto(grupo);
            });
        }

        function calcularMonto(grupo) {
            var cantidad = parseFloat(grupo.querySelector('.cantidad').value) || 0;
            var precio = parseFloat(grupo.querySelector('.precio').value) || 0;
            var monto = cantidad * precio;
            grupo.querySelector('.monto').value = monto.toFixed(2);
            calcularTotal();
            actualizarNota();
        }

        function actualizarMonto(grupo) {
            calcularMonto(grupo);
        }

        function calcularTotal() {
            var total = 0;
            document.querySelectorAll('.monto').forEach(function(montoInput) {
                total += parseFloat(montoInput.value) || 0;
            });
            document.querySelector('.total').value = total.toFixed(2);
            TotalT = total.toFixed(2);
        }

        function actualizarNota() {
            nota = [];
            var codigos = [];
            document.querySelectorAll('.input-group').forEach(function(inputGroup) {
                var cantidadElement = inputGroup.querySelector('.cantidad');
                var descripcionElement = inputGroup.querySelector('.descripcion');
                var precioElement = inputGroup.querySelector('.precio');
                var montoElement = inputGroup.querySelector('.monto');

                if (cantidadElement && descripcionElement && precioElement && montoElement) {
                    var cantidad = cantidadElement.value || 0;
                    var descripcion = descripcionElement.value || '';
                    var precio = precioElement.value || 0;
                    var monto = montoElement.value || 0;
                    var codigo = parseInt(inputGroup.querySelector('.input-group-text').textContent);
                    var id = codigo;
                    if (!codigos.includes(codigo)) {
                        nota.push({ id: id, codigo: codigo, cantidad: cantidad, descripcion: descripcion, precio: precio, monto: monto });
                        codigos.push(codigo);
                        listaProductos = nota;
                    }
                }
            });
            console.log(listaProductos);
            console.log(TotalT);
        }

        function cobrar() {
            var camposVacios = false;
            var inputsCantidad = document.querySelectorAll('.cantidad');
            var inputsDescripcion = document.querySelectorAll('.descripcion');
            var inputsPrecio = document.querySelectorAll('.precio');

            for (var i = 0; i < inputsCantidad.length; i++) {
                var cantidad = inputsCantidad[i].value.trim();
                var descripcion = inputsDescripcion[i].value.trim();
                var precio = inputsPrecio[i].value.trim();

                if (cantidad === '' || descripcion === '' || precio === '') {
                    camposVacios = true;
                    break;
                }
            }

            if (camposVacios) {
                alert('Por favor, complete todos los campos (excepto Observaciones) antes de cobrar.');
            } else {
                $('#modalCobro').modal('show');
            }
        }
    });

    function actualizarCatalogoProductos() {
        $.ajax({
            url: ' <?php echo $urlajaxproductos; ?>',
            method: 'POST',
            dataType: 'json',
            success: function(data) {
                var arrayDatos = Object.values(data);
                catalogoProductos = convertirFormatoProductos(arrayDatos);
                console.log('Catalogo de productos:', catalogoProductos);

                const selectDescripcion = document.querySelector('.descripcion');
                catalogoProductos.forEach(opcion => {
                    const option = document.createElement('option');
                    option.value = opcion.id;
                    option.text = opcion.descripcion;
                    selectDescripcion.add(option);
                });

                selectDescripcion.addEventListener('change', function() {
                    const selectedValue = this.value;
                    document.querySelector('.selected-option').value = selectedValue;
                });
            },
            error: function(error) {
                console.error('Error al obtener los productos:', error);
            }
        });
    }

    function convertirFormatoProductos(data) {
        var productosConvertidos = [];
        data.forEach(function(producto) {
            productosConvertidos.push({
                id: String(producto[0]),
                codigo: String(producto[1]),
                descripcion: String(producto[2]),
                precio: "$" + parseFloat(producto[3]).toFixed(2),
                categoria: String(producto[4]),
                icono: String(producto[5])
            });
        });
        return productosConvertidos;
    }
</script>