<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use PhpOffice\PhpSpreadsheet\IOFactory;

require 'vendor/autoload.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['archivo']) && $_FILES['archivo']['error'] === UPLOAD_ERR_OK) {
        $inputFileName = $_FILES['archivo']['tmp_name'];

        $spreadsheet = IOFactory::load($inputFileName);

        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        // Construir la consulta con todos los datos del archivo
        $columns = $sheetData[1];
        $dataRows = array_slice($sheetData, 1);

        $tableName = 'tabla'; // Reemplaza 'tabla' por el nombre de tu tabla

        $insertValues = [];
        foreach ($dataRows as $row) {
            $values = [];
            foreach ($row as $cell) {
                $values[] = "'" . $cell . "'";
            }
            $insertValues[] = "(" . implode(",", $values) . ")";
        }

        $insertQuery = "INSERT INTO $tableName (" . implode(",", $columns) . ") VALUES " . implode(",", $insertValues);
    } else {
        // Error al subir el archivo
        echo 'Error al subir el archivo.';
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Subir archivo XLS, XLSX a base de Datos</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container">
        <h2>Visualizar archivo XLS en tabla</h2>

        <form method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label for="archivo">Seleccionar archivo XLS:</label>
                <input type="file" class="form-control-file" id="archivo" name="archivo" required>
            </div>
            <button type="submit" class="btn btn-primary">Subir archivo</button>
        </form>

        <?php if (isset($sheetData)): ?>
            <table class="table">
                <thead>
                    <tr>
                        <?php foreach ($sheetData[1] as $column): ?>
                            <th><?php echo $column; ?></th>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach (array_slice($sheetData, 1) as $row): ?>
                        <tr>
                            <?php foreach ($row as $cell): ?>
                                <td><?php echo $cell; ?></td>
                            <?php endforeach; ?>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>

        <?php if (isset($insertQuery)): ?>
            <div class="form-group">
                <label for="consulta">Consulta generada:</label>
                <textarea class="form-control" id="consulta" name="consulta" rows="3" readonly><?php echo $insertQuery; ?></textarea>
            </div>
        <?php endif; ?>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@1.16.1/dist/umd
