<?php
session_start();
$_SESSION["tconf"] = $tconf;
//$ColumnasT = array("", "ID", "IDL", "Monto", "Fecha");
?>

<div id="pagoTablaCreditoRow" class="row page-titles mx-0" style="display: none;">
    <div class="col-lg-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title"><?php echo $tconf; ?></h5>
                <p class="card-description"> Datos </p>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
								 <th></th>
								 <th></th>
                                <?php
                                foreach ($ColumnasT as $valor) {
                                    echo "<th>$valor</th>";
                                }
                                ?>
                               
                            </tr>
                        </thead>
                        <tbody id="tabla-datos">
                            <!-- Aquí se llenarán las filas de la tabla dinámicamente -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function TablaPagoCredito(idcliente) {
        var pagoTablaCreditoRow = document.getElementById('pagoTablaCreditoRow');
        pagoTablaCreditoRow.style.display = 'block';
    }

    const detector = createChangeDetector(0, function (newValue) {
        console.log("El valor ha cambiado a:", newValue);
        cargartabla(newValue);
    });

    function createChangeDetector(initialValue, onChange) {
        let value = initialValue;

        return {
            getValue: function () {
                return value;
            },
            setValue: function (newValue) {
                if (newValue !== value) {
                    value = newValue;
                    if (typeof onChange === 'function') {
                        onChange(value);
                    }
                }
            }
        };
    }

    function cargartabla(cliente) {
        // Realiza una solicitud Ajax para obtener los datos de los clientes
        $.ajax({
            url: '<?php echo $urlajaxselect; ?>' + cliente,
            type: 'POST',
            success: function (data) {
                console.log("-> " + data);
                // Parsea la respuesta JSON
                let datos = JSON.parse(data);
                // Limpia la tabla antes de agregar nuevas filas
                $("#tabla-datos").empty();
                // Itera sobre los datos para construir las filas de la tabla
                $.each(datos, function (index, row) {
                    let fila = "<tr>";
                    // Agregar badge a la columna vacía
                    let tipo = row[4];
                    let badgeColor = '';
                    switch (tipo) {
                        case 'Pago':
                            badgeColor = 'badge-success';
                            // No se agrega el botón de información si el tipo es "Pago"
                            fila += "<td></td>"; // Celda vacía para acciones
                            break;
                        case 'Credito':
                            badgeColor = 'badge-danger';
                            // Agrega el botón de información solo si el tipo es "Crédito"
                            let idn = row[2]; // Suponiendo que el IDN se encuentra en la segunda columna
							
                            fila += "<td><button type='button' data-toggle='modal' data-target='.info' class='btn btn-outline-dark btn-sm' style='background-color: white;' onclick='info(" + idn + ")'><i class='fa fa-info-circle'></i></button></td>";
                            break;
                        default:
                            badgeColor = 'badge-primary';
                            // No se agrega el botón de información si el tipo es otro valor
                            fila += "<td></td>"; // Celda vacía para acciones
                            break;
                    }
                    fila += "<td><span class='badge " + badgeColor + "'> </span></td>";
                    // Itera sobre las columnas de cada fila
                    $.each(row, function (key, value) {
                        fila += "<td>" + value + "</td>";
                    }); 
                    fila += "</tr>";
                    // Agrega la fila a la tabla
                    $("#tabla-datos").append(fila); 
                });
            },
            error: function (error) {
                console.error('Error al obtener datos de clientes:', error);
            }
        });
    }

    // Función para mostrar la información con el IDN como parámetro
    function mostrarInformacion(idn) {
        // Aquí puedes implementar la lógica para mostrar la información
        // Puedes usar un modal, un popover, etc.
        alert("Mostrar información del IDN: " + idn);
    }
</script>

