<style>
    .scrollable-table {
        max-height: 300px; /* Altura máxima de la tabla */
        overflow: auto; /* Hace que la tabla sea scrollable */
    }

    .tooltip-text {
        position: relative;
        display: inline-block;
    }

    .tooltip-text .tooltip-content {
        visibility: hidden;
        width: 120px;
        background-color: #333;
        color: #fff;
        text-align: center;
        border-radius: 6px;
        padding: 5px;
        position: absolute;
        z-index: 1;
        bottom: 125%;
        left: 50%;
        margin-left: -60px;
        opacity: 0;
        transition: opacity 0.3s;
    }

    .tooltip-text:hover .tooltip-content {
        visibility: visible;
        opacity: 1;
    }
</style>

<div class="col-xl-12 col-xxl-12 col-lg-12 col-sm-12">
    <div class="card">
        <div class="card-body">
            <h5 class="card-title"><?php echo $tconf; ?></h5>
            <div class="scrollable-table">
                <?php
                // Nuevo JSON inicial
                $data = json_decode($json_data, true);

                // Verifica si hay datos antes de construir la tabla
                if ($data && is_array($data)) {
                    echo '<table class="table table-bordered">';
                    
                    // Encabezados de la tabla (clientes)
                    echo '<thead><tr>';
                    echo '<th scope="col">Usuarios</th>';
					 echo '<th scope="col">Permisos</th>';
                  
                    echo '</tr></thead>';

                    // Cuerpo de la tabla (usuarios)
                    echo '<tbody>';
                    foreach ($data['usuarios'] as $usuario => $clientes) {
                        echo '<tr>';
                        echo '<th scope="row">' . $usuario . '</th>';
                        foreach ($data['clientes'] as $cliente) {
                            $valor = isset($clientes[$cliente]) ? $clientes[$cliente] : 0;
                            // Agrega checkboxes y utiliza la matriz como nombre y valor del checkbox
                            echo '<td class="tooltip-text" data-usuario="' . $usuario . '" data-cliente="' . $cliente . '"><input type="checkbox" class="checkbox" ' . ($valor ? 'checked' : '') . '><span class="tooltip-content">Usuario: ' . $usuario . '<br>Mesa: ' . $cliente . '</span></td>';
                        }
                        echo '</tr>';
                    }
                    echo '</tbody>';

                    echo '</table>';
                    // Agrega un botón de enviar para enviar el formulario
                    echo '<button type="button" class="btn btn-danger" onclick="regenerarTabla()">Regenerar Tabla</button>';
                    echo '<button type="button" class="btn btn-primary" onclick="generarNuevoJSON()">Guardar Permisos</button>';
                } else {
                    echo '<p>No hay datos disponibles.</p>';
                }
                ?>
            </div>
        </div>
    </div>
</div>

<script>
    function regenerarTabla() {
        // Pregunta al usuario si está seguro de regenerar la tabla
        var confirmacion = confirm('¿Estás seguro de regenerar la tabla?');

        if (confirmacion) {
            $.ajax({
                url: '<?php echo $urlajax;?>',
                type: 'POST',
                data: { consulta: '<?php echo $json_inicial_json;?>' },
                success: function (data) {
                    // Manejar la respuesta del servidor
                    console.log('Respuesta del servidor:', data);
                    setTimeout(function () {
                        location.reload();
                    }, 2000);
                },
                error: function (error) {
                    console.error('Error al enviar la solicitud:', error);
                }
            });
            // Aquí puedes agregar la lógica para regenerar la tabla
            console.log('Tabla regenerada');
        } else {
            console.log('Operación cancelada');
        }
    }

    function generarNuevoJSON() {
        var nuevoJSON = {
            "clientes": <?php echo json_encode($data['clientes']); ?>,
            "usuarios": {}
        };

        // Recorre todos los checkboxes
        $('.checkbox').each(function () {
            var usuario = $(this).closest('td').data('usuario');
            var cliente = $(this).closest('td').data('cliente');
            var valor = $(this).prop('checked') ? 1 : 0;

            // Crea la estructura del nuevo JSON
            if (!nuevoJSON['usuarios'][usuario]) {
                nuevoJSON['usuarios'][usuario] = {};
            }
            nuevoJSON['usuarios'][usuario][cliente] = valor;
        });

        // Muestra el nuevo JSON en un alert
        //alert(JSON.stringify(nuevoJSON, null, 2));
        console.log(JSON.stringify(nuevoJSON, null, 2));
        $.ajax({
            url: '<?php echo $urlajax;?>',
            type: 'POST',
            data: { consulta: JSON.stringify(nuevoJSON, null, 2) },
            success: function (data) {
                // Manejar la respuesta del servidor
                console.log('Respuesta del servidor:', data);
                setTimeout(function () {
                    location.reload();
                }, 20000);
            },
            error: function (error) {
                console.error('Error al enviar la solicitud:', error);
            }
        });
    }
</script>
