
  
  <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
  <style>
    #map {
      width: 100%;
      height: 300px;
      border-radius: 10px;
    }
  </style>

<div class="col-xl-4 col-xxl-6 col-lg-6 col-sm-6">
  <div class="card shadow">
    <div class="card-body">
      <h5 class="card-title mb-3">Selecciona una ubicación</h5>

      <!-- Fila para el mapa -->
      <div class="row mb-3">
        <div class="col-12">
          <div id="map" style="height: 250px; border-radius: 10px;"></div>
        </div>
      </div>

      <!-- Fila para lat/lon -->
     <form id="form-update-<?php echo $tconf; ?>" class="row g-2" method="post">
  <div class="col-md-6">
    <label class="form-label" for="latitud">Latitud</label>
    <input type="text" class="form-control" id="Lat" name="latitud" readonly>
  </div>

  <div class="col-md-6">
    <label class="form-label" for="longitud">Longitud</label>
    <input type="text" class="form-control" id="Lon" name="longitud" readonly>
  </div>

  <!-- …otros campos que ya tuviera tu formulario… -->
</form>


      <!-- Fila para botón -->
      <div class="row mt-3">
        <div class="col-12">
          <button class="btn btn-primary w-100" onclick="guardarCoordenadas()">Guardar</button>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script>
	var urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
  // Inicializar el mapa
  const map = L.map('map').setView([19.2866, -99.6502], 13); // Puedes centrar en Toluca por ejemplo

  L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    maxZoom: 18,
    attribution: '© OpenStreetMap contributors'
  }).addTo(map);

  let marcador;

  map.on('click', function(e) {
    const { lat, lng } = e.latlng;

    // Mostrar coordenadas
    document.getElementById('Lat').value = lat.toFixed(6);
    document.getElementById('Lon').value = lng.toFixed(6);

    // Colocar o mover marcador
    if (marcador) {
      marcador.setLatLng([lat, lng]);
    } else {
      marcador = L.marker([lat, lng]).addTo(map);
    }
  });

  function guardarCoordenadas() {
    const lat = document.getElementById('Lat').value;
    const lng = document.getElementById('Lon').value;
	  let datas = $("#form-update-<?php echo $tconf; ?>").serializeArray();
	  console.log(datas);

    if (lat && lng) {
      alert(`Coordenadas guardadas:\nLatitud: ${lat}\nLongitud: ${lng}`);
		
	
      var columnas = ["Lat", "Lon"];
      var valores = [lat,lng];

      var formDataToSend = {
        id: 0,
        NoCol: 2,
        column: columnas,
        value: valores,
        funcion: "updateMVLA"
      };

      console.log(formDataToSend);
      $.ajax({
        url: urlajaxUpdate,
        type: 'POST',
        data: formDataToSend,
        success: function(response) {
          $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
          setTimeout(function() { $('#Mensaje').empty(); }, 2000);
          console.log(response);
        },
        error: function(error) {
          console.error('Error al enviar datos al servidor:', error);
        }
      });

		
		
    } else {
      alert('Primero haz clic en el mapa para seleccionar una ubicación.');
    }
  }
</script>

