<style>
    body {
        background-color: #f8f9fa;
    }
    .color-preview-bar {
        width: 150px;
        height: 40px;
        border-radius: 5px;
        background-color: #4CAF50;
        /* Color inicial */
        border: 1px solid #ccc;
        cursor: pointer;
        transition: background-color 0.3s ease, transform 0.2s ease;
    }
    .color-preview-bar:hover {
        transform: scale(1.05);
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
    }
    .d-inline-flex-center {
        display: inline-flex;
        align-items: center;
        gap: 10px;
    }
    input[type="color"] {
        display: none;
        /* Ocultar el input de color */
    }
</style>

<div class="container my-3">
    <div class="card p-4 shadow-lg">
        <h4 class="card-title text-center mb-2 text-primary">Selecciona un Color</h4>

        <!-- Contenedor alineado -->
        <div class="d-inline-flex-center justify-content-center">
            <!-- Barra interactiva para seleccionar color -->
            <div id="color-preview-bar" class="color-preview-bar" onclick="openColorPicker()"></div>
            <!-- Input oculto para seleccionar color -->
            <input type="color" id="color-input">
            <!-- Botón para confirmar selección -->
            <button class="btn btn-success" onclick="confirmColor()">Confirmar</button>
        </div>
    </div>
</div>

<script>
    // Variable que almacena el color inicial
    const initialColor = "<?php echo $Color[0]["Color"]; ?>"; // Cambia este valor según el color que quieras predefinir
    const colorInput = document.getElementById("color-input");
    const colorPreviewBar = document.getElementById("color-preview-bar");

    // Configurar el color inicial
    colorInput.value = initialColor;
    colorPreviewBar.style.backgroundColor = initialColor;

    // Abre el selector de color al hacer clic en la barra de vista previa
    function openColorPicker() {
        colorInput.click();
    }

    // Actualizar la barra de vista previa en tiempo real
    colorInput.addEventListener("input", function () {
        const selectedColor = colorInput.value;
        colorPreviewBar.style.backgroundColor = selectedColor;
    });

    // Mostrar el color seleccionado
    function confirmColor() {
        const selectedColor = colorInput.value;
        //alert(`Has seleccionado el color: ${selectedColor}`);
        editarTabla("<?php echo $iduul; ?>", "Color", selectedColor);
    }
</script>

<?php
//UPDATE `MicroSi_Datos`.`1-Catalogo` SET `Codigo` = '11' WHERE (`IDCa` = '1');
$urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

?>
<script>
    function editarTabla(id, columna, valor) {
        // alert("Función editar tabla: " + id + ", " + columna + ", " + valor);

        // Datos a enviar al servidor
        var formData = {
            id: id,
            column: columna,
            value: valor,
            funcion: "update"
        };

        // AJAX para enviar los datos al servidor
        $.ajax({
            url: '<?php echo $urlajaxUpdate; ?>', // Reemplaza con la ruta correcta a tu script del servidor
            type: 'POST',
            data: formData,
            success: function(response) {
                // Maneja la respuesta del servidor
                $("#Mensaje").html(' <div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
                setTimeout(function() {
                    $('#Mensaje').empty();
                }, 2000);

                console.log(response);
            },
            error: function(error) {
                console.error('Error al enviar datos al servidor:', error);
            }
        });
    }

</script>