<?php
session_start();
$_SESSION["tconf"] = $tconf;
?>
<?php include_once("foot.php"); ?>
<?php include_once("head2.php"); ?>
<style>

  #calendar {
    max-width: 1100px;
    margin: 0 auto;
	  font-size: 10px
  }
</style>

<div class="col-xl-4 col-xxl-6 col-lg-6 col-sm-6">
  <div class="card">
    <div class="card-body">
      <h5 class="card-title"><?php echo $tconf; ?></h5>
      <p class="card-description">Calendario</p>
      <div id='calendar'></div>
    </div>
  </div>
</div>

<?php //echo $fechas[0][0]; ?>

<script>
  FullCalendar.globalLocales.push(function () {
    'use strict';

    var es = {
      code: 'es',
      week: {
        dow: 1, // Monday is the first day of the week.
        doy: 4, // The week that contains Jan 4th is the first week of the year.
      },
      buttonText: {
        prev: 'Ant',
        next: 'Sig',
        today: 'Hoy',
        month: 'Mes',
        week: 'Semana',
        day: 'Día',
        list: 'Agenda',
      },
      buttonHints: {
        prev: '$0 antes',
        next: '$0 siguiente',
        today(buttonText) {
          return (buttonText === 'Día') ? 'Hoy' :
            ((buttonText === 'Semana') ? 'Esta' : 'Este') + ' ' + buttonText.toLocaleLowerCase()
        },
      },
      viewHint(buttonText) {
        return 'Vista ' + (buttonText === 'Semana' ? 'de la' : 'del') + ' ' + buttonText.toLocaleLowerCase()
      },
      weekText: 'Sm',
      weekTextLong: 'Semana',
      allDayText: 'Todo el día',
      moreLinkText: 'más',
      moreLinkHint(eventCnt) {
        return `Mostrar ${eventCnt} eventos más`
      },
      noEventsText: 'No hay eventos para mostrar',
      navLinkHint: 'Ir al $0',
      closeHint: 'Cerrar',
      timeHint: 'La hora',
      eventHint: 'Evento',
    };

    return es;

  }());

  document.addEventListener('DOMContentLoaded', function () {

    var calendarEl = document.getElementById('calendar');

    var calendar = new FullCalendar.Calendar(calendarEl, {
      initialView: 'dayGridMonth',
      headerToolbar: {
        left: 'prevYear,prev,next,nextYear today',
        center: 'title',
        right: 'dayGridMonth',
      },
      locale: 'es',

      navLinks: true, // can click day/week names to navigate views
      editable: true,
      dayMaxEvents: true, // allow "more" link when too many events
      events: [] // Elimina los eventos actuales
    });

    calendar.render();

    // Agrega un evento de clic en el día al objeto FullCalendar
    calendar.setOption('dateClick', function (info) {
     var fechaSeleccionada = info.date.toLocaleDateString('es-ES');
      alert('Fecha seleccionada: ' + fechaSeleccionada);
	 // alert(window.location.href + '&fecha=' + fechaSeleccionada);
	window.location.href = window.location.href + '&fecha=' + fechaSeleccionada;
  
    });

  });

</script>
