<?php
// Define gasto fijo mensual en PHP para pasar a JS
$gastoFijoMensual = 6000; // Ejemplo


?>


  <title>Presupuesto Semanal</title>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  
  <script>
    const gastoFijoMensual = totales;
    const gastoFijoDiario = gastoFijoMensual / 30;
    console.log("Gasto fijo mensual:", gastoFijoMensual);
    console.log("Gasto fijo diario:", gastoFijoDiario);
  </script>

<div class="container py-5">
  <h2 class="mb-4 text-center">Presupuesto Semanal</h2>

<?php
// Agrupar registros por día y tipo
$datosPorDia = [];

foreach ($registros as $r) {
    $fecha = $r['Dia'];
    $tipo = $r['TipoMovimiento'];
    $total = $r['Total'];

    if (!isset($datosPorDia[$fecha])) {
        $datosPorDia[$fecha] = [
            "fecha" => $fecha,
            "Cobro" => 0,
            "Pago" => 0
        ];
    }

    if ($tipo === "Cobro") {
        $datosPorDia[$fecha]["Cobro"] += $total;
    } elseif ($tipo === "Pago") {
        $datosPorDia[$fecha]["Pago"] += $total;
    }
}

// Generar arreglo final con cálculos
$datos = [];

foreach ($datosPorDia as $dia) {
    $cobro = $dia["Cobro"];
    $pago = $dia["Pago"];
    $inversion = round($cobro * 0.20, 2);

    $datos[] = [
        "fecha" => $dia["fecha"],
        "Cobro" => $cobro,
        "Pago" => $pago,
        "Inversion" => $inversion,
    ];
}
?>

<table class="table table-bordered text-center">
  <thead class="table-dark">
    <tr>
      <th>Fecha</th>
      <th>Cobros</th>
      <th>Pagos</th>
      <th>Gastos Fijos</th>
      <th>Inversión (20%)</th>
      <th>Total</th>
    </tr>
  </thead>
  <tbody id="tabla-cuerpo"></tbody>
</table>

<!-- Contenedor resumen semanal -->
<div id="resumen-semanal" class="alert alert-info fw-bold fs-5 text-center" style="display:none;"></div>

<div class="row mt-5">
  <div class="col-md-12">
    <canvas id="graficoLinea"></canvas>
  </div>
</div>

<script>
  const gastoFijoDiarioConst = gastoFijoDiario;
  const datosPHP = <?= json_encode($datos) ?>;

  let totalCobros = 0;
  let totalPagos = 0;
  let totalGastosFijos = 0;
  let totalInversion = 0;
  let totalTotal = 0;

  const tbody = document.getElementById("tabla-cuerpo");

  const labels = [];
  const dataCobros = [];
  const dataPagos = [];
  const dataGastosFijos = [];
  const dataInversion = [];
  const dataTotal = [];

  datosPHP.forEach(dia => {
    const gastoFijo = gastoFijoDiarioConst;
    const total = dia.Cobro - dia.Pago - gastoFijo - dia.Inversion;

    totalCobros += dia.Cobro;
    totalPagos += dia.Pago;
    totalGastosFijos += gastoFijo;
    totalInversion += dia.Inversion;
    totalTotal += total;

    labels.push(dia.fecha);
    dataCobros.push(dia.Cobro);
    dataPagos.push(dia.Pago);
    dataGastosFijos.push(gastoFijo);
    dataInversion.push(dia.Inversion);
    dataTotal.push(total);

    const fila = `
      <tr>
        <td>${dia.fecha}</td>
        <td>$${dia.Cobro.toFixed(2)}</td>
        <td>$${dia.Pago.toFixed(2)}</td>
        <td>$${gastoFijo.toFixed(2)}</td>
        <td>$${dia.Inversion.toFixed(2)}</td>
        <td class="fw-bold text-success">$${total.toFixed(2)}</td>
      </tr>
    `;
    tbody.innerHTML += fila;
  });

  // Fila resumen total en tabla
  const filaTotal = `
    <tr class="table-secondary fw-bold">
      <td>Total</td>
      <td>$${totalCobros.toFixed(2)}</td>
      <td>$${totalPagos.toFixed(2)}</td>
      <td>$${totalGastosFijos.toFixed(2)}</td>
      <td>$${totalInversion.toFixed(2)}</td>
      <td class="text-success">$${totalTotal.toFixed(2)}</td>
    </tr>
  `;
  tbody.innerHTML += filaTotal;

  // Mostrar resumen semanal fuera de tabla
  const resumenDiv = document.getElementById("resumen-semanal");
  resumenDiv.style.display = "block";
  resumenDiv.innerHTML = `
    Resumen Semanal: Cobros = $${totalCobros.toFixed(2)}, Pagos = $${totalPagos.toFixed(2)}, 
    Gastos Fijos = $${totalGastosFijos.toFixed(2)}, Inversión = $${totalInversion.toFixed(2)}, 
    <span style="color: ${totalTotal >= 0 ? 'green' : 'red'}">Total Neto = $${totalTotal.toFixed(2)}</span>
  `;

  // Crear gráfico Chart.js
  const ctx = document.getElementById('graficoLinea').getContext('2d');
  const chart = new Chart(ctx, {
    type: 'line',
    data: {
      labels,
      datasets: [
        { label: 'Cobros', data: dataCobros, borderColor: '#0d6efd', fill: false },
        { label: 'Pagos', data: dataPagos, borderColor: '#dc3545', fill: false },
        { label: 'Gastos Fijos', data: dataGastosFijos, borderColor: '#fd7e14', fill: false },
        { label: 'Inversión (20%)', data: dataInversion, borderColor: '#198754', fill: false },
        { label: 'Total', data: dataTotal, borderColor: '#6f42c1', fill: false },
      ]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: 'top' },
        title: { display: true, text: 'Presupuesto Diario' }
      },
      scales: {
        y: { beginAtZero: true }
      }
    }
  });
</script>

</div>

