
  <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/main.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <style>
    .color-columna { width: 2px; }
    .btn-circle {
      width: 48px; height: 48px; border-radius: 50%; padding: 0;
      font-size: 1.2rem; display: flex; align-items: center; justify-content: center;
    }
  </style>

<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3>Pedidos por Fecha</h3>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#calendarioModal">
      <i class="fa fa-calendar"></i> Elegir Fecha
    </button>
  </div>
  <h5 id="fechaSeleccionada" class="text-primary mb-3"></h5>
  <div id="contenedorPedidos"></div>
</div>

<!-- Modal Calendario -->
<div class="modal fade" id="calendarioModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Seleccionar Fecha</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div id="calendario"></div>
      </div>
    </div>
  </div>
</div>

<!-- Modal Info -->
<div class="modal fade" id="infoModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title" style="color: white;">Reporte del Pedido</h5>

        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="infoContenido"></div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/locales-all.min.js"></script>
<script>
const estadoColores = {
  Banco: 'bg-primary', Efectivo: 'bg-success', Pendiente: 'bg-warning',
  Cancelado: 'bg-danger', Entregado: 'bg-success', Abierta: 'bg-warning',
  Cerrar: 'bg-dark', 'En Proceso': 'bg-info', Rechazado: 'bg-danger',
  'Pendiente Pago': 'bg-secondary'
};

const estadoIconos = {
  Banco: 'fa-university', Efectivo: 'fa-money-bill-wave', Pendiente: 'fa-clock',
  Cancelado: 'fa-times', Entregado: 'fa-box', Abierta: 'fa-folder-open',
  Cerrar: 'fa-lock', 'En Proceso': 'fa-cogs', Rechazado: 'fa-ban',
  'Pendiente Pago': 'fa-hourglass-half', default: 'fa-question-circle'
};

let calendar;
$(document).ready(() => {
  calendar = new FullCalendar.Calendar(document.getElementById('calendario'), {
    initialView: 'dayGridMonth',
    locale: 'es',
    dateClick: function(info) {
      cargarPedidos(info.dateStr);
      bootstrap.Modal.getInstance(document.getElementById('calendarioModal')).hide();
    }
  });

  $('#calendarioModal').on('shown.bs.modal', () => calendar.render());
  cargarPedidos(new Date().toISOString().split('T')[0]);
});

function cargarPedidos(fecha) {
  $('#fechaSeleccionada').text('Pedidos del ' + fecha);
  $('#contenedorPedidos').html('<p class="text-center">Cargando...</p>');

  $.ajax({
    url: '../librerias/ajaxAPP/ajaxSimple.php',
    method: 'POST',
    data: { fecha: fecha, id: 2, funcion: 'selectD' },
    dataType: 'json',
    success: function(pedidos) {
		console.log(pedidos);
      if (Array.isArray(pedidos) && pedidos.length > 0) {
        let html = '<table class="table table-bordered table-hover bg-white shadow-sm align-middle">';
        html += '<thead class="table-light"><tr><th class="color-columna"></th><th>ID</th><th>Cliente</th><th>Total</th><th>Estado</th><th></th></tr></thead><tbody>';

        pedidos.forEach(pedido => {
          let contenido = {};
          try {
            contenido = JSON.parse(pedido.contenido);
          } catch(e) {}
          const cliente = contenido?.cliente?.nombre || 'Desconocido';
          const productos = contenido?.productos || [];
          const total = productos.reduce((t, p) => t + (p.precio * p.cantidad), 0);
          const estado = pedido.Estado || 'Pendiente';

          html += `<tr data-id="${pedido.id}" data-contenido='${JSON.stringify(contenido)}' data-estado="${estado}">
            <td class="color-columna"></td>
            <td>${pedido.id}</td>
            <td>${cliente}</td>
            <td>$${total.toFixed(2)}</td>
            <td class="estado-icono text-center"><i class="fa"></i></td>
            <td>
              <div class="d-flex flex-wrap gap-2">
        
                <button class="btn btn-dark btn-circle" onclick="mostrarInfo(this)"><i class="fa fa-info-circle"></i></button>
              </div>
            </td>
          </tr>`;
        });

        html += '</tbody></table>';
        $('#contenedorPedidos').html(html);

        document.querySelectorAll('tbody tr').forEach(row => {
          const estado = row.dataset.estado || 'Pendiente';
          const icono = estadoIconos[estado] || estadoIconos.default;
          const colorColumna = row.querySelector('.color-columna');
          row.querySelector('.estado-icono').innerHTML = `<i class="fa ${icono}" title="${estado}"></i>`;
          colorColumna.className = `color-columna ${estadoColores[estado] || 'bg-secondary'}`;
        });
      } else {
        $('#contenedorPedidos').html('<p class="text-center text-muted">No hay pedidos para esta fecha.</p>');
      }
    },
    error: function() {
      $('#contenedorPedidos').html('<p class="text-center text-danger">Error al cargar los pedidos.</p>');
    }
  });
}

function mostrarInfo(btn) {
  const contenido = JSON.parse(btn.closest('tr').dataset.contenido);
  const cliente = contenido.cliente || {};
  const productos = contenido.productos || [];
  const entrega = contenido.tipo_entrega || '-';
  const observaciones = contenido.observaciones || '';
  let totalGeneral = 0;

  const filas = productos.map(p => {
    const total = p.precio * p.cantidad;
    totalGeneral += total;
    return `<tr><td>${p.nombre}</td><td>${p.descripcion}</td><td>${p.cantidad}</td><td>$${p.precio}</td><td>$${total}</td></tr>`;
  }).join('');

  const html = `
    <h5><i class="fa fa-user"></i> Cliente</h5>
    <p><strong>${cliente.nombre}</strong><br>Tel: ${cliente.telefono || '-'}<br>Dirección: ${cliente.direccion || '-'}</p>
    <h5><i class="fa fa-box"></i> Productos</h5>
    <table class="table table-sm table-bordered"><thead><tr><th>Producto</th><th>Descripción</th><th>Cant.</th><th>Precio</th><th>Total</th></tr></thead><tbody>${filas}</tbody><tfoot><tr><td colspan="4" class="text-end">Total:</td><td>$${totalGeneral.toFixed(2)}</td></tr></tfoot></table>
    <p><strong>Entrega:</strong> ${entrega}</p>
    ${observaciones ? `<p><strong>Obs.:</strong> ${observaciones}</p>` : ''}`;

  document.getElementById('infoContenido').innerHTML = html;
  new bootstrap.Modal(document.getElementById('infoModal')).show();
}

function marcarPago(btn, tipo) {
  const row = btn.closest('tr');
  const id = row.dataset.id;
  row.dataset.estado = tipo;
  const icono = estadoIconos[tipo] || estadoIconos.default;
  const claseColor = estadoColores[tipo] || 'bg-secondary';
  row.querySelector('.estado-icono').innerHTML = `<i class="fa ${icono}" title="${tipo}"></i>`;
  row.querySelector('.color-columna').className = `color-columna ${claseColor}`;

  $.post('../librerias/ajaxAPP/ajaxSimple.php', {
    id: id,
    value: tipo,
    column: 'Estado',
    funcion: 'update'
  }).done(response => console.log('Actualizado:', response));
}
</script>
