
<div class="container mt-5">

  <div class="d-flex justify-content-end mb-3">
    <input type="text" id="searchInput" class="form-control" placeholder="Buscar por descripción o categoría..." style="width: 33.33%;">
  </div>

    <table class="table" id="productosTable">
        <thead>
            <tr>
                <th>ID</th>
                <th>Descripción</th>
                <th>Categoría</th>
                <th>Estado</th>
                <th>Disponible</th>
                <th>Visible</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($productos as $producto): ?>
                <?php
                    $estado = $producto['Estado'];
                    $disponibleChecked = false;
                    $visibleChecked = false;

                    switch ($estado) {
                        case 'Disponible':
                            $disponibleChecked = true;
                            $visibleChecked = true;
                            break;
                        case 'NoDisponible':
                            $disponibleChecked = false;
                            $visibleChecked = true;
                            break;
                        case 'NoVisible':
                            $disponibleChecked = true;
                            $visibleChecked = false;
                            break;
                        default:
                            $disponibleChecked = false;
                            $visibleChecked = false;
                            break;
                    }
                ?>
                <tr>
                    <td><?= $producto['IDCa'] ?></td>
                    <td><?= $producto['Descripcion_Corta'] ?></td>
                    <td><?= $producto['Categoria'] ?></td>
                    <td class="estado-text"><?= $estado ?></td>

                    <!-- Disponible -->
                    <td>
                        <label class="switch">
                            <input type="checkbox" class="switch-input disponible" data-id="<?= $producto['IDCa'] ?>" <?= $disponibleChecked ? 'checked' : '' ?>>
                            <span class="slider"></span>
                        </label>
                    </td>

                    <!-- Visible -->
                    <td>
                        <label class="switch">
                            <input type="checkbox" class="switch-input visible" data-id="<?= $producto['IDCa'] ?>" <?= $visibleChecked ? 'checked' : '' ?>>
                            <span class="slider"></span>
                        </label>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<style>
/* Estilos switches (igual que antes) */
.switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}
.switch-input {
    opacity: 0;
    width: 0;
    height: 0;
}
.slider {
    position: absolute;
    cursor: pointer;
    top: 0; left: 0; right: 0; bottom: 0;
    background-color: #ccc;
    transition: 0.4s;
    border-radius: 34px;
}
.slider:before {
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    border-radius: 50%;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: 0.4s;
}
.switch-input:checked + .slider {
    background-color: #4CAF50;
}
.switch-input:checked + .slider:before {
    transform: translateX(26px);
}
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    $('.switch-input').on('change', function () {
        const $input = $(this);
        const id = $input.data('id');
        const $row = $input.closest('tr');

        const disponibleChecked = $row.find('.disponible').prop('checked');
        const visibleChecked = $row.find('.visible').prop('checked');

        let nuevoEstado = '';

        if (disponibleChecked && visibleChecked) {
            nuevoEstado = 'Disponible';
        } else if (!disponibleChecked && visibleChecked) {
            nuevoEstado = 'NoDisponible';
        } else if (disponibleChecked && !visibleChecked) {
            nuevoEstado = 'NoVisible';
        } else {
            nuevoEstado = 'NoDisponibleNoVisible';
        }

        console.log(`ID: ${id}, Nuevo Estado: ${nuevoEstado}`);

        $.ajax({
            type: 'POST',
            url: '../librerias/ajaxAPP/ajaxSimple.php',
            data: {
                id: id,
                value: nuevoEstado,
                column: 'Estado',
                funcion: 'update'
            },
            success: function (response) {
                console.log('Respuesta:', response);
                $row.find('.estado-text').text(nuevoEstado);
            },
            error: function (xhr, status, error) {
                console.error('Error AJAX:', error);
            }
        });
    });

    $('#searchInput').on('input', function () {
        const searchTerm = $(this).val().toLowerCase();
        $('#productosTable tbody tr').each(function () {
            const descripcion = $(this).find('td:nth-child(2)').text().toLowerCase();
            const categoria = $(this).find('td:nth-child(3)').text().toLowerCase();

            if (descripcion.indexOf(searchTerm) > -1 || categoria.indexOf(searchTerm) > -1) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });
});
</script>
