
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
<style>
  .color-columna {
    width: 2px;
  }
  .btn-circle {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    padding: 0;
    font-size: 1.2rem;
    display: flex;
    align-items: center;
    justify-content: center;
  }
</style>

<div class="container py-4">
  <table class="table table-bordered table-hover bg-white shadow-sm align-middle">
    <thead class="table-light">
      <tr>
        <th class="color-columna"></th>
        <th>ID Pedido</th>
        <th>Cliente</th>
        <th>Total</th>
        <th>Estado</th>
        <th>Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($pedidos as $pedido): ?>
        <?php
          $contenido = json_decode($pedido['contenido'], true);
          $nombre = $contenido['cliente']['nombre'] ?? '';
          $total = 0;
          foreach ($contenido['productos'] as $prod) {
            $total += $prod['cantidad'] * $prod['precio'];
          }
          $estado = $pedido['Estado'] ?? 'Pendiente';
        ?>
        <tr   data-id="<?= $pedido['id'] ?>"   data-idc="<?= $contenido['cliente']['idc'] ?? 0 ?>"   data-contenido='<?= htmlspecialchars($pedido['contenido'], ENT_QUOTES) ?>'   data-estado="<?= htmlspecialchars($estado) ?>">
          <td class="color-columna"></td>
          <td><?= $pedido['id'] ?></td>
          <td><?= htmlspecialchars($nombre) ?></td>
          <td>$<?= number_format($total, 2) ?></td>
          <td class="estado-icono text-center"><i class="fa"></i></td>
          <td>
            <div class="d-flex flex-wrap gap-2">
              <button class="btn btn-primary btn-circle" onclick="marcarPago(this, 'Banco')" title="Banco">
                <i class="fa fa-university"></i>
              </button>
              <button class="btn btn-success btn-circle" onclick="marcarPago(this, 'Efectivo')" title="Efectivo">
                <i class="fa fa-money-bill-wave"></i>
              </button>
              <button class="btn btn-warning btn-circle" onclick="marcarPago(this, 'Pendiente')" title="Pendiente">
                <i class="fa fa-clock"></i>
              </button>
              <button class="btn btn-danger btn-circle" onclick="marcarPago(this, 'Cancelado')" title="Cancelar">
                <i class="fa fa-times"></i>
              </button>
              <button class="btn btn-dark btn-circle" onclick="mostrarInfo(this)" title="Información">
                <i class="fa fa-info-circle"></i>
              </button>
            </div>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<!-- Modal -->
<div class="modal fade" id="infoModal" tabindex="-1" aria-labelledby="infoModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title" id="infoModalLabel">Reporte del Pedido</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body" id="infoContenido"></div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  const estadoColores = {
    Banco: 'bg-primary',
    Efectivo: 'bg-success',
    Pendiente: 'bg-warning',
    Cancelado: 'bg-danger',
    Entregado: 'bg-success',
    Abierta: 'bg-warning',
    Cerrar: 'bg-dark',
    'En Proceso': 'bg-info',
    Rechazado: 'bg-danger',
    'Pendiente Pago': 'bg-secondary'
  };

  const estadoIconos = {
    Banco: 'fa-university',
    Efectivo: 'fa-money-bill-wave',
    Pendiente: 'fa-clock',
    Cancelado: 'fa-times',
    Entregado: 'fa-box',
    Abierta: 'fa-folder-open',
    Cerrar: 'fa-lock',
    'En Proceso': 'fa-cogs',
    Rechazado: 'fa-ban',
    'Pendiente Pago': 'fa-hourglass-half',
    default: 'fa-question-circle'
  };

  window.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('tbody tr').forEach(row => {
      const estado = row.dataset.estado || 'Pendiente';
      const icono = estadoIconos[estado] || estadoIconos.default;
      const celdaIcono = row.querySelector('.estado-icono');
      const colorColumna = row.querySelector('.color-columna');
      const claseColor = estadoColores[estado] || 'bg-secondary';

      celdaIcono.innerHTML = `<i class="fa ${icono}" title="${estado}"></i>`;
      colorColumna.className = `color-columna ${claseColor}`;
    });
  });

function marcarPago(btn, tipo) {
  const row = btn.closest('tr');
  const estadoActual = row.dataset.estado || '';

  // Solo permitir cambio si el estado actual está en la lista permitida
  const estadosPermitidos = ["Abierta", "Preparando", "Listo", "Entregado"];

  if (!estadosPermitidos.includes(estadoActual)) {
    alert(`Este pedido ya está marcado como "${estadoActual}". No se puede modificar.`);
    return;
  }

  if (!confirm(`¿Estás seguro de marcar este pedido como "${tipo}"?`)) {
    return;
  }

  const id = row.dataset.id;
  const contenido = JSON.parse(row.dataset.contenido || '{}');
  const idCliente = contenido?.cliente?.idc || 0;
  const monto = contenido?.productos?.reduce((suma, p) => suma + (p.precio * p.cantidad), 0) || 0;

  const celdaIcono = row.querySelector('.estado-icono');
  const colorColumna = row.querySelector('.color-columna');
  const icono = estadoIconos[tipo] || estadoIconos.default;
  const claseColor = estadoColores[tipo] || 'bg-secondary';

  celdaIcono.innerHTML = `<i class="fa ${icono}" title="${tipo}"></i>`;
  colorColumna.className = `color-columna ${claseColor}`;
  row.dataset.estado = tipo;

  // Desactivar todos los botones excepto el de información
  const botones = row.querySelectorAll('.btn-circle');
  botones.forEach(b => {
    if (!b.classList.contains('btn-dark')) {
      b.disabled = true;
    }
  });

  // Guardar el nuevo estado
  $.ajax({
    type: 'POST',
    url: '../librerias/ajaxAPP/ajaxSimple.php',
    data: {
      id: id,
      value: tipo,
      column: 'Estado',
      funcion: 'update'
    },
    success: function (response) {
      console.log('Estado actualizado:', response);
    },
    error: function (xhr, status, error) {
      console.error('Error AJAX:', error);
    }
  });

  // Solo si es crédito
  if (tipo === "Pendiente") {
    Credito(idCliente, id, monto);
  }
}


  function mostrarInfo(btn) {
    const row = btn.closest('tr');
    const contenido = JSON.parse(row.dataset.contenido);

    const cliente = contenido.cliente;
    const productos = contenido.productos;
    const entrega = contenido.tipo_entrega;
    const observaciones = contenido.observaciones;

    let totalGeneral = 0;
    const productosRows = productos.map(p => {
      const total = p.precio * p.cantidad;
      totalGeneral += total;
      return `
        <tr>
          <td>${p.nombre}</td>
          <td>${p.descripcion}</td>
          <td>${p.cantidad}</td>
          <td>$${p.precio.toFixed(2)}</td>
          <td>$${total.toFixed(2)}</td>
        </tr>
      `;
    }).join('');

    const html = `
      <div class="mb-3">
        <h5><i class="fa fa-user"></i> Cliente</h5>
        <p><strong>${cliente.nombre || 'Sin nombre'}</strong><br>
           Teléfono: ${cliente.telefono || '-'}<br>
           Dirección: ${cliente.direccion || '-'}</p>
      </div>

      <div class="mb-3">
        <h5><i class="fa fa-box-open"></i> Productos</h5>
        <div class="table-responsive">
          <table class="table table-sm table-bordered">
            <thead class="table-light">
              <tr>
                <th>Producto</th>
                <th>Descripción</th>
                <th>Cant.</th>
                <th>Precio</th>
                <th>Total</th>
              </tr>
            </thead>
            <tbody>${productosRows}</tbody>
            <tfoot>
              <tr>
                <td colspan="4" class="text-end"><strong>Total vendido:</strong></td>
                <td><strong>$${totalGeneral.toFixed(2)}</strong></td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>

      <div class="mb-3">
        <h5><i class="fa fa-truck"></i> Tipo de entrega</h5>
        <p>${entrega}</p>
      </div>

      ${observaciones ? `
      <div class="mb-3">
        <h5><i class="fa fa-sticky-note"></i> Observaciones</h5>
        <p>${observaciones}</p>
      </div>` : ''}
    `;

    document.getElementById('infoContenido').innerHTML = html;
    new bootstrap.Modal(document.getElementById('infoModal')).show();
  }
	
	
		
function Credito(idCliente, idPedido, monto) {
  const formData = {
    id: 0,
    IDL: "<?php echo $IDLs; ?>",
    IDC: idCliente,
    IDN: idPedido,
    Tipo: "Credito",
    Monto: monto,
    Token: "<?php echo bin2hex(openssl_random_pseudo_bytes(4)); ?>",
    Vector: "0", // según la configuración que uses
    funcion: "insertS"
  };

  const urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

  $.ajax({
    url: urlajaxUpdate,
    type: 'POST',
    data: formData,
    success: function (response) {
      console.log("Respuesta del crédito:", response);
    },
    error: function (error) {
      console.error('Error al registrar crédito:', error);
    }
  });
}
	
	
	
function LibroDiario(Descripcion, Monto, TipoM){
	//alert(Descripcion+Monto+TipoM);
	
	var formData = {
        id: 0,
		IDL:"<?php echo $IDLs;?>" ,
		Descripcion:Descripcion,
		Estado:"ok",
		TipoMovimiento: TipoM,
		Monto: Monto,
		Token: "<?php echo bin2hex( openssl_random_pseudo_bytes( 4 ) );?>",
		
		Vector: "1",//aqui decides que columnas y consulta usar
        funcion: "insertS"
		
    };	
	 var urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
	 $.ajax({
        url: urlajaxUpdate,
        type: 'POST',
        data: formData,
        success: function(response) {
      
            console.log(response);

        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
	
}		
	
</script>
