<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<style>
    body {
        background-color: #f8f9fa;
    }
    .form-container {
        background-color: #ffffff;
        border-radius: 8px;
        padding: 15px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    .input-group {
        margin-bottom: 0.5rem;
    }
    .inner-addon {
        position: relative;
    }
    .inner-addon .fa {
        position: absolute;
        padding: 10px;
        pointer-events: none;
    }
    .right-addon .fa {
        right: 10px;
    }
    .left-addon .fa {
        left: 10px;
    }
    .left-addon input, .left-addon textarea {
        padding-left: 30px;
    }
    .right-addon input {
        padding-right: 30px;
    }
</style>

<div class="container mt-5">
    <div class="form-container mb-4">
        <h4>Agregar Pago</h4>
        <form id="payment-form" class="form-inline">
            <div class="input-group mr-2 inner-addon right-addon">
                <i class="fa fa-dollar"></i>
                <input type="number" class="form-control" id="amount" placeholder="Monto" required min="0.01" step="0.01">
            </div>
            <div class="input-group mr-2 inner-addon left-addon">
                <i class="fa fa-list-alt"></i>
                <select class="form-control" id="status" required>
                    <option value="" disabled selected>Estado</option>
                    <option value="Completado">Completado</option> 
                    <option value="Pendiente">Pendiente</option>
                    <option value="Fallido">Fallido</option>
                </select>
            </div>
            <div class="input-group mr-2 inner-addon left-addon">
                <i class="fa fa-credit-card"></i>
                <select class="form-control" id="method" required>
                    <option value="" disabled selected>Método de Pago</option>
                    <option value="Transferencia">Transferencia</option>
                    <option value="Tarjeta de Crédito">Tarjeta de Crédito</option>
                    <option value="Efectivo">Efectivo</option>
                    <option value="PayPal">PayPal</option>
                </select>
            </div>
            <div class="input-group mr-3 inner-addon left-addon">
                <i class="fa fa-comments"></i>
                <textarea class="form-control" id="observations" placeholder="Observaciones" rows="1"></textarea>
            </div>
            <div class="input-group">
                <button type="submit" class="btn btn-primary" id="submit-button">Agregar</button>
            </div>
        </form>
    </div>
    <div class="row page-titles mx-0 align-items-center">
        <h2>Reporte de Pagos</h2>
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Monto</th>
                    <th>Estado</th>
                    <th>Método de Pago</th>
                    <th>Token</th>
                    <th>Fecha</th>
                    <th>Observaciones</th>
                </tr>
            </thead>
            <tbody id="payment-report">
                <!-- Los datos se llenarán con JavaScript -->
            </tbody>
        </table>
    </div>
</div>

<script>
function construirPayments(arr) {
    return arr.map(item => {
        let datos = {};
        try {
            datos = JSON.parse(item.Datos);
        } catch (error) {
            console.warn("Error al parsear Datos:", error);
        }

        return {
            id: item.id,
            amount: datos.amount || 0,
            status: datos.status || "Desconocido",
            method: datos.method || "No especificado",
            token: datos.token || Math.random().toString(36).substr(2, 6),
            date: item.Fecha || "Sin fecha",
            observations: datos.observations || "Sin observaciones"
        };
    });
}

// Ejemplo de uso con el arreglo proporcionado
const datosArray = <?php echo json_encode($datosPagos);?>;
const payments = construirPayments(datosArray);
console.log(payments);

// Función para generar el reporte
function generateReport() {
    const reportBody = document.getElementById('payment-report');
    reportBody.innerHTML = ""; // Limpiar el contenido antes de regenerar
    payments.forEach(payment => {
        const row = document.createElement('tr');
        row.innerHTML = `
            <td>${payment.id}</td>
            <td>$${payment.amount.toFixed(2)}</td>
            <td>${payment.status}</td>
            <td>${payment.method}</td>
            <td>${payment.token}</td>
            <td>${payment.date}</td>
            <td>${payment.observations}</td>
        `;
        reportBody.appendChild(row);
    });
}

// Función para agregar un nuevo pago
document.getElementById('payment-form').addEventListener('submit', function(event) {
    event.preventDefault();
    
    const submitButton = document.getElementById('submit-button');
    submitButton.disabled = true;

    const newPayment = {
        id: payments.length + 1,
        amount: parseFloat(document.getElementById('amount').value),
        status: document.getElementById('status').value,
        method: document.getElementById('method').value,
        token: Math.random().toString(36).substr(2, 8),
        observations: document.getElementById('observations').value || "Sin observaciones"
    };

    if (newPayment.amount && newPayment.status && newPayment.method) {
        payments.push(newPayment);
        guardar(JSON.stringify(newPayment));
        generateReport();
        this.reset();
    }

    setTimeout(() => {
        submitButton.disabled = false;
    }, 10000);
});

<?php 
    $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
?>

function guardar(json) {
    var datos = {
        IDU: <?php echo $iduul;?>+"",
        IDC: <?php echo $idPaciente;?>+"",
        Tipo: "Pago",
        Observaciones: document.getElementById('observations').value || "Sin observaciones",
        Datos: json,
        Token: "<?php echo bin2hex( openssl_random_pseudo_bytes( 4 ) );?>",
        Conjunto_A: "1",
        Conjunto_B: "2"
    };
    
    var valores= JSON.stringify(datos);
    
    var formData = {
        id: 0,
        valores: valores, 
        funcion: "insert"
    };
    
    $.ajax({
        url: '<?php echo $urlajaxUpdate; ?>',
        type: 'POST',
        data: formData,
        success: function(response) {
            $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
            setTimeout(function() {$('#Mensaje').empty();}, 2000);
            console.log(response);
            setTimeout(function() {location.reload();}, 3000);
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}

// Llamar a la función para generar el reporte al cargar la página
document.addEventListener('DOMContentLoaded', generateReport);
</script>
