<style>
.membership-card {
    border: 1px solid #ddd;
    border-radius: 8px;
    box-shadow: 0px 2px 6px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    padding: 20px;
}
.treatment-card {
    border: 1px solid #eee;
    border-radius: 5px;
    margin-bottom: 10px;
    padding: 10px;
    background-color: #f9f9f9;
}
.treatment-card.available {
    background-color: #e6f7e6;
}
.treatment-card.unavailable {
    background-color: #f8d7da;
    border-color: #f5c2c7;
}
.user-list {
    list-style-type: none;
    padding-left: 0;
}
.user-list li {
    padding: 5px 0;
}
</style>

<div class="container mt-4">
  <h1 class="text-center mb-4">Gestión de Membresías</h1>
  <div class="text-end mb-4">
    <button class="btn btn-primary" onclick="openForm()">Agregar Membresía</button>
  </div>
  <div id="membershipCards" class="row"></div>
  <pre id="jsonOutput" style="white-space: pre-wrap; background-color: #f8f9fa; padding: 20px; border-radius: 5px;"></pre>
  <!-- Mostrar el JSON --> 
</div>

<!-- Modal para agregar o editar membresías -->
<div class="modal fade" id="membershipModal" tabindex="-1" aria-labelledby="membershipModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="membershipForm" onsubmit="saveMembership(); return false;">
        <div class="modal-header">
          <h5 class="modal-title" id="membershipModalLabel">Agregar Membresía</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" id="membershipId">
          <div class="form-group mb-3">
            <label>Nombre</label>
            <input type="text" class="form-control" id="membershipName" required>
          </div>
          <div class="form-group mb-3">
            <label>Tipo</label>
            <select class="form-control" id="membershipType" onchange="generateNameInputs()" required>
              <option value="" disabled selected>Selecciona una membresía</option>
              <option value="Individual">Individual</option>
              <option value="Pareja">Pareja</option>
              <option value="3 Personas">3 Personas</option>
              <option value="4 Personas">4 Personas</option>
            </select>
            <div class="invalid-feedback">Por favor selecciona un tipo de membresía.</div>
          </div>
          <div class="form-group mb-3">
            <label>Vigencia de la Membresía</label>
            <input type="date" class="form-control" id="membershipExpiration" required>
            <div class="invalid-feedback">Por favor selecciona una fecha válida.</div>
          </div>
          <div id="nameInputsContainer" class="mb-3"></div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary">Guardar</button>
        </div>
      </form>
    </div>
  </div>
</div>
<script>
    const membershipTypes = {
        "Individual": 1,
        "Pareja": 2,
        "3 Personas": 3,
        "4 Personas": 4
    };

let originalArray = <?php echo $_SESSION[ "IDU-ConfiguracionxNombre" ][0]["DatosMembresia"];?>

	
	
	
	
	
// Convertir el array original
let services = originalArray.map(item => ({
    id: parseInt(item.id), // Convertir el id a número entero
    descripcion: item.descripcion,
    cantidad: parseInt(item.cantidad)
}));
	
	console.log(services);
	
    let memberships = [];

    function generateNameInputs() {
        const type = $('#membershipType').val();
        const count = membershipTypes[type];
        const container = $('#nameInputsContainer');
        container.empty();
        for (let i = 0; i < count; i++) {
            container.append(`
                <div class="form-group mb-2">
                    <label>Nombre del Usuario ${i + 1}</label>
                    <input type="text" class="form-control" id="user${i}" required>
                </div>
            `);
        }
    }

function openForm(id = null) {
    $('#membershipForm')[0].reset(); // Limpiar el formulario
    $('#nameInputsContainer').empty();
    $('#membershipId').val(id);

    // Configurar valores por defecto
    $('#membershipType').val('');
    const oneYearFromNow = new Date();
    oneYearFromNow.setFullYear(oneYearFromNow.getFullYear() + 1);
    $('#membershipExpiration').val(oneYearFromNow.toISOString().split('T')[0]);

    $('#membershipModal').modal('show');
}
    function saveMembership() {
        const id = $('#membershipId').val();
        const name = $('#membershipName').val();
        const type = $('#membershipType').val();
        const expiration = $('#membershipExpiration').val() || new Date().toISOString().split('T')[0]; // Default to current date if not selected
        const users = [];
        const userCount = membershipTypes[type];
        for (let i = 0; i < userCount; i++) {
            users.push($(`#user${i}`).val());
        }

        if (id) {
            const membership = memberships.find(m => m.id == id);
            membership.name = name;
            membership.type = type;
            membership.users = users;
            membership.expiration = expiration;
        } else {
            memberships.push({
                id: Date.now(),
                name,
                type,
                users,
                expiration,
                services: JSON.parse(JSON.stringify(services))
            });
        }
        $('#membershipModal').modal('hide');
        renderCards();
        generateJSON();
		guardar();
    }

    function renderCards() {
        const container = $('#membershipCards');
        container.empty();
        memberships.forEach(m => {
            const treatmentCards = m.services.map(service => `
                <div class="treatment-card ${service.cantidad > 0 ? 'available' : 'unavailable'}">
                    <strong>${service.descripcion}</strong>
                    <p>Cantidad disponible: ${service.cantidad}</p>
                    <button class="btn btn-success btn-sm" ${service.cantidad > 0 ? '' : 'disabled'} onclick="useService(${m.id}, ${service.id})">Usar Servicio</button>
                </div>
            `).join("");

            const userList = m.users.map(user => `<li>${user}</li>`).join(""); // Formato bonito para los usuarios

            container.append(`
                <div class="membership-card p-3 col-md-6">
                    <h4 class="card-title">${m.name}</h4>
                    <h6 class="card-subtitle mb-2 text-muted">${m.type}</h6>
                    <p>Vigencia: ${m.expiration}</p>
					
                    <button class="btn btn-info btn-sm" onclick="printMembership(${m.id})">Imprimir</button>
                    <ul class="user-list">${userList}</ul>
                    <div class="treatments-container">${treatmentCards}</div>
                    <button class="btn btn-info btn-sm" onclick="printMembership(${m.id})">Imprimir</button>
                </div>
            `);
        });
    }


	function useService(membershipId, serviceId) {
    // Convert membershipId to number if it's a string
    const id = typeof membershipId === 'string' ? parseInt(membershipId, 10) : membershipId;

    // Buscar la membresía en el array de membresías
    const membership = memberships.find(m => m.id === id);
    
    // Verificar si la membresía fue encontrada
    if (!membership) {
        console.error("Membresía no encontrada:", membershipId);
        return;
    }

    // Verificar si la membresía tiene servicios asignados
    if (membership && Array.isArray(membership.services)) {
        // Buscar el servicio en los servicios de la membresía
        const service = membership.services.find(s => s.id === serviceId);
        
        // Validar si el servicio existe y tiene cantidad disponible
        if (service && service.cantidad > 0) {
            service.cantidad--;
            renderCards();
            generateJSON();
			const jsonOutput = JSON.stringify(memberships, null, 2);
			editarTabla(membershipId, "Datos", jsonOutput );
        } else {
            console.error("Cantidad de servicio no válida o servicio agotado");
        }
    } else {
        console.error("Membresía no tiene servicios asignados");
    }
}

	
	


function printMembership(membershipId) {
    const membership = memberships.find(m => m.id === membershipId);

    // Convertir el objeto de la membresía en formato JSON
    const jsonData = JSON.stringify(membership, null, 2);

    // Crear un formulario dinámico para enviar el JSON via POST
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = 'http://167.172.224.160/MiSi/librerias/Impresora/ImprimirMemebresiaM.php';
    
    // Crear un campo oculto para enviar el JSON
    const hiddenField = document.createElement('input');
    hiddenField.type = 'hidden';
    hiddenField.name = 'membershipData'; // Nombre de la variable POST
    hiddenField.value = jsonData; // El valor es el JSON
    alert(jsonData);
    form.appendChild(hiddenField);

    // Abrir una ventana hija y enviar el formulario
    const printWindow = window.open('', '_blank', 'width=800,height=600'); // Tamaño de la ventana

    // Asegúrate de que la ventana hija se haya abierto correctamente antes de enviar el formulario
    printWindow.document.body.appendChild(form); // Agregar el formulario al body de la ventana hija
    form.submit(); // Enviar el formulario via POST
}

<?php 
    $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

?>
    function generateJSON() {
        const jsonOutput = JSON.stringify(memberships, null, 2);
       //$('#jsonOutput').text(jsonOutput);
		//guardar(jsonOutput);
    }
	
	 function guardar() {
		 const json = JSON.stringify(memberships, null, 2);
		     // Obtener el timestamp actual para TimeStampInicio
    const currentTimestamp = new Date().toISOString().slice(0, 19).replace('T', ' ');

    // Obtener TimeStampFin desde la vigencia de la membresía
    const expirationDate = $('#membershipExpiration').val();
    const expirationTimestamp = new Date(expirationDate).toISOString().slice(0, 19).replace('T', ' ');

    // Crear el objeto de datos para enviar
    var datos = {
        IDL: <?php echo $iduul; ?> + "",
        IDC: <?php echo $idPaciente; ?> + "",
        IDCat: 0,
        TimeStampInicio: currentTimestamp, // Asignar el timestamp actual
        TimeStampFin: expirationTimestamp, // Asignar la fecha de vigencia como timestamp
        Estado: "Vigente",
        Datos: json,
        Token: "<?php echo bin2hex(openssl_random_pseudo_bytes(4)); ?>",
        Conjunto_A: "1",
        Conjunto_B: "2"
    };
		 
        var valores = JSON.stringify(datos);
		//console.log(valores); 
        var formData = {
            id: 0,
            valores: valores, 
            funcion: "insert"
        };

        $.ajax({
            url: '<?php echo $urlajaxUpdate; ?>',
            type: 'POST',
            data: formData,
            success: function(response) {
                $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
                setTimeout(function() { $('#Mensaje').empty(); }, 2000);
                console.log(response);
               // setTimeout(function() { location.reload(); }, 3000);
            },
            error: function(error) {
                console.error('Error al enviar datos al servidor:', error);
            }
        });
    }



	$(document).ready(function () {
    const originalArray = <?php echo json_encode($Membresias, JSON_PRETTY_PRINT); ?>;

    if (originalArray && Array.isArray(originalArray)) {
        memberships = originalArray.map(item => {
            let datos = [];
            try {
                datos = JSON.parse(item.Datos); // Intentar parsear los datos como JSON
            } catch (error) {
                console.error("Error al parsear 'Datos':", error, item.Datos);
            }

            const datosObj = datos[0] || {}; // Obtener el primer elemento o un objeto vacío
            return {
                id: Number(item.ID_Membresia) || Date.now(), // Utilizar un ID por defecto si no está presente
                name: datosObj.name || "Sin nombre",
                type: datosObj.type || "Desconocido",
                users: datosObj.users || [],
                expiration: datosObj.expiration || item.TimeStampFin || new Date().toISOString().split('T')[0],
                services: Array.isArray(datosObj.services) ? datosObj.services : [], // Asegurar que services sea un arreglo
                estado: item.Estado || "Desconocido"
            };
        });
    } else {
        console.error("El arreglo original no es válido:", originalArray);
    }

    // Verificar que memberships no esté vacío antes de llamar a renderCards
    if (memberships.length > 0) {
        renderCards();
		console.log(memberships);
    } else {
        console.warn("No se encontraron membresías para renderizar.");
    }
});

function editarTabla(id, columna, valor) {
  // alert("Función editar tabla: " + id + ", " + columna + ", " + valor);

    // Datos a enviar al servidor
    var formData = {
        id: id, 
        column: columna,
        value: valor, 
		funcion: "update"
    };

    // AJAX para enviar los datos al servidor 
    $.ajax({
        url: '<?php echo $urlajaxUpdate; ?>', // Reemplaza con la ruta correcta a tu script del servidor
        type: 'POST',
        data: formData,
        success: function(response) {
            // Maneja la respuesta del servidor
			$("#Mensaje").html(' <div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
			setTimeout(function() {$('#Mensaje').empty();}, 2000);
			
            console.log(response);
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}

    
	
</script> 
