<?php
// Datos del paciente
$paciente = [
    "nombre" => $originalArray[0]['Nombre'],
    "telefono" => $originalArray[0]['Telefono'] ?: "Sin teléfono", // Valor por defecto si está vacío
    "fecha" => $originalArray[0]['Desde'],
    "peso" => 70, // Valor fijo o generado
    "edad" => 30  // Valor fijo o calculado
];

// Datos del doctor
$doctor = $DoctorDatos;
?>

<style>
    .justificante-container {
        max-width: 800px;
        margin: 20px auto;
        padding: 20px;
        border: 1px solid #000;
        border-radius: 10px;
        box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
    }
    .justificante-header, .justificante-footer {
        text-align: center;
        margin-bottom: 20px;
    }
    .justificante-section {
        margin-bottom: 15px;
    }
    .label {
        font-weight: bold;
        color: #555;
    }
    .doctor-info {
        color: #333;
        font-size: 0.9em;
        margin-bottom: 10px;
    }
    .footer-divider {
        margin: 20px 0;
        border-top: 1px solid #ccc;
    }
    .instructions-section {
        margin-top: 20px;
        padding: 10px;
        border: 1px solid #ccc;
        background-color: #f9f9f9;
        border-radius: 8px;
    }
</style>

<div class="container justificante-container">

    <div class="justificante-header">
        <p>
            <?php
            echo htmlspecialchars($doctor['nombre']) . " | " .
                 htmlspecialchars($doctor['especialidad']) . " | " .
                 "Tel: " . htmlspecialchars($doctor['telefono']) . " | " .
                 "Cédula: " . htmlspecialchars($doctor['cedula']);
            ?>
        </p>
    </div>

    <div class="doctor-info">
        <p><i class="fa fa-user"></i> <span class="label">Nombre del Paciente:</span> <span id="infoNombre"></span></p>
        <p><i class="fa fa-phone"></i> <span class="label">Teléfono:</span> <span id="infoTelefono"></span></p>
        <p><i class="fa fa-calendar"></i> <span class="label">Fecha de Justificante:</span> <span id="infoFecha"></span></p>
    </div>

    <form id="justificanteForm">
        <div class="form-group row">
            <div class="col-md-6">
                <label class="label"><i class="fa fa-balance-scale"></i> Peso del Paciente (kg):</label>
                <input type="number" class="form-control" id="pesoPacienteInput" placeholder="Peso en kg" required>
            </div>
            <div class="col-md-6">
                <label class="label"><i class="fa fa-birthday-cake"></i> Edad del Paciente (años):</label>
                <input type="number" class="form-control" id="edadPacienteInput" placeholder="Edad en años" required>
            </div>
        </div>

        <div class="justificante-section">
            <label class="label"><i class="fa fa-heartbeat"></i> Diagnóstico:</label>
            <input type="text" class="form-control" id="diagnostico" placeholder="Diagnóstico" required>
        </div>

        <div class="justificante-section">
            <label class="label"><i class="fa fa-comments"></i> Justificación:</label>
            <textarea class="form-control" id="justificacion" rows="3" placeholder="Justificación para el paciente" required></textarea>
        </div>

        <!-- Nueva sección de Instrucciones -->
        <div class="instructions-section">
            <label class="label"><i class="fa fa-pencil-square"></i> Instrucciones:</label>
            <textarea class="form-control" id="instrucciones" rows="4" placeholder="Instrucciones para el paciente" required></textarea>
        </div>

        <button type="button" class="btn btn-primary btn-block mt-3" id="verImprimir" onclick="verImprimir()">Ver e Imprimir</button>
        <button type="button" class="btn btn-success btn-block mt-3" onclick="generarJSON()"><i class="fa fa-save"></i> Guardar Justificante</button>
    </form>

    <div class="footer-divider"></div>
</div>

<script>
    document.getElementById("verImprimir").addEventListener("click", verImprimir);

    // Datos del paciente
    const pacienteData = <?php echo json_encode($paciente); ?>;
	console.log(pacienteData);
    // Datos del doctor
    const doctorData = <?php echo json_encode($doctor); ?>;

    function verImprimir() {
        const justificanteData = {
            paciente: {
                nombre: document.getElementById("infoNombre").innerText,
                telefono: document.getElementById("infoTelefono").innerText,
                fecha: document.getElementById("infoFecha").innerText,
                peso: document.getElementById("pesoPacienteInput").value,
                edad: document.getElementById("edadPacienteInput").value
            },
            doctor: {
                nombre: doctorData.nombre,
                especialidad: doctorData.especialidad,
                dgP: doctorData.dgP,
                cedula: doctorData.cedula
            },
            diagnostico: document.getElementById("diagnostico").value,
            justificacion: document.getElementById("justificacion").value,
            instrucciones: document.getElementById("instrucciones").value // Agregar instrucciones
        };

        fetch('../librerias/Impresora/ImprimirJustificante.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(justificanteData)
        })
        .then(response => {
            if (response.ok) {
                return response.blob();
            }
            throw new Error('Error al generar el PDF');
        })
        .then(blob => {
            const pdfUrl = URL.createObjectURL(blob);
            window.open(pdfUrl, '_blank');
        })
        .catch(error => {
            alert("Error al generar el justificante: " + error);
        });
    }

    function generarJSON() {
        const justificanteData = {
            paciente: {
                nombre: document.getElementById("infoNombre").innerText,
                telefono: document.getElementById("infoTelefono").innerText,
                fecha: document.getElementById("infoFecha").innerText,
                peso: document.getElementById("pesoPacienteInput").value,
                edad: document.getElementById("edadPacienteInput").value
            },
            doctor: {
                nombre: doctorData.nombre,
                especialidad: doctorData.especialidad,
                dgP: doctorData.dgP,
                cedula: doctorData.cedula
            },
            diagnostico: document.getElementById("diagnostico").value,
            justificacion: document.getElementById("justificacion").value,
            instrucciones: document.getElementById("instrucciones").value // Agregar instrucciones
        };

        // Guardar el JSON (puedes hacer un POST o lo que necesites)
        console.log("Datos del justificante:", JSON.stringify(justificanteData));
		  console.log(JSON.stringify(justificanteData)); // Muestra el JSON en la consola
		guardar(JSON.stringify(justificanteData));
    }
	
	      	<?php 
    $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
?>
	
	
function guardar(json) {
    var datos = {
        IDU: <?php echo $iduul;?>+"",
        IDC: <?php echo $idPaciente;?>+"",
        Tipo: "Justificante",
        Observaciones:  "Sin observaciones",
        Datos: json,
        Token: "<?php echo bin2hex( openssl_random_pseudo_bytes( 4 ) );?>",
        Conjunto_A: "1",
        Conjunto_B: "2"
    };
    
    var valores= JSON.stringify(datos);
    
    var formData = {
        id: 0,
        valores: valores, 
        funcion: "insert"
    };
    
    $.ajax({
        url: '<?php echo $urlajaxUpdate; ?>',
        type: 'POST',
        data: formData,
        success: function(response) {
            $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
            setTimeout(function() {$('#Mensaje').empty();}, 2000);
            console.log(response);
            setTimeout(function() {location.reload();}, 3000);
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}	
	
	document.getElementById("infoNombre").innerText = pacienteData.nombre;
document.getElementById("infoTelefono").innerText = pacienteData.telefono;
document.getElementById("infoFecha").innerText = pacienteData.fecha;
</script>
