<style>
  .tree {
    list-style-type: none;
    margin: 0;
    padding: 0;
  }

  .tree li {
    margin: 5px;
    cursor: pointer;
  }

  .tree li::before {
    content: '▸';
    padding-right: 5px;
  }

  .tree .expanded::before {
    content: '▾';
  }

  .modal-content {
    background-color: #fefefe;
    margin: 5% auto;
    padding: 20px;
    border-radius: 8px;
    width: 80%;
    max-width: 500px;
  }
</style>
<div class="container mt-5">
  <ul class="tree" id="arbolContainer"></ul>
  <div class="text-center mt-4">
    <button id="agregarNodoBtn" class="btn btn-primary btn-lg">Agregar Nodo</button>
    <button id="guardarArbolBtn" class="btn btn-success btn-lg">Guardar Árbol</button>
  </div>
</div>

<!-- Modal para agregar un nuevo nodo -->
<div id="modalAgregarNodo" class="modal">
  <div class="modal-content">
    <span class="close" style="font-size: 30px; cursor: pointer;">&times;</span>
    <h3 class="text-center">Agregar Nuevo Nodo</h3>
    <form id="formAgregarNodo">
      <div class="form-group">
        <label for="nodoPadre">Nodo Padre</label>
        <input id="nodoPadre" class="form-control" type="text" readonly>
      </div>
      <div class="form-group">
        <label for="productoSelect">Producto</label>
        <select id="productoSelect" class="form-control" style="width: 100%;" required>
          <option value="">Seleccione un producto</option>
        </select>
      </div>
      <div class="text-center mt-3">
        <button type="button" id="guardarNodoBtn" class="btn btn-success btn-lg">Guardar Nodo</button>
      </div>
    </form>
  </div>
</div>

<?php 
//UPDATE MicroSi_Datos.1-Catalogo SET Codigo = '11' WHERE (IDCa = '1');
 $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

?>


<script>
  // Array PHP convertido a JSON
  const productos = <?php echo json_encode($productos); ?>;
  const arbols = <?php echo json_encode($arbol[0]["DatosInversion"], JSON_PRETTY_PRINT);?>;
  


	let arbol = [];
try {
  arbol = JSON.parse(arbols);
  
  // Verificar si arbol no es un arreglo o está vacío
  if (!Array.isArray(arbol) || arbol.length === 0) {
    arbol = [
      {
        id: "root",
        text: "Nodo Raíz",
        children: []
      }
    ];
  }
} catch (error) {
  console.error("Error al parsear arbols:", error);
  arbol = [
    {
      id: "root",
      text: "Nodo Raíz",
      children: []
    }
  ];
}

console.log(arbol);

  let nodoSeleccionado = "root"; // ID del nodo seleccionado

// Filtrar productos que ya están en el árbol
function obtenerProductosDisponibles() {
  const idsEnArbol = obtenerIdsEnArbol(arbol); // Obtener los ids de los productos ya en el árbol
  return productos.filter(producto => !idsEnArbol.includes(producto.IDCa)); // Filtrar los productos no seleccionados
}

// Obtener los ids de los nodos en el árbol
function obtenerIdsEnArbol(nodos) {
  let ids = [];
  nodos.forEach(nodo => {
    ids.push(nodo.id); // Agregar el id del nodo
    if (nodo.children && nodo.children.length > 0) {
      ids = ids.concat(obtenerIdsEnArbol(nodo.children)); // Recursión para obtener hijos
    }
  });
  return ids;
}

// Inicializar Select2 y cargar datos de los productos disponibles
$(document).ready(() => {
  const productosDisponibles = obtenerProductosDisponibles();
  $('#productoSelect').select2({
    placeholder: "Seleccione un producto",
    data: productosDisponibles.map(p => ({
      id: p.IDCa,
      text: `${p.Descripcion_Corta} - Costo: ${p.Costo}`
    }))
  });
});


  // Modal lógica
  const modal = document.getElementById('modalAgregarNodo');
  const btn = document.getElementById("agregarNodoBtn");
  const span = document.getElementsByClassName("close")[0];

  btn.onclick = () => {
    const nodoPadreTexto = buscarNodoPorId(arbol, nodoSeleccionado)?.text || "Nodo no encontrado";
    document.getElementById("nodoPadre").value = nodoPadreTexto; // Mostrar el nodo padre en el modal
    modal.style.display = "block";
  };
  span.onclick = () => modal.style.display = "none";

  window.onclick = (event) => {
    if (event.target == modal) {
      modal.style.display = "none";
    }
  };

  // Agregar nodo al árbol
  function agregarNodo() {
    const productoId = $('#productoSelect').val();
    const producto = productos.find(p => p.IDCa == productoId);

    if (!producto) {
      alert("Seleccione un producto válido.");
      return;
    }

    const nuevoNodo = {
      id: `${producto.IDCa}`,
      text: `${producto.Descripcion_Corta} - Costo: ${producto.Costo}`,
      children: []
    };

    // Agregar el nodo al árbol
    agregarHijoA(nodoSeleccionado, nuevoNodo);

    // Eliminar el producto del arreglo de productos y del select
    const index = productos.findIndex(p => p.IDCa == productoId);
    if (index !== -1) {
      productos.splice(index, 1); // Eliminar del arreglo original
    }

    $('#productoSelect').find(`option[value="${productoId}"]`).remove(); // Eliminar del select
    $('#productoSelect').val(null).trigger('change'); // Actualizar Select2

    renderizarArbol();
    modal.style.display = "none";
  }

  function agregarHijoA(idPadre, nodoHijo) {
    for (let i = 0; i < arbol.length; i++) {
      if (arbol[i].id === idPadre) {
        arbol[i].children.push(nodoHijo);
        return;
      }
      if (arbol[i].children.length > 0) {
        agregarHijoARecursivo(arbol[i].children, idPadre, nodoHijo);
      }
    }
  }

  function agregarHijoARecursivo(hijos, idPadre, nodoHijo) {
    for (let j = 0; j < hijos.length; j++) {
      if (hijos[j].id === idPadre) {
        hijos[j].children.push(nodoHijo);
        return;
      }
      if (hijos[j].children.length > 0) {
        agregarHijoARecursivo(hijos[j].children, idPadre, nodoHijo);
      }
    }
  }

  // Buscar un nodo por su ID
  function buscarNodoPorId(nodos, id) {
    for (const nodo of nodos) {
      if (nodo.id === id) return nodo;
      if (nodo.children.length > 0) {
        const encontrado = buscarNodoPorId(nodo.children, id);
        if (encontrado) return encontrado;
      }
    }
    return null;
  }

  // Renderizar árbol
// Renderizar árbol
function renderizarArbol() {
  const container = document.getElementById('arbolContainer');
  container.innerHTML = ''; // Limpiar el contenedor antes de renderizar

  function renderNodo(nodo, nivel) {
    const li = document.createElement('li');
    const sangria = '&nbsp;'.repeat(nivel * 12);
    
    // Buscar el producto en el arreglo 'productos' usando el 'id' del nodo
    const producto = productos.find(p => p.IDCa == nodo.id);
    const descripcion = producto ? `${producto.Descripcion_Corta} - Costo: ${producto.Costo}` : nodo.text;
    //console.log(descripcion);
    li.innerHTML = sangria + descripcion;
    li.id = nodo.id;

    li.addEventListener('click', (event) => {
      event.stopPropagation();
      nodoSeleccionado = nodo.id; // Cambiar nodo seleccionado
      renderizarArbol(); // Re-renderizar el árbol para reflejar la selección
    });

    if (nodo.children && nodo.children.length > 0) {
      const ul = document.createElement('ul');
      nodo.children.forEach(hijo => {
        const nodoHijo = renderNodo(hijo, nivel + 1);
        ul.appendChild(nodoHijo);
      });
      li.appendChild(ul);
    }

    if (nodoSeleccionado === nodo.id) {
      li.style.fontWeight = "bold"; // Resaltar el nodo seleccionado
    }

    return li;
  }

  arbol.forEach(nodo => container.appendChild(renderNodo(nodo, 0)));
}
  // Guardar árbol completo
  function guardarArbol() {
    const jsonArbol = JSON.stringify(arbol, null, 2);
    console.log(jsonArbol);
	editarTabla(<?php echo $IDs;?>, "DatosInversion", jsonArbol);
    alert("Árbol guardado en la consola.");
    // Aquí podrías enviarlo por AJAX al servidor si fuera necesario
  }
	
 // Función para editar datos en la tabla
  function editarTabla(id, columna, valor) {
    const formData = {
      id: id,
      column: columna,
      value: valor,
      funcion: "update"
    };

    // AJAX para enviar los datos al servidor
    $.ajax({
      url: '<?php echo $urlajaxUpdate; ?>',
      type: 'POST',
      data: formData,
      success: function(response) {
        $("#Mensaje").html(
          '<div class="alert alert-success alert-dismissible alert-alt fade show">' +
            '<button type="button" class="close h-100" data-dismiss="alert" aria-label="Close">' +
            '<span><i class="mdi mdi-close"></i></span></button>' +
            '<strong>Listo</strong> Se actualizó correctamente.</div>'
        );
        setTimeout(function() {
          $('#Mensaje').empty();
        }, 2000);
        console.log(response);
      },
      error: function(error) {
        console.error("Error al enviar datos al servidor:", error);
      }
    });
  }

  document.getElementById("guardarNodoBtn").addEventListener('click', agregarNodo);
  document.getElementById("guardarArbolBtn").addEventListener('click', guardarArbol);

  renderizarArbol();
</script>
