<div class="container mt-5">
  <div class="card shadow">
    <div class="card-header bg-primary text-white d-flex justify-content-between">
      <h4 class="mb-0">Registrar Entrada</h4>
      <button type="button" class="btn btn-light btn-sm" id="addProductoBtn">+ Agregar Producto</button>
    </div>
    <div class="card-body">
      <form id="entradaForm">
        <div id="productosContainer"></div>
        <button type="submit" class="btn btn-success mt-3">Generar JSON</button>
      </form>
    </div>
  </div>

  <!-- Resultado JSON -->
  <div class="card mt-4 d-none" id="resultadoCard">
    <div class="card-header bg-dark text-white d-flex justify-content-between">
      <span>JSON Generado</span>
      <button id="pdfBtn" class="btn btn-danger btn-sm d-none">📄 Exportar a PDF</button>
    </div>
    <div class="card-body">
      <pre id="jsonOutput" class="bg-light p-3 rounded"></pre>
    </div>
  </div>
</div>

<!-- jsPDF -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>

<script>
document.addEventListener("DOMContentLoaded", () => {
  const productosData = <?php echo json_encode($productos); ?>; // Arreglo desde PHP
  const productosContainer = document.getElementById("productosContainer");
  const addProductoBtn = document.getElementById("addProductoBtn");
  const form = document.getElementById("entradaForm");
  const resultadoCard = document.getElementById("resultadoCard");
  const jsonOutput = document.getElementById("jsonOutput");
  const pdfBtn = document.getElementById("pdfBtn");

  let productoIndex = 0;
  let data = {}; // Guardaremos el JSON aquí

  // 🔹 Agregar bloque de producto
  addProductoBtn.addEventListener("click", () => {
    productoIndex++;
    const productoDiv = document.createElement("div");
    productoDiv.className = "border rounded p-3 mb-4 bg-light";
    productoDiv.innerHTML = `
      <h5 class="mb-3">Producto ${productoIndex}</h5>
      <div class="row g-3">
        <div class="col-md-5">
          <label class="form-label">Producto</label>
          <select class="form-select productoSelect" name="producto_${productoIndex}" required>
            <option value="">Seleccione...</option>
            ${productosData.map(p => `<option value="${p.codigo}">${p.codigo} - ${p.descripcion}</option>`).join("")}
          </select>
        </div>
        <div class="col-md-2">
          <label class="form-label">Cantidad</label>
          <input type="number" class="form-control cantidad" name="cantidad_${productoIndex}" min="1" required>
        </div>
        <div class="col-md-3">
          <label class="form-label">Precio Unitario</label>
          <input type="number" step="0.01" class="form-control" name="precio_${productoIndex}" required>
        </div>
      </div>
      <div class="mt-3">
        <label class="form-label">Identificadores por unidad</label>
        <div class="row g-2 serialesContainer"></div>
      </div>
    `;
    productosContainer.appendChild(productoDiv);

    // 🔹 Activar select2
    $(productoDiv).find(".productoSelect").select2({
      width: "100%",
      placeholder: "Seleccione un producto"
    });

    // 🔹 Vincular evento de cantidad
    const cantidadInput = productoDiv.querySelector(".cantidad");
    const serialesContainer = productoDiv.querySelector(".serialesContainer");

    cantidadInput.addEventListener("input", () => {
      serialesContainer.innerHTML = "";
      const cantidad = parseInt(cantidadInput.value) || 0;
      for (let i = 1; i <= cantidad; i++) {
        const div = document.createElement("div");
        div.className = "col-md-12";
        div.innerHTML = `
          <div class="card p-2 mb-2">
            <h6 class="text-muted">Unidad ${i}</h6>
            <div class="row g-2">
              <div class="col-md-4">
                <input type="text" class="form-control" name="barcode_${productoIndex}_${i}" placeholder="Código de Barras">
              </div>
              <div class="col-md-4">
                <input type="text" class="form-control" name="serial_${productoIndex}_${i}" placeholder="Número de Serie">
              </div>
              <div class="col-md-4">
                <input type="text" class="form-control" name="imei_${productoIndex}_${i}" placeholder="IMEI (opcional)">
              </div>
            </div>
          </div>
        `;
        serialesContainer.appendChild(div);
      }
    });
  });

  // 🔹 Generar JSON
  form.addEventListener("submit", (e) => {
    e.preventDefault();
    const formData = new FormData(form);
    const productos = [];

    for (let p = 1; p <= productoIndex; p++) {
      const prodCodigo = formData.get(`producto_${p}`);
      if (!prodCodigo) continue;

      const cantidad = parseInt(formData.get(`cantidad_${p}`)) || 0;
      const unidades = [];
      for (let u = 1; u <= cantidad; u++) {
        unidades.push({
          CodigoBarras: formData.get(`barcode_${p}_${u}`) || null,
          NumeroSerie: formData.get(`serial_${p}_${u}`) || null,
          IMEI: formData.get(`imei_${p}_${u}`) || null
        });
      }

      const productoInfo = productosData.find(item => item.codigo === prodCodigo);

      productos.push({
        Codigo: prodCodigo,
        Descripcion: productoInfo ? productoInfo.descripcion : null,
        Cantidad: cantidad,
        PrecioUnitario: formData.get(`precio_${p}`),
        Unidades: unidades
      });
    }

    data = {
      FechaRegistro: new Date().toISOString(),
      Productos: productos
    };

    resultadoCard.classList.remove("d-none");
    jsonOutput.textContent = JSON.stringify(data, null, 2);

    // Mostrar botón PDF
    pdfBtn.classList.remove("d-none");
  });

  // 🔹 Exportar a PDF
  pdfBtn.addEventListener("click", () => {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF();

    let y = 20;
    doc.setFontSize(14);
    doc.text("Entrada de Inventario", 10, y);
    y += 10;
    doc.setFontSize(10);
    doc.text(`Fecha de Registro: ${data.FechaRegistro}`, 10, y);
    y += 10;

    data.Productos.forEach((prod, idx) => {
      doc.setFontSize(12);
      doc.text(`Producto ${idx+1}: ${prod.Codigo} - ${prod.Descripcion}`, 10, y);
      y += 7;
      doc.setFontSize(10);
      doc.text(`Cantidad: ${prod.Cantidad} | Precio Unitario: ${prod.PrecioUnitario}`, 10, y);
      y += 7;

      prod.Unidades.forEach((u, i) => {
        doc.text(`  Unidad ${i+1}: CB: ${u.CodigoBarras || "-"}, Serie: ${u.NumeroSerie || "-"}, IMEI: ${u.IMEI || "-"}`, 12, y);
        y += 6;
        if (y > 280) { // salto de página
          doc.addPage();
          y = 20;
        }
      });
      y += 5;
    });

    doc.save("entrada_inventario.pdf");
  });
});
</script>
