
    <style>
        .section-title {
            margin-top: 30px;
            color: #0056b3;
            border-bottom: 2px solid #0056b3;
            padding-bottom: 10px;
            display: flex;
            align-items: center;
            font-weight: bold;
        }

        .section-title i {
            margin-right: 10px;
            font-size: 1.5em;
            color: #0056b3;
        }

        .form-section {
            margin-bottom: 30px;
            padding: 15px;
            border: 1px solid #e0e0e0;
            border-radius: 10px;
            background-color: #f9f9f9;
            box-shadow: 0px 2px 4px rgba(0, 0, 0, 0.1);
        }

        .form-control {
            margin-bottom: 10px;
        }

        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
            font-size: 1.1em;
            padding: 10px 20px;
        }
    </style>
<div class="container mt-5">
    <div id="dynamicForm"></div>
    <button class="btn btn-primary mt-3" type="button" onclick="submitForm()">
        <i class="fa fa-paper-plane"></i> Enviar
    </button>
 
	 <button class="btn btn-secondary" onclick="confirmarRedireccion()">
        <i class="fa fa-folder-open-o"></i> Ver Expediente
    </button>

    <script>
        function confirmarRedireccion() {
            var confirmacion = confirm("¿Está seguro de que desea ver el expediente?");
            if (confirmacion) {
                window.location.href = 'http://167.172.224.160/MiSi/Index/index1.php?contenido=PacientesExpediente&icono=icon-people';
            }
        }
    </script>
	
	
</div>
<?php 
    $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
	$datosJson = ($datosNotas);
?>

<script>
    const formData = {
        "formTitle": "Historia Clinica Dental",
        "sections": [
            {
                "sectionTitle": "Ficha Identificación",
                "fields": [
                    { "label": "Nombre", "type": "textbox", "id": "nombre", "icon": "fa-user" },
                    { "label": "Edad", "type": "textbox", "id": "edad", "icon": "fa-calendar" },
                    { "label": "Ocupación", "type": "textbox", "id": "ocupacion", "icon": "fa-briefcase" },
                    { "label": "Fecha de Nacimiento", "type": "textbox", "id": "fecha_nacimiento", "icon": "fa-birthday-cake" },
                    { "label": "Escolaridad", "type": "textbox", "id": "escolaridad", "icon": "fa-graduation-cap" },
                    { "label": "Domicilio", "type": "textbox", "id": "domicilio", "icon": "fa-home" },
                    { "label": "Estado Civil", "type": "textbox", "id": "estado_civil", "icon": "fa-heart" },
                    { "label": "En caso de urgencia llamar a", "type": "textbox", "id": "urgencia", "icon": "fa-phone" },
                    { "label": "Número", "type": "textbox", "id": "numero", "icon": "fa-phone" }
                ]
            },
            {
                "sectionTitle": "Motivo de Consulta",
                "fields": [
                    { "label": "Motivo de Consulta", "type": "textarea", "id": "motivo_consulta", "icon": "fa-comment" }
                ]
            },
            {
                "sectionTitle": "Antecedentes personales no patológicos",
                "fields": [
						{ "label": "Vacunación completa", "type": "checkbox", "id": "vacunacion_completa", "icon": "fa-check" },
						{ "label": "Actividad física", "type": "checkbox", "id": "actividad_fisica", "icon": "fa-heart" },
						{ "label": "Anestesia Sí", "type": "checkbox", "id": "anestesiaSi", "icon": "fa-medkit" },
						{ "label": "Anestesia No", "type": "checkbox", "id": "anestesiaNo", "icon": "fa-ban" },
						{ "label": "Alergias", "type": "textbox", "id": "alergias", "icon": "fa-warning" },
						{ "label": "¿Has tenido reacciones?", "type": "textarea", "id": "AnestesiaReaccion", "icon": "fa-question-circle" },
						{ "label": "Intervenciones quirúrgicas", "type": "textarea", "id": "intervenciones", "icon": "fa-user-md" },
						{ "label": "Complicaciones", "type": "textarea", "id": "complicaciones", "icon": "fa-exclamation-circle" },
						{ "label": "Enfermedades actuales", "type": "textarea", "id": "enfermedades_actuales", "icon": "fa-heartbeat" },
						{ "label": "Medicamentos", "type": "textarea", "id": "medicamentos", "icon": "fa-medkit" }
					]

            },
            {
                "sectionTitle": "Antecedentes patológicos y hereditarios",
                "fields": [
                    { "label": "Cáncer", "type": "checkboxGroup", "id": "cancer", "options": ["Padre", "Madre", "Abuelo Materno", "Abuela Materna", "Abuelo Paterno", "Abuela Paterna"], "icon": "fa-cancer" },
                    { "label": "Diabetes", "type": "checkboxGroup", "id": "diabetes", "options": ["Padre", "Madre", "Abuelo Materno", "Abuela Materna", "Abuelo Paterno", "Abuela Paterna"], "icon": "fa-blood-type" },
                    { "label": "Hipertensión", "type": "checkboxGroup", "id": "hipertension", "options": ["Padre", "Madre", "Abuelo Materno", "Abuela Materna", "Abuelo Paterno", "Abuela Paterna"], "icon": "fa-heartbeat" },
                    { "label": "Cardiopatías", "type": "checkboxGroup", "id": "cardiopatias", "options": ["Padre", "Madre", "Abuelo Materno", "Abuela Materna", "Abuelo Paterno", "Abuela Paterna"], "icon": "fa-heart" },
                    { "label": "Otra (especificar)", "type": "textbox", "id": "otra_hereditaria", "icon": "fa-pencil" }
                ]
            },
           {
    "sectionTitle": "Antecedentes personales patológicos",

			   
			   "fields": [
    { "label": "Cáncer", "type": "checkbox", "id": "cancer_personal", "icon": "fa-stethoscope" },
    { "label": "Diabetes", "type": "checkbox", "id": "diabetes_personal", "icon": "fa-tint" },
    { "label": "Hipertensión", "type": "checkbox", "id": "hipertension_personal", "icon": "fa-heartbeat" },
    { "label": "Cardiopatías", "type": "checkbox", "id": "cardiopatias", "icon": "fa-heart" },
    { "label": "Convulsiones", "type": "checkbox", "id": "convulsiones", "icon": "fa-warning" },
    { "label": "Epilepsia", "type": "checkbox", "id": "epilepsia", "icon": "fa-bolt" },
    { "label": "Hipotiroidismo", "type": "checkbox", "id": "hipotiroidismo", "icon": "fa-circle" },
    { "label": "Hipertiroidismo", "type": "checkbox", "id": "hipertiroidismo", "icon": "fa-circle-o" },
    { "label": "Gastritis", "type": "checkbox", "id": "gastritis", "icon": "fa-cutlery" },
    { "label": "Colitis", "type": "checkbox", "id": "colitis", "icon": "fa-cutlery" },
    { "label": "Hepatitis", "type": "checkbox", "id": "hepatitis", "icon": "fa-plus-square" },
    { "label": "Asma", "type": "checkbox", "id": "asma", "icon": "fa-cloud" },
    { "label": "VIH/SIDA", "type": "checkbox", "id": "vih", "icon": "fa-ambulance" },
    { "label": "VPH", "type": "checkbox", "id": "vph", "icon": "fa-medkit" },
    { "label": "Sífilis", "type": "checkbox", "id": "sifilis", "icon": "fa-warning" },
    { "label": "Gripes frecuentes", "type": "checkbox", "id": "gripes_frecuentes", "icon": "fa-user-md" },
    { "label": "Problemas en columna", "type": "checkbox", "id": "problemas_columna", "icon": "fa-wheelchair" },
    { "label": "Insomnio", "type": "checkbox", "id": "insomnio", "icon": "fa-moon-o" },
    { "label": "Artritis", "type": "checkbox", "id": "artritis", "icon": "fa-hand-o-right" },
    { "label": "Fracturas óseas", "type": "checkbox", "id": "fracturas_oseas", "icon": "fa-plus" },
    { "label": "Otras", "type": "textbox", "id": "OtrasP", "icon": "fa-pencil" }
]

}
,
			  {
            "sectionTitle": "Hábitos",
            "fields": [
                { "label": "¿Fuma?", "type": "checkbox", "id": "fuma", "icon": "fa-smoking" },
                { "label": "¿Consume alcohol?", "type": "checkbox", "id": "alcohol", "icon": "fa-glass-whiskey" },
                { "label": "¿Consume otras sustancias?", "type": "checkbox", "id": "otras_sustancias", "icon": "fa-capsules" },
                { "label": "¿Cuáles?", "type": "textarea", "id": "cuales_sustancias", "icon": "fa-question" }
            ]
        },
        {
            "sectionTitle": "Condiciones Femeninas",
            "fields": [
                { "label": "¿Está embarazada?", "type": "checkbox", "id": "embarazada", "icon": "fa-child" },
                { "label": "Semanas de gestación", "type": "textbox", "id": "semanas_gestacion", "icon": "fa-calendar" },
                { "label": "¿Está lactando?", "type": "checkbox", "id": "lactando", "icon": "fa-baby" },
                { "label": "¿Tiene problemas menstruales?", "type": "checkbox", "id": "problemas_menstruales", "icon": "fa-female" },
                { "label": "¿Cuáles?", "type": "textarea", "id": "cuales_problemas", "icon": "fa-question" }
            ]
        },
            {
                "sectionTitle": "Consentimiento Informado",
                "fields": [
                    { "label": "Firma del Paciente", "type": "textbox", "id": "firma_paciente", "icon": "fa-signature" },
                    { "label": "Firma del Doctor", "type": "textbox", "id": "firma_doctor", "icon": "fa-user-md" },
                    { "label": "Fecha de Consentimiento", "type": "textbox", "id": "fecha_consentimiento", "icon": "fa-calendar-check" },
                    { "label": "Subir Imagen de Consentimiento", "type": "file", "id": "consent_image", "icon": "fa-file-upload" }
                ]
            },
            {
                "sectionTitle": "Términos de Consentimiento",
                "fields": [
                    { "label": "He sido informado acerca del diagnóstico y plan de tratamiento", "type": "checkbox", "id": "info_diagnostico", "icon": "fa-info-circle" },
                    { "label": "Autorizo el uso de anestesia local", "type": "checkbox", "id": "autorizo_anestesia", "icon": "fa-check" },
                    { "label": "Autorizo procedimientos relacionados con mi atención dental", "type": "checkbox", "id": "autorizo_procedimientos", "icon": "fa-check" },
                    { "label": "He leído y comprendido esta información", "type": "checkbox", "id": "leido_comprendido", "icon": "fa-check" }
                ]
            }
        ]
    };                                                                                                                                                                                                                                                                                               
	
	function generateForm() {
    const formContainer = document.getElementById('dynamicForm');
    formContainer.innerHTML = `<h2>${formData.formTitle}</h2>`;

    formData.sections.forEach(section => {
        const sectionDiv = document.createElement('div');
        sectionDiv.classList.add('form-section');
        sectionDiv.innerHTML = `<h3 class="section-title"><i class="fa ${section.fields[0].icon}"></i>${section.sectionTitle}</h3>`;
        const rowDiv = document.createElement('div');
        rowDiv.classList.add('row');

        section.fields.forEach(field => {
            const colDiv = document.createElement('div');
            colDiv.classList.add('col-md-6');

            if (field.type === 'textbox') {
                colDiv.innerHTML = `
                    <div class="form-group">
                        <label for="${field.id}"><i class="fa ${field.icon}"></i> ${field.label}</label>
                        <input type="text" class="form-control" id="${field.id}" placeholder="${field.label}">
                    </div>`;
            } else if (field.type === 'textarea') {
                colDiv.innerHTML = `
                    <div class="form-group">
                        <label for="${field.id}"><i class="fa ${field.icon}"></i> ${field.label}</label>
                        <textarea class="form-control" id="${field.id}" rows="3" placeholder="${field.label}"></textarea>
                    </div>`;
            } else if (field.type === 'checkbox') {
                colDiv.innerHTML = `
                    <div class="form-group form-check">
                        <input type="checkbox" class="form-check-input" id="${field.id}">
                        <label class="form-check-label" for="${field.id}"><i class="fa ${field.icon}"></i> ${field.label}</label>
                    </div>`;
            } else if (field.type === 'checkboxGroup') {
                colDiv.innerHTML = `<label><i class="fa ${field.icon}"></i> ${field.label}</label>`;
                field.options.forEach(option => {
                    colDiv.innerHTML += `
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="${field.id}_${option}" value="${option}">
                            <label class="form-check-label" for="${field.id}_${option}">${option}</label>
                        </div>`;
                });
            } else if (field.type === 'file') {
                colDiv.innerHTML = `
                    <div class="form-group">
                        <label for="${field.id}"><i class="fa ${field.icon}"></i> ${field.label}</label>
                        <input type="file" class="form-control" id="${field.id}">
                    </div>`;
            }

            rowDiv.appendChild(colDiv);
        }); 

        sectionDiv.appendChild(rowDiv);
        formContainer.appendChild(sectionDiv);
    });
}

function submitForm() {
    const answers = {};

    formData.sections.forEach(section => {
        // Creamos un objeto para cada sección
        const sectionAnswers = {};

        section.fields.forEach(field => {
            let value;

            // Obtener el valor dependiendo del tipo de campo
            if (field.type === 'textbox' || field.type === 'textarea') {
                value = document.getElementById(field.id).value;
            } else if (field.type === 'checkbox') {
                value = document.getElementById(field.id).checked; // Verdadero o falso
            } else if (field.type === 'checkboxGroup') {
                const checkedOptions = [];
                field.options.forEach(option => {
                    if (document.getElementById(`${field.id}_${option}`).checked) {
                        checkedOptions.push(option); // Guardar opciones seleccionadas
                    }
                });
                value = checkedOptions.length > 0 ? checkedOptions : null; // Retornar null si no hay selección
            } else if (field.type === 'file') {
                value = document.getElementById(field.id).files.length > 0 ? document.getElementById(field.id).files[0].name : null; // Guardar nombre del archivo
            }

            // Solo incluir en la sección si hay un valor definido
            if (value !== undefined && value !== null) {
                sectionAnswers[field.id] = value;
            }
        });

        // Solo incluir la sección en el JSON si tiene respuestas
        if (Object.keys(sectionAnswers).length > 0) {
            answers[section.sectionTitle] = sectionAnswers;
        }
    });

    console.log(JSON.stringify(answers)); 
    guardar(JSON.stringify(answers)); // Aquí puedes reemplazarlo con la lógica real de envío
}

    // Función guardar para enviar el JSON serializado
    function guardar(json) {
        var datos = {
            IDU: <?php echo $iduul; ?> + "",
            IDC: <?php echo $idPaciente; ?> + "",
            Tipo: "HC",
            Observaciones: "-",
        	Datos: json,
            Token: "<?php echo bin2hex(openssl_random_pseudo_bytes(4)); ?>",
            Conjunto_A: "1",
            Conjunto_B: "2"
        };

        var valores = JSON.stringify(datos);
		//console.log(valores); 
        var formData = {
            id: 0,
            valores: valores, 
            funcion: "insert"
        };

        $.ajax({
            url: '<?php echo $urlajaxUpdate; ?>',
            type: 'POST',
            data: formData,
            success: function(response) {
                $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
                setTimeout(function() { $('#Mensaje').empty(); }, 2000);
                console.log(response);
               // setTimeout(function() { location.reload(); }, 3000);
            },
            error: function(error) {
                console.error('Error al enviar datos al servidor:', error);
            }
        });
    }

	
	function openPrintWindow() {
    window.open(
        'http://167.172.224.160/MiSi/librerias/Impresora/ImprimirHistorialClinico.php',
        '_blank',
        'width=800,height=600'
    );
}


generateForm();

</script>
