  <div class="container mt-5">
    <div class="row" id="tarjetas-container">
      <!-- Las tarjetas se generarán aquí -->
    </div>
  </div>

  <script>
    // Datos JSON con URL de ejemplo
const documentos = [
  { "nombre": "Historial Clínico", "icono": "fa-user-md", "id": "historialClinico", "url": "https://ejemplo.com/historial-clinico" },
  { "nombre": "Odontograma", "icono": "fa-sitemap", "id": "odontograma", "url": "https://ejemplo.com/odontograma" },
  { "nombre": "Endodoncia", "icono": "fa-leaf", "id": "endodoncia", "url": "https://ejemplo.com/endodoncia" },
  { "nombre": "Ortodoncia", "icono": "fa-align-center", "id": "ortodoncia", "url": "https://ejemplo.com/ortodoncia" },
  { "nombre": "Implantes Dentales", "icono": "fa-cogs", "id": "implantesDentales", "url": "https://ejemplo.com/implantes-dentales" },
  { "nombre": "Cirugía Maxilofacial", "icono": "fa-scissors", "id": "cirugiaMaxilofacial", "url": "https://ejemplo.com/cirugia-maxilofacial" },
  { "nombre": "Anestesia", "icono": "fa-eyedropper", "id": "anestesia", "url": "https://ejemplo.com/anestesia" },
  { "nombre": "Recetas", "icono": "fa-file-text", "id": "recetas", "url": "https://ejemplo.com/recetas" },
  { "nombre": "Justificantes", "icono": "fa-check-square-o", "id": "justificantes", "url": "https://ejemplo.com/justificantes" },
  { "nombre": "Membresía", "icono": "fa-users", "id": "membresia", "url": "https://ejemplo.com/membresia" },
  { "nombre": "Cotizaciones", "icono": "fa-money", "id": "cotizaciones", "url": "https://ejemplo.com/cotizaciones" },
  { "nombre": "Pagos", "icono": "fa-credit-card", "id": "pagos", "url": "https://ejemplo.com/pagos" }
];


    // Función para generar las tarjetas
    function generarTarjetas() {
      const container = document.getElementById('tarjetas-container');
      documentos.forEach(doc => {
        const tarjeta = document.createElement('div');
        tarjeta.classList.add('col-md-4', 'mb-4');
        
        tarjeta.innerHTML = `
          <div class="card">
            <div class="card-body text-center">
              <i class="fa ${doc.icono} fa-3x mb-3"></i>
              <h5 class="card-title">${doc.nombre}</h5>
              <div class="d-flex justify-content-center">
                <i class="fa fa-external-link fa-2x mx-2" style="cursor: pointer;" onclick="imprimir('${doc.id}')"></i>
                <i class="fa fa-print fa-2x mx-2" style="cursor: pointer;" onclick="ejecutarFuncion('${doc.id}')"></i>
              </div>
            </div>
          </div>
        `; 
        
        container.appendChild(tarjeta);
      });
    }

    // Función genérica para ejecutar funciones personalizadas
    function ejecutarFuncion(docId) {
      if (typeof window[docId] === 'function') {
        window[docId](); // Llama a la función si existe
      } else {
        console.error(`La función ${docId} no está definida.`);
      }
    }

    // Función para manejar la impresión
    function imprimir(docId) {
      alert(`Se imprimirá el documento: ${docId}`);
      // Puedes implementar la lógica para imprimir
      window.print();
    }

    // Generamos las tarjetas al cargar la página
    generarTarjetas();



    // Puedes agregar más funciones manualmente aquí...
  </script>
