<!DOCTYPE html>
<html>
<head>
    <title>Calendario de Ahorros</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link href='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/main.min.css' rel='stylesheet' />
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
        }
        #calendar {
            width: 100%;
            max-width: 1200px;
            margin: 20px auto;
            box-sizing: border-box;
        }
        .fc-event {
            text-align: center;
            font-size: 1.2em;
            padding: 5px;
            white-space: normal;
            overflow: hidden;
        }
        .container {
            padding: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Calendario de Ahorros</h1>
        <div id='calendar'></div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="modalAhorro" tabindex="-1" aria-labelledby="modalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">Registrar Ahorro</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="formAhorro">
                        <div class="form-group">
                            <label for="fecha">Fecha</label>
                            <input type="text" class="form-control" id="fechaSeleccionada" readonly>
                        </div>
                        <div class="form-group">
                            <label for="concepto">Concepto</label>
                            <select class="form-control" id="concepto" required>
                                <option value="">Seleccione un concepto</option>
                                <option value="Cajita">Cajita</option>
                                <option value="Deposito">Depósito</option>
                                <option value="Inversion">Inversión</option>
                                <option value="Pago">Pago</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="monto">Monto</label>
                            <input type="number" class="form-control" id="monto" min="0" required>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    <button type="button" class="btn btn-primary" id="guardarAhorro">Guardar</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/main.min.js'></script>

	
	
	<?php 
//UPDATE `MicroSi_Datos`.`1-Catalogo` SET `Codigo` = '11' WHERE (`IDCa` = '1');
 $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
 
?>
    <script>
    $(document).ready(function() {
        var calendarEl = document.getElementById('calendar');
        var eventos = <?php
            // PHP: Convertir el arreglo de ahorros en eventos de calendario con colores por concepto
            $ahorros = $datos;
            function determinarColor($concepto) {
                switch ($concepto) {
                    case 'Cajita': return 'green';
                    case 'Pago': return 'red';
                    case 'Inversion': return 'orange';
                    case 'Deposito': return 'blue';
                    default: return 'black';
                }
            }

            $eventos = [];
            foreach ($ahorros as $ahorro) {
                $eventos[] = [
                    'title' => $ahorro['Concepto'] . ': $' . $ahorro['Monto'],
                    'start' => date('Y-m-d', strtotime($ahorro['TimeStamp'])),
                    'allDay' => true,
                    'backgroundColor' => determinarColor($ahorro['Concepto']),
                    'borderColor' => 'black'
                ];
            }
            echo json_encode($eventos);
        ?>;

        var calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            locale: 'es',
            events: eventos, // Insertar eventos desde PHP
            dateClick: function(info) {
                // Mostrar el modal al hacer clic en una fecha
                $('#fechaSeleccionada').val(info.dateStr);
                $('#concepto').val('');
                $('#monto').val('');
                $('#modalAhorro').modal('show');
            }
        });

        calendar.render();

        // Guardar los datos del formulario
        $('#guardarAhorro').click(function() {
            var fecha = $('#fechaSeleccionada').val();
            var concepto = $('#concepto').val();
            var monto = $('#monto').val();

            // Validación
            if (concepto === '') {
                alert('Por favor seleccione un concepto.');
                return;
            }
            if (monto === '' || monto <= 0) {
                alert('Por favor ingrese un monto válido.');
                return;
            }

            // Impresión en consola
            console.log({
                fecha: fecha,
                concepto: concepto,
                monto: parseFloat(monto)
            });
			
			guardar(concepto, monto, fecha);
            // Agregar el nuevo evento al calendario
            calendar.addEvent({
                title: concepto + ': $' + monto,
                start: fecha,
                allDay: true,
                backgroundColor: {
                    'Cajita': 'green',
                    'Pago': 'red',
                    'Inversion': 'orange',
                    'Deposito': 'blue'
                }[concepto] || 'black',
                borderColor: 'black'
            });

            // Cerrar el modal
            $('#modalAhorro').modal('hide');
        });
    });
var urlajaxUpdate = "<?php echo $urlajaxUpdate; ?>";		
		
		function guardar(C,M,F){
			
			alert();
			
			
var formData = {
        id: 0,
		IDU:"<?php echo $IDs;?>",
		Concepto: C,
		Monto: M,
		Vector: "0",
        funcion: "insertS"
		
    };	  
		$.ajax({
        url: urlajaxUpdate,
        type: 'POST',
        data: formData, 
        success: function(response) {
            // Maneja la respuesta del servidor
            $("#MensajeMM").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizó correctamente.</div>');
            setTimeout(function () { $('#MensajeMM').empty(); }, 2000);
            console.log(response);
			alert('Guardado correctamente.');
			location.reload();
			
        },
        error: function(error) {
			setTimeout(function () { $('#MensajeMM').empty(); }, 10);
			$("#MensajeMM").html('<div class="alert alert-danger alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Error </strong> Ocurrió un problema al actualizar.</div>');
			setTimeout(function () { $('#MensajeMM').empty(); }, 3000);
            console.error('Error al enviar datos al servidor:', error);
        }
    });	
		
		}
    </script>
</body>
</html>
