<style>
/* Tu CSS aquí */
.fc-timeGridDay-view .fc-day.fc-day-selected {
    background-color: #D6B5F5 !important;
    color: white !important;
    font-weight: bold;
	
	
}
	.fc-day-today {
    background-color: #E6E6FA !important; /* Color lavanda */
    color: #000000 !important; /* Color del texto */
    border: 2px solid #C8C8FF; /* Borde suave en un tono lavanda */
}

/* Asegúrate de que las celdas del día también tengan el color adecuado */
.fc-day.fc-day-today {
    background-color: #E5E8FF !important; /* Color lavanda para la celda */
    color: #000000 !important; /* Asegúrate de que el texto sea visible */
}

	.fc-event .fc-event-title {
    font-size: 3.1em;
    font-weight: bold;
}

.fc-event .fc-event-subtitle {
    font-size: 2.9em;
    color: #FFFFFF;
}
	
	.fc-event {
    position: relative;
    background-color: #007bff; /* Color de fondo de los eventos */
    color: #fff; /* Color del texto */
    border-radius: 5px; /* Bordes redondeados */
    padding: 5px;
    font-size: 12px;
    overflow: hidden; /* Asegura que el texto no sobresalga */
    box-sizing: border-box; /* Evita que el padding afecte el tamaño */
  }

  .fc-event .fc-title {
    font-size: 12px; /* Tamaño de fuente ajustado para que el texto quepa */
    white-space: normal; /* Permite que el texto se ajuste dentro del cuadro */
    word-wrap: break-word; /* Ajusta el texto largo */
  }

  .fc-time {
    font-size: 10px; /* Tamaño de la hora */
    font-weight: bold;
  }

  /* Ajustar el contenedor de la vista semanal */
  .fc-timeGrid-event {
    min-height: 30px; /* Mínima altura de los eventos */
    padding: 5px;
  }

  .fc-timeGrid-event-inner {
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    padding: 5px;
  }

</style>

<div class="row page-titles mx-0">
  <!-- Columna md-3 -->
  <div class="col-md-3" id="columna-filtrar">
    <div id="filtrar-eventos" class="mt-3">
      <h4>Filtrar Eventos</h4>
      <form id="formulario-filtro" class="form-inline">
        <div class="form-group mr-2">
          <label for="filtro-titulo" class="sr-only">Título:</label>
          <input type="text" class="form-control" id="filtro-titulo" name="filtro-titulo" placeholder="Título">
        </div>
        <button type="submit" class="btn btn-primary">Filtrar</button>
      </form>
    </div>
    <div id="mini-calendar"></div>
    <div id="citas-lista">
      <h4>Citas de hoy</h4>
      <ul id="citas">
      </ul>
    </div>
  </div>

  <!-- Columna md-8 -->
  <div class="col-md-8" id="columna-calendario">
    <div id="calendar"></div>
  </div>

  <!-- Columna md-1 -->
  <div class="col-md-1 d-flex flex-column align-items-center justify-content-center">
    <div class="row mb-3">
      <div class="col text-center">
        <button type="button" class="btn btn-warning btn-lg" onclick="toggleColumns()" id="toggle-column-btn">
          <i class="fa fa-calendar"></i>
        </button>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col text-center">
        <button type="button" class="btn btn-success btn-lg" id="agregar-evento-btn" data-toggle="modal" data-target="#agregarEventoModal"> 
          <i class="fa fa-plus"></i>
        </button>
      </div>
    </div>
    <div class="row mb-3">
      <div class="col text-center">
        <button type="button" class="btn btn-info btn-lg" onclick="agregarCliente()" id="agregar-cliente-btn" style="margin-top: 10px;"> 
          <i class="fa fa-user-plus"></i>
        </button>
      </div>
    </div>
    <div class="row mb-3">
      <div class="col text-center">
        <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#dataModal" id="lista-btn"> 
          <i class="fa fa-list"></i>
        </button>
      </div>
    </div>
    <div class="row mb-3">
      <div class="col text-center">
        <button type="button" class="btn btn-secondary btn-lg" id="info-btn"> 
          <i class="fa fa-info-circle"></i>
        </button>
      </div>
    </div>
  </div>
</div>

<script>
 
</script>


<!-- Modal --> 

<div class="modal fade" id="modalCalendario" tabindex="-1" role="dialog" aria-labelledby="modalCalendarioLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalCalendarioLabel">Calendario</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!-- Aquí puedes incluir tu calendario -->
        <div id="calendario-container">
          <!-- Ejemplo de contenedor para un calendario -->
          <p>Aquí irá tu calendario.</p>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Edición -->
<div class="modal fade" id="editarEventoModal" tabindex="-1" role="dialog" aria-labelledby="editarEventoModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #f0f0f0; border-color: #ccc; color: #333;">
        <h5 class="modal-title" id="editarEventoModalLabel">Editar Evento</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!-- Información Actual -->
        <div id="informacionActual" class="mb-3">
          <p><strong>Título del Evento:</strong> <span id="eventoTituloActual"></span></p>
          <p><strong>Fecha Actual:</strong> <span id="fechaActual"></span></p>
          <p><strong>Hora de Inicio:</strong> <span id="horaInicioActual"></span></p>
          <p><strong>Cliente:</strong> <span id="clienteNombreActual"></span></p>
          <p><strong>Doctor:</strong> <span id="doctorNombreActual"></span></p>
        </div>

        <!-- Botón para Mostrar Formulario -->
        <button type="button" class="btn btn-info" id="mostrarFormularioBtn"><i class="fa fa-edit"></i></button>
		  <button type="button" class="btn btn-danger" id="cancelarEdicionBtn">
    <i class="fa fa-times"></i>
</button>

        <!-- Formulario de Edición (Oculto por Defecto) -->
       
	<form id="formEditarEvento" style="display: none;">
  <div class="form-group">
    <label for="editarFecha">Nueva Fecha</label>
    <input type="date" class="form-control" id="editarFecha" required>
  </div>
  <div class="form-group">
    <label for="editarHora">Nueva Hora</label>
    <input type="time" class="form-control" id="editarHora" required>
  </div>
  <div class="form-group">
    <label for="editarAsignado">Asignado a</label>
    <select class="form-control" id="editarAsignado">
      <!-- Las opciones del select se llenarán dinámicamente con JavaScript -->
    </select>
  </div>
  <!-- Barra de color deshabilitada -->
  <div class="form-group">
    <input type="color" class="form-control" id="colorSelector" disabled>
  </div>
</form>
	  
		  
        <!-- Botón Guardar Cambios (Oculto por Defecto) -->
        <button type="button" class="btn btn-primary" id="guardarEdicionBtn" style="display: none;">Guardar Cambios</button>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>





<!-- Modal -->
<div class="modal fade" id="eventoModal" tabindex="-1" role="dialog" aria-labelledby="eventoModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header" id="colorbar" style="background-color: #f0f0f0; border-color: #ccc; color: #333;">
        <h5 class="modal-title" id="eventoModalLabel"> <span id="eventoTitulo"></span> <span id="iconoCliente" style="margin-left: 10px;"></span> <span id="iconoDoctor" style="margin-left: 10px;"></span> </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
      </div>
      <div class="modal-body">
        <p><strong>Inicio:</strong> <span id="modalInicio"></span></p>
        <p><strong>Fin:</strong> <span id="modalFin"></span></p>
        <p><strong>Cliente:</strong> <span id="clienteNombre"></span>, <span id="clienteTelefono"></span></p>
        <p><strong>Doctor:</strong> <span id="doctorNombre"></span>, <span id="doctorTelefono"></span></p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        <!-- Botón Editar en color morado -->
        <button type="button" class="btn" style="background-color: #800080; color: white;" id="editarEventoBtn">Editar</button>
      </div>
    </div>
  </div>
</div>
<?php
// Aquí se asume que $Agenda ya es un arreglo asociativo de PHP, no un JSON
$agenda_array = $Agenda; // No necesitas json_encode aquí, ya que $Agenda ya es un array
// Crear un nuevo arreglo para almacenar los eventos transformados
$eventos = [];



// Iterar a través del arreglo de $agenda y transformar los datos
foreach ( $agenda_array as $item ) {
    // Calcular la hora de fin sumando los minutos de duración al inicio
    $inicio = new DateTime( $item[ 'Inicio' ] );
    $fin = clone $inicio; // Clonar la instancia de DateTime para evitar modificar $inicio
    $fin->add( new DateInterval( 'PT' . $item[ 'Fin' ] . 'M' ) );

    $eventos[] = [
        'id' => $item[ 'IDH' ],
        'title' => $item[ 'Titulo' ],
		'nombre'=> $item[ 'Nombre' ],
        'start' => $item[ 'Inicio' ],
        'end' => $fin->format( 'Y-m-d\TH:i:s' ),
        'backgroundColor' => $item[ 'Color' ],
        'borderColor' => $item[ 'Color' ]
    ];
}
?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script> 
<script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/5.10.1/fullcalendar.min.js"></script> 
<script>
	
	
    var eventos = <?php echo json_encode($eventos); ?>;
	var idEvento;
   document.addEventListener('DOMContentLoaded', function () {
    var calendarEl = document.getElementById('calendar');
	var calendarG;
    var miniCalendarEl = document.getElementById('mini-calendar');
    var citasEl = document.getElementById('citas');
	console.log(eventos);


    // Mantener una referencia a los eventos
   var calendar = new FullCalendar.Calendar(calendarEl, {
    initialView: 'timeGridDay',
    locale: 'es',
    height: 1000, // Altura dinámica
    slotDuration: '00:10:00',
    slotMinTime: '06:00:00',
    slotMaxTime: '22:00:00',
    events: eventos,
    eventLimit: true,
    eventOverlap: false, // Intenta prevenir superposición de eventos
    eventAllow: function(dropInfo, draggedEvent) { // Validación adicional
        const events = calendar.getEvents();
        return events.every(event => {
            return !(
                event.start < dropInfo.end &&
                event.end > dropInfo.start
            );
        });
    },
    headerToolbar: {
        left: 'prev,next today',
        center: 'title',
        right: 'dayGridMonth,timeGridWeek,timeGridDay'
    },
    dayHeaderFormat: {
        weekday: 'long'
    },
    dayCellContent: function(arg) {
        var date = arg.date;
        var day = date.getDate();
        return day;
    },
    nowIndicator: true,
    eventClick: function(info) {
        var event = info.event;
        var eventId = event.id;
        idEvento = eventId;
        mostrarDetallesEvento(eventId);
    },
    dayRender: function(info) {
        var today = new Date().toISOString().slice(0, 10);
        var date = info.date;
        if (date.toISOString().slice(0, 10) === today) {
            info.el.style.backgroundColor = 'lavender';
        }
    },
    eventContent: function(arg) {
        let container = document.createElement('div');
        let title = document.createElement('div');
        title.textContent = arg.event.title;
        title.style.fontWeight = 'bold';
        container.appendChild(title);

        if (arg.event.extendedProps.nombre) {
            let cliente = document.createElement('div');
            cliente.textContent = arg.event.extendedProps.nombre;
            cliente.style.fontSize = '0.85em';
            cliente.style.color = '#555';
            container.appendChild(cliente);
        }

        return { domNodes: [container] };
    }
});

window.addEventListener('resize', () => {
    calendar.setOption('height', window.innerHeight - 100);
});

    var miniCalendar = new FullCalendar.Calendar(miniCalendarEl, {
        initialView: 'dayGridMonth', // Vista de mes para el calendario pequeño
        locale: 'es',
        height: 490,
        aspectRatio: 1.8,
        headerToolbar: {
            left: 'prev',
            center: 'title',
            right: 'next'
        },
        titleFormat: {
            year: 'numeric', // Mostrar solo el año
            month: 'numeric' // Mostrar solo el mes
        },
        dateClick: function (info) {
            calendar.gotoDate(info.date); // Navegar al día seleccionado en el calendario grande
        }
    });

    calendar.render();
    miniCalendar.render();

    calendar.on('dateClick', function (info) {
        var citas = getCitas(info.dateStr);
        renderCitas(citas);
    });

    function getCitas(date) {
        var citas = eventos.filter(function (evento) {
            return moment(evento.start).format('YYYY-MM-DD') === date;
        }).map(function (evento) {
            return evento.title;
        });
        return citas;
    }

    function renderCitas(citas) {
        citasEl.innerHTML = '';
        citas.forEach(function (cita) {
            var li = document.createElement('li');
            li.textContent = cita;
            citasEl.appendChild(li);
        });
    }
	 const columnaFiltrar = document.getElementById('columna-filtrar');
    const columnaCalendario = document.getElementById('columna-calendario');

    // Asegurar que las columnas estén visibles al cargar
    columnaFiltrar.classList.remove('d-none');
    columnaCalendario.classList.remove('col-md-11');
    columnaCalendario.classList.add('col-md-8');

    // Ocultar la columna md-3 después de 1 segundo
    setTimeout(() => {

      columnaFiltrar.classList.add('d-none');
      columnaCalendario.classList.remove('col-md-8');
      columnaCalendario.classList.add('col-md-11');
	  calendar.changeView('timeGridWeek');
	  


	
    }, 1000);   
	   
	   
});
	
	function abrirCalendario() {
    // Mostrar el modal del calendario
    $('#modalCalendario').modal('show');
  }
	
	
	// Función para alternar las columnas
  function toggleColumns() {
    const columnaFiltrar = document.getElementById('columna-filtrar');
    const columnaCalendario = document.getElementById('columna-calendario');

    if (columnaFiltrar.classList.contains('d-none')) {
      // Mostrar columna md-3 y ajustar md-8
      columnaFiltrar.classList.remove('d-none');
      columnaCalendario.classList.remove('col-md-11');
      columnaCalendario.classList.add('col-md-8');
    } else {
      // Ocultar columna md-3 y expandir md-8 a md-11
      columnaFiltrar.classList.add('d-none');
      columnaCalendario.classList.remove('col-md-8');
      columnaCalendario.classList.add('col-md-11');
    }
  }

	
	

function mostrarDetallesEvento(id) {
    $.ajax({
        url: 'http://167.172.224.160/MiSi/librerias/ajax/ajaxAgenda.php', // Cambia esta URL por la que corresponde en tu servidor
        type: 'POST',
        data: { evento_id: id },
        success: function (data) {
            try {
                if (typeof data === "string") {
                    data = JSON.parse(data);
                }

                if (data && data.Horario_Inicio && data.Cliente_Nombre && data.Loggin_Nombre) {
                    // Mostrar los datos actuales en el modal
                    document.getElementById('eventoTituloActual').textContent = data.Horario_Titulo || 'No disponible';
                    document.getElementById('fechaActual').textContent = moment(data.Horario_Inicio).format('YYYY-MM-DD');
                    document.getElementById('horaInicioActual').textContent = moment(data.Horario_Inicio).format('HH:mm');
                    document.getElementById('clienteNombreActual').textContent = data.Cliente_Nombre || 'No disponible';
                    document.getElementById('doctorNombreActual').textContent = data.Loggin_Nombre || 'No disponible';
					document.getElementById('colorSelector').textContent = data.Loggin_Color || 'No disponible';

                    // Llenar el formulario de edición con los datos del evento
                    document.getElementById('editarFecha').value = moment(data.Horario_Inicio).format('YYYY-MM-DD');
                    document.getElementById('editarHora').value = moment(data.Horario_Inicio).format('HH:mm');
                    document.getElementById('editarAsignado').value = data.Cliente_Nombre ? "cliente" : "doctor"; // Determinar quién está asignado

                    // Guardar el ID del evento en el modal para luego realizar la actualización
                    $('#editarEventoModal').attr('data-event-id', data.IDH);
                    
                    // Mostrar el modal
                    $('#editarEventoModal').modal('show');
                } else {
                    console.warn('Datos incompletos en la respuesta del servidor:', data);
                    alert('Los detalles del evento están incompletos o faltan datos.');
                }
            } catch (error) {
                console.error('Error procesando la respuesta del servidor:', error);
                alert('Hubo un error al procesar los datos del servidor.');
            }
        },
        error: function (xhr, status, error) {
            console.error('Error al obtener los detalles del evento:', error);
            alert('Hubo un error al obtener los detalles del evento.');
        }
    });

    // Al hacer clic en el botón "Editar Información", mostramos el formulario y el botón "Guardar Cambios"
    document.getElementById('mostrarFormularioBtn').addEventListener('click', function () {
        // Mostrar el formulario y el botón "Guardar Cambios"
        document.getElementById('formEditarEvento').style.display = 'block';
        document.getElementById('guardarEdicionBtn').style.display = 'inline-block'; // Mostrar el botón de guardar
    });
}

	
document.getElementById('guardarEdicionBtn').addEventListener('click', function() {
    
    var eventId = idEvento; // Obtener el ID del evento desde el modal
    var nuevaFecha = document.getElementById('editarFecha').value;
    var nuevaHora = document.getElementById('editarHora').value;
    var asignado = document.getElementById('editarAsignado').value;
	var color = document.getElementById('colorSelector').value;

    // Preparar los datos para la solicitud AJAX
    var datos = {
		tipo:"Editar",
        evento_id: eventId,
        nueva_fecha: nuevaFecha,
        nueva_hora: nuevaHora,
        asignado: asignado, 
		color: color 
    };
	console.log(datos);

    $.ajax({
        url: 'http://167.172.224.160/MiSi/librerias/ajax/ajaxAgendaEditar.php', // Cambia esta URL por la que corresponde en tu servidor
        type: 'POST',
        data: datos,
        success: function(response) {
            console.log(response);
           
                alert('Evento actualizado exitosamente.');
                $('#editarEventoModal').modal('hide');
                // Recargar la página para reflejar los cambios
                location.reload(); // Esto recarga la página actual
           
        },
        error: function(xhr, status, error) {
            console.error('Error al actualizar el evento:', error);
            alert('Hubo un error al actualizar el evento.');
        }
    });
});
	
	
	
document.getElementById('cancelarEdicionBtn').addEventListener('click', function() {
    // Acción al hacer clic en el botón de cancelar
	 var eventId = idEvento; 
    alert('Edición cancelada.'+idEvento);
    
var eventId = idEvento; // Obtener el ID del evento desde el modal
    var nuevaFecha = document.getElementById('editarFecha').value;
	var color = "#FF0000";

    // Preparar los datos para la solicitud AJAX
    var datos = {
		tipo:"Cancelar",
        evento_id: eventId
    };
	console.log(datos);

    $.ajax({
        url: 'http://167.172.224.160/MiSi/librerias/ajax/ajaxAgendaEditar.php', // Cambia esta URL por la que corresponde en tu servidor
        type: 'POST',
        data: datos,
        success: function(response) {
            console.log(response);
               alert('Evento actualizado exitosamente.');
                $('#editarEventoModal').modal('hide');
                // Recargar la página para reflejar los cambios
                location.reload(); // Esto recarga la página actual
        },
        error: function(xhr, status, error) {
            console.error('Error al actualizar el evento:', error);
            alert('Hubo un error al actualizar el evento.');
        }
    });
});




 // Arreglo de datos que proporcionaste
const arreglo = <?php echo json_encode($Asignables); ?>;
console.log(arreglo);

// Seleccionamos el <select> por ID y el input de color
const selectElement = document.getElementById('editarAsignado');
const colorSelector = document.getElementById('colorSelector');

// Recorremos el arreglo para agregar las opciones
arreglo.forEach(function(item) {
  // Creamos una nueva opción
  const option = document.createElement('option');
  
  // Establecemos el valor como el IDL
  option.value = item.IDL;
  
  // Añadimos los atributos `data-idl` y `data-color`
  option.setAttribute('data-idl', item.IDL);
  option.setAttribute('data-color', item.Color);
  
  // Añadimos el color (si existe) como un círculo antes del nombre
  const circle = item.Color ? `<span style="display:inline-block;width:10px;height:10px;border-radius:50%;background-color:${item.Color};margin-right:5px;"></span>` : '';
  
  // Establecemos el texto de la opción
  option.innerHTML = circle + item.Nombre;
  
  // Añadimos la opción al <select>
  selectElement.appendChild(option);
});

// Evento para actualizar el color en el input de tipo color
selectElement.addEventListener('change', function() {
  const selectedOption = selectElement.options[selectElement.selectedIndex];
  const color = selectedOption.getAttribute('data-color');

  // Actualizamos el valor del input de color con el color seleccionado
  if (color) {
    colorSelector.value = color;  // Asigna el color al input de tipo color
    colorSelector.disabled = false; // Habilita el input de color
  } else {
    colorSelector.disabled = true; // Deshabilita el input de color si no hay color
  }
});

// Asignar el color al cargar la página (si es necesario)
const initialColor = selectElement.options[selectElement.selectedIndex]?.getAttribute('data-color');
if (initialColor) {
  colorSelector.value = initialColor;
  colorSelector.disabled = false;
}
  
	
 document.getElementById('info-btn').onclick = function() {
    // Crear un formulario de manera dinámica
    var form = document.createElement('form');
    form.method = 'POST';
    form.action = window.location.href; // Mantener la misma URL

    // Crear un campo de formulario para enviar la variable 'todo'
    var input = document.createElement('input');
    input.type = 'hidden';
    input.name = 'todo';
    input.value = 'si';

    // Añadir el campo al formulario
    form.appendChild(input);

    // Añadir el formulario al body y enviarlo
    document.body.appendChild(form);
    form.submit();
  };
</script>