<?php
session_start();
?>
<div id="pagoCreditoRow" class="row page-titles mx-0" style="display: none;">
    <div class="col-sm-12 p-md-0">
        <div class="welcome-text">
            <h4>Pago de Crédito</h4>
            <span class="ml-1">Ingresa la cantidad a pagar</span>
        </div>
    </div>
<div class="col-sm-12 p-md-0 mt-2 mt-sm-0 d-flex justify-content-start">
    <div class="col-sm-12 col-md-12"> <!-- Hacer que el formulario ocupe 8 columnas -->
        <div class="card">
            <div class="card-body">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-danger text-white"><i class="fa fa-arrow-down"></i> <span class="credito_amount">0.00</span> </span>
                    </div>
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-success text-white"><i class="fa fa-arrow-up"></i> <span class="pago_amount">$0.00</span> </span>
                    </div>
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-primary text-white"><i class="fa fa-money"></i> <span class="total_amount">0.00</span> </span>
                    </div>
                    <input id="montoPago" type="number" class="form-control" min="0" placeholder="Monto a pagar...">
                    <div class="input-group-append">
                        <button id="btnPagarCredito" class="btn btn-success" type="button" onclick="PagarCredito()"><i class="fa fa-credit-card"></i> Pagar</button>
                    </div> 
                </div>
            </div>
        </div>
    </div>
</div>

</div>

<script>
	var IDCPago;
    function PagoCredito(idcliente) {
		IDCPago=idcliente.id;
        console.log(idcliente.id);
        pagoCreditoRow = document.getElementById('pagoCreditoRow');
        pagoCreditoRow.style.display = 'block';
        cargarCredito(idcliente);
    }

function PagarCredito() {
	//alert(cliente.id);
    var montoPago = $('#montoPago').val();
	var li;
    console.log('Monto a pagar:', montoPago);
    
    // Deshabilitar el botón Pagar
    $('#btnPagarCredito').prop('disabled', true);
     document.getElementById("montoPago").value = "";
	
	const agregar200 = confirm("¿Le gustaría agregar ahora al Libro  "+montoPago+" pesos?");
    if (agregar200) {
      
   	li = "&LDesc=PagoCredito_ID-"+IDCPago+"&libro=Si";	
	alert(li);
    }
		
	
    // Datos a enviar al servidor
    var datos = {
        IDL: "<?php echo $IDLs;?>",
        IDC: IDCPago,
        IDN: 0,
        Tipo: "Pago",
        Monto: montoPago,
        // Agrega el monto a los datos a enviar
		//IDL, IDC, IDN, Tipo, Monto
    };
    
    $.ajax({
        url: '<?php echo $urlajaxselectpagocredito; ?>' + IDCPago + li,
        type: 'POST',
        data: datos, // Envía los datos al servidor
        success: function(data) {
            console.log("--> " + data);
			cargartabla(IDCPago);
			cargarCredito(cliselec);
			
        },
        error: function(error) {
            console.error('Error al obtener datos de clientes:', error);
        }
    });
	
	
}




    function cargarCredito(clienteSel) {
		var cliente=clienteSel.id;
		//alert('<?php echo $urlajaxselectcredito; ?>' + cliente);
		// Realiza una solicitud Ajax para obtener los datos de los clientes
        $.ajax({
            url: '<?php echo $urlajaxselectcredito; ?>' + cliente,
            type: 'POST',
            success: function(data) {
                console.log("-> " + data);
                var jsonData = JSON.parse(data);
                $('.credito_amount').text('$' + jsonData[0][0]);
                $('.pago_amount').text('$' + jsonData[0][1]);
                $('.total_amount').text('$' + jsonData[0][2]);
            },
            error: function(error) {
                console.error('Error al obtener datos de clientes:', error);
            }
        });
    }
	
	
	
</script>
