<style>
    .banner-container {
        display: flex;
        justify-content: flex-start;
        align-items: center;
        padding: 20px;
        background-color: #f5f5f5;
        border-radius: 8px;
    }

    .btn-banner {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        width: 250px;
        height: 100px;
        margin-right: 20px;
        background-color: #007bff;
        color: white;
        font-size: 16px;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        position: relative;
    }

    .btn-banner i {
        font-size: 2em;
        margin-bottom: 5px;
    }

    .btn-banner select {
        position: absolute;
        bottom: -15px;
        width: 80%;
        margin-top: 10px;
        border-radius: 4px;
        padding: 5px;
    }

    .btn-banner-existencias {
        background-color: #28a745; /* Verde por defecto */
    }

    .btn-banner-existencias.faltantes {
        background-color: #dc3545; /* Rojo cuando faltantes */
    }

    .leyenda {
        margin-top: 10px;
        font-size: 14px;
        color: #FFFFFF;
        display: none;
    }

    .btn-banner-existencias.faltantes .leyenda {
        display: block;
    }
</style>

<?php
$jsonFaltante = json_encode($datosPro);
?>

<script>
    var faltanteData = <?php echo $jsonFaltante; ?>;
</script>

<div class="banner-container">
    <button class="btn-banner btn-banner-existencias" id="btnExistencias">
        <i class="fas fa-warehouse"></i>
        Existencias
        <span class="leyenda">Faltantes</span>
    </button>

    <button class="btn-banner" id="btnCategorias">
        <i class="fas fa-list-alt"></i>
        Categorías
        <select name="categoria" id="selectCategoria">
            <option value="">Selecciona categoría</option>
            <?php foreach ($datosCat as $categoria): ?>
                <option value="<?php echo htmlspecialchars($categoria['Categoria']); ?>">
                    <?php echo htmlspecialchars($categoria['Categoria']); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </button>

    <button class="btn-banner" id="btnProveedor">
        <i class="fas fa-truck"></i>
        Proveedor
        <select name="proveedor" id="selectProveedor">
            <option value="">Selecciona proveedor</option>
            <?php foreach ($datosPro as $proveedor): ?>
                <option value="<?php echo $proveedor['id']; ?>">
                    <?php echo $proveedor['Nombre']; ?>
                </option>
            <?php endforeach; ?>
        </select>
    </button>
</div>

<script>
    // Función para sincronizar el color del botón basado en la variable 'f' en la URL
    function sincronizarBotonExistencias() {
        let url = new URL(window.location.href);
        let valorF = url.searchParams.get('f');
        
        // Si el valor de 'f' es 'fal', aplicar la clase 'faltantes' (rojo)
        if (valorF === 'fal') {
            document.getElementById('btnExistencias').classList.add('faltantes');
        } else {
            // En caso contrario, asegurarse de que la clase 'faltantes' no esté aplicada (verde)
            document.getElementById('btnExistencias').classList.remove('faltantes');
        }
    }

    // Función para sincronizar los selects basado en las variables 'categoria' y 'proveedor' en la URL
    function sincronizarSelects() {
        let url = new URL(window.location.href);
        let categoria = url.searchParams.get('categoria');
        let proveedor = url.searchParams.get('proveedor');

        if (categoria) {
            document.querySelector('#btnCategorias select').value = categoria;
        } else {
            document.querySelector('#btnCategorias select').value = '';
        }

        if (proveedor) {
            document.querySelector('#btnProveedor select').value = proveedor;
        } else {
            document.querySelector('#btnProveedor select').value = '';
        }
    }

    // Llamar a las funciones para sincronizar al cargar la página
    sincronizarBotonExistencias();
    sincronizarSelects();

    // Lógica de cambio de color y recarga de página para el botón de existencias
    document.getElementById('btnExistencias').addEventListener('click', function() {
        this.classList.toggle('faltantes');
        
        // Determinar el valor de 'f' basado en el color del botón
        let valorF = this.classList.contains('faltantes') ? 'fal' : 'ext';
        
        // Obtener la URL actual
        let url = new URL(window.location.href);
        
        // Agregar o actualizar el parámetro 'f'
        url.searchParams.set('f', valorF);
        
        // Recargar la página con la nueva URL
        window.location.href = url.toString();
    });

    // Lógica para manejar cambios en el select de Categorías
    document.querySelector('#btnCategorias select').addEventListener('change', function() {
        let categoriaSeleccionada = this.value;

        // Obtener la URL actual
        let url = new URL(window.location.href);
        
        // Agregar o actualizar el parámetro 'categoria'
        url.searchParams.set('categoria', categoriaSeleccionada);
        
        // Recargar la página con la nueva URL
        window.location.href = url.toString();
    });

    // Lógica para manejar cambios en el select de Proveedor
    document.querySelector('#btnProveedor select').addEventListener('change', function() {
        let proveedorSeleccionado = this.value;

        // Obtener la URL actual
        let url = new URL(window.location.href);
        
        // Agregar o actualizar el parámetro 'proveedor'
        url.searchParams.set('proveedor', proveedorSeleccionado);
        
        // Recargar la página con la nueva URL
        window.location.href = url.toString();
    });
</script>
