
  <!-- Botón para abrir modal -->
  <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#gastosModal">Ver Gastos Fijos</button>
<div class="mt-3">
  <h5>Total de Gastos: $<span id="totalGastos">0</span></h5>
</div>

  <!-- Modal -->
  <div class="modal fade" id="gastosModal" tabindex="-1" aria-labelledby="gastosModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Gastos Fijos</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">

          <!-- Tabla de gastos -->
          <table class="table" id="gastosTable">
            <thead>
              <tr>
                <th>Nombre</th>
                <th>Monto</th>
                <th>Acciones</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>

          <!-- Botón para agregar nuevo gasto -->
          <button class="btn btn-success" onclick="agregarGasto()">Agregar Gasto</button>
        </div>
        <div class="modal-footer">
          <button class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
          <button class="btn btn-primary" onclick="generarJSON()">Generar JSON</button>
        </div>
      </div>
    </div>
  </div>
<?php 
//UPDATE MicroSi_Datos.1-Catalogo SET Codigo = '11' WHERE (IDCa = '1');
 $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

?>


  <!-- Resultado JSON -->
  <pre id="jsonOutput" class="mt-4"></pre>

  <script>
	  var totales=0;
    // Datos simulados de gastos fijos
    let gastos = [
      { nombre: "Renta", monto: 500 },
      { nombre: "Luz", monto: 120 },
      { nombre: "Internet", monto: 50 }
    ];

	  gastos = JSON.parse(<?php echo json_encode($gastos[0]["DatosGastosFijos"]); ?>);

	   console.log(gastos);
    // Mostrar gastos al abrir modal
    const gastosModal = document.getElementById('gastosModal');
    gastosModal.addEventListener('show.bs.modal', mostrarGastos);
	
    function mostrarGastos() {
      const tbody = document.querySelector("#gastosTable tbody");
      tbody.innerHTML = "";
      gastos.forEach((gasto, index) => {
        tbody.innerHTML += `
          <tr>
            <td><input type="text" class="form-control" value="${gasto.nombre}" onchange="editarGasto(${index}, 'nombre', this.value)"></td>
            <td><input type="number" class="form-control" value="${gasto.monto}" onchange="editarGasto(${index}, 'monto', this.value)"></td>
            <td><button class="btn btn-danger btn-sm" onclick="eliminarGasto(${index})">Eliminar</button></td>
          </tr>
        `;
      });
    }

    function editarGasto(index, campo, valor) {
      if (campo === "monto") valor = parseFloat(valor) || 0;
      gastos[index][campo] = valor;
    }

    function agregarGasto() {
      gastos.push({ nombre: "", monto: 0 });
      mostrarGastos();
		calcularTotal();
    }

    function eliminarGasto(index) {
      gastos.splice(index, 1);
      mostrarGastos();
		calcularTotal();
    }

    function generarJSON() {
      const salida = document.getElementById("jsonOutput");
		jsonGastos=JSON.stringify(gastos, null, 2);
		editarTabla(<?php echo $IDs;?>, "DatosGastosFijos", jsonGastos);
    	alert("Gastos fijos Actualizados.");
      salida.textContent = JSON.stringify(gastos, null, 2);
    }

function calcularTotal() {
  const total = gastos.reduce((sum, gasto) => sum + (parseFloat(gasto.monto) || 0), 0);
	totales=total;
  document.getElementById("totalGastos").textContent = total.toFixed(2);
}
	  calcularTotal();  
function editarTabla(id, columna, valor) {
    const formData = {
      id: id,
      column: columna,
      value: valor,
      funcion: "update"
    };


    // AJAX para enviar los datos al servidor
    $.ajax({
      url: '<?php echo $urlajaxUpdate; ?>',
      type: 'POST',
      data: formData,
      success: function(response) {
        $("#Mensaje").html(
          '<div class="alert alert-success alert-dismissible alert-alt fade show">' +
            '<button type="button" class="close h-100" data-dismiss="alert" aria-label="Close">' +
            '<span><i class="mdi mdi-close"></i></span></button>' +
            '<strong>Listo</strong> Se actualizó correctamente.</div>'
        );
        setTimeout(function() {
          $('#Mensaje').empty();
        }, 2000);
        console.log(response);
      },
      error: function(error) {
        console.error("Error al enviar datos al servidor:", error);
      }
    });
  }

  </script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
