<?php
include_once("header.php");
include_once("head1.php");
include_once("head2.php");

include("../conexion.php");
$IDs = $usu[0][0];
$db = new MySQL();
$sql = "SELECT IDCa, Descripcion_Corta, Capacidad, Existencia, Existencia_Min-Existencia AS Faltante, Costo FROM MicroSi_Datos.`$IDs-Catalogo`, MicroSi_Datos.`$IDs-Catalogo_Existencia`, MicroSi_Datos.`$IDs-Catalogo_Precio` WHERE IDCa=`$IDs-Catalogo_Existencia`.ID_Catalogo AND IDCa=`$IDs-Catalogo_Precio`.ID_Catalogo ORDER By Descripcion_Corta;";
$lista = $db->tablasDB2($sql);

$productos = $lista;
?>

<div class="container mt-5">
    <!-- Tabla -->
    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Descripción</th>
                <th>Capacidad</th>
                <th>Existencia</th>
                <th>Faltante</th>
                <th>Costo</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Recorre el arreglo y construye las filas de la tabla
            foreach ($productos as $producto) {
                echo '<tr>';
                echo '<td>' . $producto['IDCa'] . '</td>';
                echo '<td>' . $producto['Descripcion_Corta'] . '</td>';
                echo '<td>' . $producto['Capacidad'] . '</td>';
                echo '<td>' . $producto['Existencia'] . '</td>';
                echo '<td>' . $producto['Faltante'] . '</td>';
                echo '<td>' . $producto['Costo'] . '</td>';
                echo '<td>
                    <label class="switch">
                        <input type="checkbox" class="switch-input" data-id="' . $producto['IDCa'] . '" data-descripcion="' . $producto['Descripcion_Corta'] . '" data-capacidad="' . $producto['Capacidad'] . '" data-faltante="' . $producto['Faltante'] . '" data-costo="' . $producto['Costo'] . '" data-existencia="' . $producto['Existencia'] . '" ' . ($producto['Existencia'] >= $producto['Existencia_Min'] ? 'checked' : '') . '>
                        <span class="slider"></span>
                    </label>
                    </td>';
                echo '</tr>';
            }
            ?>
        </tbody>
    </table>
</div>

<style>
    /* Estilo para el switch deslizable */
    .switch {
        position: relative;
        display: inline-block;
        width: 60px;
        height: 34px;
    }

    .switch-input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: 0.4s;
        border-radius: 34px;
    }

    .slider:before {
        position: absolute;
        content: "";
        height: 26px;
        width: 26px;
        border-radius: 50%;
        left: 4px;
        bottom: 4px;
        background-color: white;
        transition: 0.4s;
    }

    .switch-input:checked + .slider {
        background-color: #4CAF50;
    }

    .switch-input:checked + .slider:before {
        transform: translateX(26px);
    }

    .slider:before {
        background-color: white;
    }
</style>

<script>
   document.addEventListener('DOMContentLoaded', function () {
    // Manejar el cambio de estado del switch
    var switches = document.querySelectorAll('.switch-input');
    
    switches.forEach(function (switchElement) {
        // Configuración inicial
        var id = switchElement.getAttribute('data-id');
        var descripcion = switchElement.getAttribute('data-descripcion');
        var capacidad = switchElement.getAttribute('data-capacidad');
        var faltante = switchElement.getAttribute('data-faltante');
        var costo = switchElement.getAttribute('data-costo');
        var existencia = switchElement.getAttribute('data-existencia');
        var existenciaMin = switchElement.getAttribute('data-existencia-min');
        var nconsulta = "<?php echo $consulta; ?>";

        // Establecer el color inicial del switch dependiendo del faltante
        if (parseFloat(faltante) === 0) {
            switchElement.nextElementSibling.style.backgroundColor = 'green';  // Faltante 0: verde
            switchElement.checked = true; // Deja el switch activado si faltante es 0
        } else if (parseFloat(faltante) > 0) {
            switchElement.nextElementSibling.style.backgroundColor = 'red'; // Faltante > 0: rojo
            switchElement.checked = false; // Deja el switch desactivado si faltante es mayor que 0
        }

        // Manejamos el cambio de estado
        switchElement.addEventListener('change', function () {
            var estado = switchElement.checked ? 'Sí' : 'No';
            var cantidadMinima;

            // Cambiar el color del switch dependiendo de la condición de faltante
            if (switchElement.checked) {
                cantidadMinima = faltante;
                switchElement.nextElementSibling.style.backgroundColor = 'green';  // Cambiar a verde si está marcado
            } else {
                cantidadMinima = 0;
                switchElement.nextElementSibling.style.backgroundColor = 'red';  // Cambiar a rojo si no está marcado
            }

            // Mostrar alerta con el ID y los datos
            alert('ID: ' + id + '\nDescripción: ' + descripcion + '\nCapacidad: ' + capacidad + '\nFaltante: ' + faltante + '\nCosto: ' + costo + '\nCantidad Mínima: ' + cantidadMinima + '\nCantidad 0: ' + (estado === 'No' ? 0 : ''));

            // Enviar los datos mediante AJAX
            $.ajax({
                type: 'POST',
                url: 'http://167.172.224.160/MiSi/PMS/bloques/ajax/ajaxUpdate.php', 
                data: {
                    id: id,
                    descripcion: descripcion,
                    capacidad: capacidad,
                    faltante: cantidadMinima,
                    costo: costo,
                    consulta: nconsulta
                },
                success: function (response) {
                    // Manejar la respuesta del servidor (puedes mostrar un mensaje de éxito, recargar la página, etc.)
                    console.log(response);
                     // Ocultar el modal después de guardar los cambios
                    setTimeout(function () { location.reload(); }, 1000);
                },
                error: function (error) {
                    // Manejar los errores de la solicitud Ajax
                    console.error(error);
                }
            });
        });
    });
});

</script>

<?php include_once("food1.php") ?>
<?php include_once("food2.php") ?>
