<style>
  /* Fuerza a que los modales aparezcan centrados más arriba */
  .modal-dialog {
    margin: 5vh auto !important;
  }

  /* Corrige posible desplazamiento en cadena de modales */
  .modal.show .modal-dialog {
    transform: none !important;
  }

	/* Desactivar fondo oscuro de los modales */
.modal-backdrop {
  display: none !important;
}

  /* Opcional: corrige stacking si usas dos modales */
  .modal-backdrop.show {
    z-index: 1040;
  }

  .modal.fade.show {
    z-index: 1050;
  }
</style>

<!-- Modal de Login -->
<meta charset="UTF-8" />
<div class="modal fade" id="authModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalTitle">Bienvenido</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="modalBody">
        <ul class="nav nav-tabs" id="authTabs" role="tablist">
          <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#login">Iniciar sesion</button>
          </li>
          <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#register">Registrarse</button>
          </li>
        </ul>

        <div class="tab-content pt-3">
          <div class="tab-pane fade show active" id="login">
            <input type="text" class="form-control mb-2" id="loginPhone" placeholder="Teléfono">
            <button class="btn btn-primary w-100" id="btnLogin">Ingresar</button>
          </div>
          <div class="tab-pane fade" id="register">
            <input type="text" class="form-control mb-2" id="regName" placeholder="Nombre">
            <input type="text" class="form-control mb-2" id="regPhone" placeholder="Teléfono">
            <input type="text" class="form-control mb-2" id="regAddress" placeholder="Dirección">
            <button class="btn btn-success w-100" id="btnRegister">Registrarse</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Detalles del Pedido --> 
<div class="modal fade" id="detallePedidoModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Detalle del Pedido</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="detallePedidoBody">
        <!-- Aquí van los detalles -->
      </div>
    </div>
  </div>
</div>

<!-- Carga jQuery desde CDN -->

<script>
  let usuario = null;
  let pedidos = [];
  let rating = 0;

  document.addEventListener("DOMContentLoaded", () => {
    const usuarios = <?php echo json_encode($usuarios); ?>;

    document.getElementById("btnLogin").addEventListener("click", () => {
      const phone = document.getElementById("loginPhone").value.trim();
      if (!phone) return alert("Ingresa tu teléfono");

      $.ajax({
        type: "POST",
        url: "app/ajax.php",
        data: { metodo: "loginT", phone },
        success: function (response) {
          try {
            const res = JSON.parse(response);
            if (res.status === "success" && res.data.length > 0) {
              const cliente = res.data[0];
              usuario = {
                idc: cliente.IDC,
                nombre: cliente.Nombre,
                telefono: cliente.Telefono,
                direccion: cliente.Direccion,
                calificacion: cliente.Rank || 0
              };
              rating = usuario.calificacion;
              consultarNotas(usuario.idc);
              mostrarPerfil();

              // 👇 valida botón después de login
              if (typeof validarCheckoutBtn === "function") validarCheckoutBtn();

              // Cierra modal de login
              bootstrap.Modal.getInstance(document.getElementById('authModal')).hide();
            } else {
              alert(res.message || "Usuario no encontrado");
            }
          } catch (e) {
            console.error("Error al procesar respuesta:", e);
            alert("Respuesta del servidor inválida");
          }
        },
        error: () => alert("Error de conexión")
      });
    });

    document.getElementById("btnRegister").addEventListener("click", () => {
      const name = document.getElementById("regName").value.trim();
      const phone = document.getElementById("regPhone").value.trim();
      const address = document.getElementById("regAddress").value.trim();
      if (!name || !phone || !address) return alert("Completa todos los campos");

      usuario = { nombre: name, telefono: phone, direccion: address };
      rating = 0;
      registrarCliente(usuario);
      mostrarPerfil();

      // 👇 valida botón después de registrar
      if (typeof validarCheckoutBtn === "function") validarCheckoutBtn();
    });
  });

  function registrarCliente(usuario) {
    const data = {
      metodo: 'reg',
      name: usuario.nombre,
      phone: usuario.telefono,
      address: usuario.direccion
    };

    $.ajax({
      type: 'POST',
      url: 'http://167.172.224.160/MiSi/P/app/ajax.php',
      data,
      success: function (response) {
        try {
          const res = JSON.parse(response);
          alert(res.message);
          if (res.status === 'success') {
            const modal = bootstrap.Modal.getInstance(document.getElementById('authModal'));
            modal.hide();
            // 👇 valida botón después de registrar
            if (typeof validarCheckoutBtn === "function") validarCheckoutBtn();
          }
        } catch (e) {
          console.error("Error al procesar respuesta:", e);
          alert("Respuesta del servidor inválida");
        }
      },
      error: () => alert("Error al registrar el cliente.")
    });
  }

  function consultarNotas(idCliente) {
    $.ajax({
      type: 'POST',
      url: 'app/ajax.php',
      data: { metodo: 'consultaUPedido', IDC: idCliente },
      success: function (response) {
        try {
          const res = JSON.parse(response);
          if (res.status === 'success') {
            pedidos = res.data;
            mostrarPerfil();
          } else {
            alert(res.message || 'No se encontraron pedidos');
          }
        } catch (e) {
          console.error("Error al procesar respuesta:", e);
          alert("Error en la respuesta del servidor.");
        }
      },
      error: () => alert("Error al consultar notas.")
    });
  }

  function contarVisitas() {
    let visitas = +localStorage.getItem("visitas") || 0;
    visitas++;
    localStorage.setItem("visitas", visitas);
    return visitas;
  }

  function mostrarPerfil() {
    const visitas = contarVisitas();
    document.getElementById("modalTitle").textContent = `Hola, ${usuario.nombre} (Visitas: ${visitas})`;

    const tablaPedidos = pedidos.map(p => `
      <tr>
        <td>${p.id}</td>
        <td>${p.Estado}</td>
        <td>${p.fecha}</td>
        <td><button class="btn btn-sm btn-info ver-detalle" data-id="${p.id}"><i class="fa fa-info-circle"></i></button></td>
      </tr>
    `).join("");

    document.getElementById("modalBody").innerHTML = `
      <p><strong>Teléfono:</strong> ${usuario.telefono}</p>
      ${usuario.direccion ? `<p><strong>Dirección:</strong> ${usuario.direccion}</p>` : ""}

      <div class="mb-3">
        <label class="form-label"><strong>Tu calificación:</strong></label>
        <div id="ratingStars" class="text-warning fs-4">
          ${[1,2,3,4,5].map(i => `<i class="fa ${i <= rating ? 'fa-star' : 'fa-star-o'}" style="cursor:pointer;" data-rating="${i}"></i>`).join("")}
        </div>
      </div>

      <h5>Últimos pedidos:</h5>
      <table class="table table-striped">
        <thead><tr><th>ID</th><th>Estado</th><th>Fecha</th><th>Ver</th></tr></thead>
        <tbody>${tablaPedidos}</tbody>
      </table>

      <div class="alert alert-info mt-3"><strong>Promoción:</strong> 20% de descuento en tu segundo pedido</div>
      <div class="alert alert-success">¡Envío gratis en pedidos mayores a $150!</div>
      <button class="btn btn-danger w-100" onclick="cerrarSesion()">Cerrar sesión</button>
    `;

    document.querySelectorAll(".ver-detalle").forEach(btn => {
      btn.addEventListener("click", () => {
        const id = parseInt(btn.dataset.id);
        const pedido = pedidos.find(p => p.id === id);
        if (pedido) mostrarDetallePedido(pedido);
      });
    });

    document.querySelectorAll("#ratingStars i").forEach(star => {
      star.addEventListener("click", () => {
        rating = parseInt(star.dataset.rating);
        actualizarEstrellas();
        alert(`Gracias por calificar con ${rating} estrellas`);
      });
    });
  }

  function actualizarEstrellas() {
    const stars = document.querySelectorAll("#ratingStars i");
    stars.forEach((star, idx) => {
      star.className = `fa ${idx < rating ? 'fa-star' : 'fa-star-o'}`;
    });
  }

  function cerrarSesion() {
    usuario = null;
    rating = 0;
    document.getElementById("modalTitle").textContent = "Bienvenido";

    // 👇 valida botón después de logout
    if (typeof validarCheckoutBtn === "function") validarCheckoutBtn();

    location.reload();
  }

  function mostrarDetallePedido(pedido) {
    let datos;
    try {
      datos = JSON.parse(pedido.Datos);
    } catch (e) {
      console.error("Error al parsear datos:", e);
      alert("Datos del pedido inválidos");
      return;
    }

    const productosHTML = datos.productos.map(prod => `
      <tr>
        <td>${prod.nombre}</td>
        <td>${prod.descripcion}</td>
        <td>$${prod.precio}</td>
        <td>${prod.cantidad}</td>
        <td>${prod.instrucciones || '-'}</td>
      </tr>
    `).join("");

    document.getElementById("detallePedidoBody").innerHTML = `
      <p><strong>Tipo de entrega:</strong> ${datos.tipo_entrega}</p>
      <p><strong>Observaciones:</strong> ${datos.observaciones || '-'}</p>
      <table class="table">
        <thead>
          <tr>
            <th>Nombre</th>
            <th>Descripción</th>
            <th>Precio</th>
            <th>Cantidad</th>
            <th>Instrucciones</th>
          </tr>
        </thead>
        <tbody>${productosHTML}</tbody>
      </table>
    `;

    new bootstrap.Modal(document.getElementById("detallePedidoModal")).show();
  }
</script>
