

<style>
.info-btn {
    position: fixed;
    right: 20px;
    z-index: 1055;
    border-radius: 50%;
    width: 56px;
    height: 56px;
    padding: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.75rem;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
  }

  .info-btn.cart-btn {
    bottom: 86px; /* Posición del botón del carrito arriba del de info */
    background-color: #28a745;
    color: white;
  }

  .info-btn.info {
    bottom: 20px;
    background-color: #0d6efd;
    color: white;
  }
  .modal-bottom-slide .modal-dialog {
    margin: 0;
    position: absolute;
    bottom: 0;
    width: 100%;
    transition: transform 0.3s ease-out;
    max-height: 80vh;
  }

  .modal.show .modal-dialog {
    transform: translateY(0%);
  }

  .modal.fade .modal-dialog {
    transform: translateY(100%);
  }

  .modal-content {
    border-radius: 1rem 1rem 0 0;
  }

  .map-container iframe {
    border-radius: 1rem 1rem 0 0;
    width: 100%;
    height: 250px;
    border: none;
  }

  .btn-bar {
    display: flex;
    justify-content: space-around;
    padding: 0.75rem 0;
    border-top: 1px solid #ddd;
    margin-top: 1rem;
    background: #f8f9fa;
    border-radius: 0 0 1rem 1rem;
  }

  .btn-bar a {
    flex-grow: 1;
    margin: 0 0.25rem;
    background: white;
    border-radius: 0.75rem;
    box-shadow: 0 2px 6px rgb(0 0 0 / 0.1);
    text-align: center;
    color: #0d6efd;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 0.75rem 0;
    display: flex;
    flex-direction: column;
    align-items: center;
    text-decoration: none;
    user-select: none;
    transition: background-color 0.2s ease;
  }

  .btn-bar a:hover,
  .btn-bar a:focus {
    background-color: #e2e6ea;
    color: #084298;
    text-decoration: none;
  }

  .btn-bar i {
    font-size: 2.25rem;
    margin-bottom: 0.3rem;
  }
</style>

<!-- Botón flotante: Carrito -->
<button class="btn info-btn cart-btn" title="Ver carrito"
        type="button"
        data-bs-toggle="offcanvas"
        data-bs-target="#cartOffcanvas"
        aria-controls="cartOffcanvas">
  <i class="fas fa-shopping-cart"></i>
</button>

<!-- Botón flotante: Información -->
<button class="btn info-btn info" title="Información del Restaurante" data-bs-toggle="modal" data-bs-target="#infoModal">
  <i class="fas fa-info-circle"></i>
</button>

<!-- Modal de Información -->
<div class="modal fade" id="infoModal" tabindex="-1" aria-hidden="true" aria-labelledby="infoModalLabel">
  <div class="modal-dialog modal-bottom-slide">
    <div class="modal-content shadow-lg">
      <div class="modal-header">
        <h5 class="modal-title" id="infoModalLabel">
          <i class="fas fa-store me-2"></i><?= htmlspecialchars($restaurante['nombre']) ?>
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body p-0">
        <div class="map-container">
          <iframe
            src="https://www.openstreetmap.org/export/embed.html?bbox=<?= $restaurante['longitud'] - 0.002 ?>%2C<?= $restaurante['latitud'] - 0.002 ?>%2C<?= $restaurante['longitud'] + 0.002 ?>%2C<?= $restaurante['latitud'] + 0.002 ?>&amp;layer=mapnik&amp;marker=<?= $restaurante['latitud'] ?>%2C<?= $restaurante['longitud'] ?>"
            allowfullscreen
            loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"
            style="border:0;">
          </iframe>
        </div>

        <div class="btn-bar" role="toolbar" aria-label="Accesos rápidos de contacto">
          <a href="tel:<?= htmlspecialchars($restaurante['telefono_llamar']) ?>" aria-label="Llamar al restaurante">
            <i class="fas fa-phone"></i>Llamar
          </a>
          <a href="https://wa.me/<?= preg_replace('/\D/', '', $restaurante['telefono_whatsapp']) ?>" target="_blank" aria-label="WhatsApp" rel="noopener noreferrer">
            <i class="fab fa-whatsapp" style="color: #25D366;"></i>WhatsApp
          </a>
          <a href="mailto:<?= htmlspecialchars($restaurante['email']) ?>" aria-label="Correo electrónico">
            <i class="fas fa-envelope"></i>Correo
          </a>
          <a href="https://www.openstreetmap.org/?mlat=<?= $restaurante['latitud'] ?>&mlon=<?= $restaurante['longitud'] ?>" target="_blank" aria-label="Ubicación en mapa" rel="noopener noreferrer">
            <i class="fas fa-map-marker-alt"></i>Ubicación
          </a>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Carrito (ejemplo simple) -->
<div class="modal fade" id="carritoModal" tabindex="-1" aria-hidden="true" aria-labelledby="carritoModalLabel">
  <div class="modal-dialog modal-bottom-slide">
    <div class="modal-content shadow-lg">
      <div class="modal-header">
        <h5 class="modal-title" id="carritoModalLabel">
          <i class="fas fa-shopping-cart me-2"></i>Mi carrito
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <p class="text-muted">Tu carrito está vacío.</p>
        <!-- Aquí puedes cargar productos con JavaScript -->
      </div>
    </div>
  </div>
</div>
