<div class="container my-4">
  <!-- Barra de categorías con íconos deslizable -->
  <div id="categoriaBarra" class="categoria-slider d-flex gap-3 flex-nowrap py-2">
    <!-- Botón "Todas" está fijo -->
    <button class="categoria-btn btn btn-link text-decoration-none text-center fw-bold flex-shrink-0" data-categoria="todas" style="width: 80px;">
      <i class="fa fa-th-large fa-2x mb-1"></i><br>
      <small>Todas</small>
    </button>
    <!-- Aquí se insertarán las categorías AJAX -->
  </div>
</div>

<style>
  /* Contenedor deslizable con scroll horizontal */
  .categoria-slider {
    overflow-x: auto;
    scrollbar-width: thin; /* Firefox */
    scrollbar-color: #888 transparent;
  }
  .categoria-slider::-webkit-scrollbar {
    height: 6px;
  }
  .categoria-slider::-webkit-scrollbar-thumb {
    background-color: #888;
    border-radius: 3px;
  }
  .categoria-slider::-webkit-scrollbar-track {
    background: transparent;
  }
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
  $(function() {
    const $categoriaBarra = $('#categoriaBarra');

    // Función para cargar categorías vía AJAX
    function cargarCategorias() {
      $.ajax({
        type: 'POST',
        url: 'app/ajax.php',
        data: { metodo: 'Categorias' },
        dataType: 'json',
        success: function(res) {
			console.log(res);
          if (res.status === 'success' && Array.isArray(res.data)) {
            // Limpiar categorías menos "Todas"
            $categoriaBarra.find('.categoria-btn').not('[data-categoria="todas"]').remove();

            res.data.forEach(cat => {
              let icono = 'fa fa-tags'; // ícono genérico
              let color = '#6c757d';    // color gris genérico (Bootstrap text-secondary)

              if (cat.Visible) {
                try {
                  const visibleData = JSON.parse(cat.Visible);
                  if (visibleData.icono) icono = visibleData.icono;
                  if (visibleData.color) color = visibleData.color;
                } catch (e) {
                  console.warn('No se pudo parsear Visible de:', cat.Categoria);
                }
              }

              const btn = $(`
                <button class="categoria-btn btn btn-link text-decoration-none text-center text-muted flex-shrink-0" data-categoria="${cat.Categoria}" style="width: 80px;">
                  <i class="${icono} fa-2x mb-1" style="color: ${color};"></i><br>
                  <small>${cat.Categoria}</small>
                </button>
              `);
              $categoriaBarra.append(btn);
            });

            inicializarEventosCategoria();
          } else {
            alert('No se encontraron categorías.');
          }
        },
        error: function() {
		 location.reload();
			console.log("error al cargar categorias actializando...");
        }
      });
    }

    // Asigna los eventos click a los botones de categoría
    function inicializarEventosCategoria() {
      const $botones = $('.categoria-btn');
      $botones.off('click').on('click', function() {
        const categoria = $(this).data('categoria');

        // Actualiza estilos ANTES de disparar evento
        $botones.removeClass('fw-bold').addClass('text-muted');
        $(this).addClass('fw-bold').removeClass('text-muted');

        // Evento personalizado para filtrar productos
        $(document).trigger('categoriaSeleccionada', categoria);
      });
    }

    // Inicializamos llamando AJAX
    cargarCategorias();
  });
</script>
