<!-- Carrito Offcanvas -->
<meta charset="UTF-8" />
<div class="offcanvas offcanvas-end" tabindex="-1" id="cartOffcanvas" aria-labelledby="cartOffcanvasLabel">
  <div class="offcanvas-header">
    <h5 class="offcanvas-title" id="cartOffcanvasLabel">Tu Carrito</h5>
    <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body">
    <div id="cartItems">
      <p class="text-muted">Tu carrito está vacío.</p>
    </div>

    <div id="cartTotal" class="mt-3 fw-bold fs-5"></div>

    <!-- Método de entrega -->
    <div class="mt-4">
      <h6>Metodo de entrega:</h6>
      <div class="d-flex gap-3 mt-2">
        <button id="btnRecoger" type="button" class="btn btn-outline-primary flex-fill d-flex flex-column align-items-center p-3 selected" onclick="selectMetodoEntrega('Recoger en Tienda')">
          <i class="fa fa-home fa-2x mb-2"></i> Recoger en Tienda
        </button>
        <button id="btnEnvio" type="button" class="btn btn-outline-primary flex-fill d-flex flex-column align-items-center p-3" onclick="selectMetodoEntrega('Envío a Domicilio')">
          <i class="fa fa-shopping-bag fa-2x mb-2"></i> Envío a Domicilio
        </button>
      </div>
    </div>

    <!-- Observaciones Generales -->
    <div class="mt-4">
      <h6>Observaciones generales:</h6>
      <textarea id="observacionesInput" class="form-control" rows="3" placeholder="Ej: Entregar en portería, llamar antes..."></textarea>
    </div>

    <!-- Botón de compra -->
    <button id="checkoutBtn" class="btn btn-success w-100 mt-3" onclick="checkout()" disabled>Comprar</button>
    <div id="checkoutMsg" class="text-danger small mt-2 text-center"></div>
  </div>
</div>

<script>
  const cart = [];
  let metodoEntregaSeleccionado = 'Recoger en Tienda';
  let observacionesGenerales = '';

  function updateCartCount() {
    const count = cart.reduce((sum, item) => sum + item.cantidad, 0);
    const cartCountElem = document.getElementById('cartCount');
    if (cartCountElem) {
      cartCountElem.textContent = count;
      cartCountElem.style.display = count > 0 ? 'inline-block' : 'none';
    }
    validarCheckoutBtn(); // 👈 actualizar botón también aquí
  }

  function renderCart() {
    const container = document.getElementById('cartItems');
    if (!container) return;

    if (cart.length === 0) {
      container.innerHTML = '<p class="text-muted">Tu carrito está vacío.</p>';
      document.getElementById('cartTotal').textContent = '';
      validarCheckoutBtn();
      return;
    }

    let html = '<ul class="list-group">';
    let total = 0;

    cart.forEach((item, index) => {
      const subtotal = item.precioNum * item.cantidad;
      total += subtotal;

      html += `
        <li class="list-group-item">
          <div class="d-flex justify-content-between align-items-start">
            <div class="flex-grow-1 me-3">
              <strong>${item.id} - ${item.nombre}</strong><br>
              <small>${item.descripcion}</small><br>
              <div class="d-flex align-items-center mt-2">
                <button class="btn btn-outline-secondary btn-sm rounded-circle me-2" onclick="decreaseQuantity(${index})" ${item.cantidad <= 1 ? 'disabled' : ''}>-</button>
                <span>${item.cantidad}</span>
                <button class="btn btn-outline-secondary btn-sm rounded-circle ms-2" onclick="increaseQuantity(${index})">+</button>
              </div>
              <div class="mt-1">Precio unitario: $${item.precioNum.toFixed(2)}</div>
              <span class="fw-bold">Subtotal: $${subtotal.toFixed(2)}</span>
            </div>
            <div>
              <button class="btn btn-sm btn-danger" onclick="removeFromCart(${index})">&times;</button>
            </div>
          </div>
          <div class="mt-2">
            <textarea class="form-control form-control-sm" rows="2" placeholder="Instrucciones para este producto..." oninput="updateInstrucciones(${index}, this.value)">${item.instrucciones || ''}</textarea>
          </div>
        </li>
      `;
    });

    html += '</ul>';
    container.innerHTML = html;

    document.getElementById('cartTotal').textContent = `Total: $${total.toFixed(2)}`;
    validarCheckoutBtn();
  }

  function updateInstrucciones(index, value) {
    cart[index].instrucciones = value;
  }

  function addToCart(product) {
    const precioNum = parseFloat(product.precio.replace(/[^0-9.-]+/g, "")) || 0;
    let existing = cart.find(item => item.id === product.id);
    if (existing) {
      existing.cantidad++;
    } else {
      cart.push({ ...product, cantidad: 1, precioNum, instrucciones: '', id: product.id });
    }
    updateCartCount();
    renderCart();
  }

  function removeFromCart(index) {
    cart.splice(index, 1);
    updateCartCount();
    renderCart();
  }

  function increaseQuantity(index) {
    cart[index].cantidad++;
    renderCart();
    updateCartCount();
  }

  function decreaseQuantity(index) {
    if (cart[index].cantidad > 1) {
      cart[index].cantidad--;
      renderCart();
      updateCartCount();
    }
  }

  function selectMetodoEntrega(metodo) {
    metodoEntregaSeleccionado = metodo;
    const btnRecoger = document.getElementById('btnRecoger');
    const btnEnvio = document.getElementById('btnEnvio');
    if (metodo === 'Recoger en Tienda') {
      btnRecoger.classList.add('selected', 'btn-primary');
      btnRecoger.classList.remove('btn-outline-primary');
      btnEnvio.classList.remove('selected', 'btn-primary');
      btnEnvio.classList.add('btn-outline-primary');
    } else {
      btnEnvio.classList.add('selected', 'btn-primary');
      btnEnvio.classList.remove('btn-outline-primary');
      btnRecoger.classList.remove('selected', 'btn-primary');
      btnRecoger.classList.add('btn-outline-primary');
    }
  }

  // ✅ Nueva validación del botón
  function validarCheckoutBtn() {
    const btn = document.getElementById('checkoutBtn');
    const msg = document.getElementById('checkoutMsg');
    if (!btn || !msg) return;

    if (!usuario && cart.length === 0) {
      btn.disabled = true;
      msg.textContent = "Debes iniciar sesión y agregar productos al carrito.";
    } else if (!usuario) {
      btn.disabled = true;
      msg.textContent = "Debes iniciar sesión para comprar.";
    } else if (cart.length === 0) {
      btn.disabled = true;
      msg.textContent = "Tu carrito está vacío.";
    } else {
      btn.disabled = false;
      msg.textContent = "";
    }
  }

  // ✅ Checkout validado
  function checkout() {
    if (!usuario) {
      alert("Debes iniciar sesión para continuar con la compra.");
      new bootstrap.Modal(document.getElementById("authModal")).show();
      return;
    }

    if (cart.length === 0) {
      alert("Tu carrito está vacío. Agrega productos antes de comprar.");
      return;
    }

    observacionesGenerales = document.getElementById('observacionesInput').value;

    const pedido = {
      cliente: {
        idc: usuario?.idc || "",
        nombre: usuario?.nombre || "",
        telefono: usuario?.telefono || "",
        direccion: usuario?.direccion || ""
      },
      productos: cart.map(item => ({
        id: item.id,
        nombre: item.nombre,
        descripcion: item.descripcion,
        cantidad: item.cantidad,
        precio: item.precioNum,
        instrucciones: item.instrucciones || ""
      })),
      tipo_entrega: metodoEntregaSeleccionado,
      observaciones: observacionesGenerales
    };

    console.log("✅ Pedido generado:");
    console.log(JSON.stringify(pedido, null, 2));
    guardarPedido(JSON.stringify(pedido, null, 2));

    alert("Gracias por tu compra!");
    cart.length = 0;
    updateCartCount();
    renderCart();
    document.getElementById('observacionesInput').value = '';

    const offcanvas = bootstrap.Offcanvas.getInstance(document.getElementById('cartOffcanvas'));
    if (offcanvas) offcanvas.hide();
  }

  function guardarPedido(datos) {
    console.log("Guardando...");
    $.ajax({
      type: 'POST',
      url: 'app/ajax.php',
      data: { metodo: 'Pedido', datos: datos },
      success: function(res) {
        if (typeof res === 'string') {
          try {
            res = JSON.parse(res);
          } catch (e) {
            console.error('❌ No se pudo parsear la respuesta:', res);
            return;
          }
        }

        if (res.status === 'success') {
          console.log('✅ Pedido guardado correctamente.');
        } else {
          console.warn('⚠️ Error al guardar el pedido:', res.message || res);
        }
      },
      error: function(err) {
        console.error('❌ Error AJAX al guardar el pedido:', err);
        alert('Ocurrió un error al guardar el pedido. Intenta nuevamente.');
      }
    });
  }

  // Inicialización
  updateCartCount();
  renderCart();
  selectMetodoEntrega(metodoEntregaSeleccionado);
  validarCheckoutBtn();
</script>

<style>
  .selected {
    color: white !important;
  }
</style>
