<style>
    .modal-header {
        border-bottom: none;
        position: relative;
    }
    .modal-header::before {
        content: '';
        position: absolute;
        width: 100%;
        height: 4px;
        background: linear-gradient(to right, #ff416c, #ff4b2b);
        top: 0;
        left: 0;
    }
    .modal-content {
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.2);
    }
    .modal-body {
        padding: 2rem;
    }
    .modal-footer {
        border-top: none;
    }
    .btn-custom {
        background: #ff4b2b;
        background: linear-gradient(to right, #ff416c, #ff4b2b);
        color: white;
        border: none;
        border-radius: 50px;
        padding: 0.75rem 1.5rem;
        transition: background 0.3s ease-in-out;
    }
    .btn-custom:hover {
        background: #ff4b2b;
    }
    .form-control {
        border-radius: 50px;
        padding: 1rem;
    }
    .form-control:focus {
        box-shadow: none;
        border-color: #ff4b2b;
    }
	
</style>

<!-- The Modal -->
<div class="modal fade" id="loginModal">
  <div class="modal-dialog">
    <div class="modal-content">
      <!-- Modal Header -->
      <div class="modal-header">
        <h5 class="modal-title">Inicio de Sesión</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <!-- Modal Body -->
      <div class="modal-body">
        <form id="loginForm">
          <div class="form-group">
            <label for="phone">Teléfono:</label>
            <input type="text" class="form-control" name="phone" id="phoneLo" placeholder="Ingresa tu número de teléfono">
          </div>
          <button type="submit" class="btn btn-custom btn-block" onClick="logClient(event)">Iniciar Sesión</button>
        </form>
      </div>
      <!-- Modal Footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<script>
	console.log("->");
  function logClient(event) {
    event.preventDefault();
    const phoneInput = $('#phoneLo').val();
	  

    // Validación básica (asegurándonos de validar solo el campo de teléfono)
    if (!phoneInput) {
        alert('Por favor, ingrese su número de teléfono.');
        return;
    }

    // Serializa el formulario
    let formData = $('#loginForm').serialize();
    const metodo = 'loginT';
    formData += `&metodo=${metodo}`;

// Enviar la solicitud AJAX
$.ajax({
    type: 'POST',
    url: 'app/ajax.php', // Reemplaza con la URL de tu servidor
    data: formData,
    success: function(response) {
        console.log(response);
        const res = JSON.parse(response);
        if (res.status === 'success') {
           

            // Procesa los datos recibidos si es necesario
            const datos = res.data;
            console.log(datos);

            if (datos && datos.length > 0) {
                // Si hay datos en el arreglo
                const cliente = datos[0]; // Asumiendo que siempre hay al menos un cliente
				idc=cliente.IDC;
                // Actualiza el banner con los datos del cliente en el modal de pedido
                const clientBannerOrder = $('#clientBannerOrder');
                clientBannerOrder.html(`
                    <strong>Cliente:</strong> ${cliente.Nombre}<br>
                    <strong>Teléfono:</strong> ${cliente.Telefono}<br>
                    <strong>Dirección:</strong> ${cliente.Direccion}
                `);
                clientBannerOrder.show(); // Muestra el banner en el modal de pedido

                // Actualiza también el banner inicial de identificación si lo deseas
                const clientBanner = $('#clientBanner');
                clientBanner.html(`
                    <strong> ${cliente.Nombre}</strong><br>
                    <span>Teléfono: ${cliente.Telefono}</span><br>
                    <span>Dirección: ${cliente.Direccion}</span>
                `);
                clientBanner.show(); // Muestra el banner inicial

                // Cierra el modal de inicio de sesión
                $('#loginModal').modal('hide');
                $('#loginLabel').hide();
                $('#submitOrderButton').prop('disabled', false);
            } else {
                // Manejo del caso cuando el arreglo está vacío
                alert('No se encontraron datos para el cliente.');
            }
        } else {
            alert(res.message);
        }
    },
    error: function(error) {
        // Manejar errores
        alert('Error al registrar el cliente. Por favor, inténtelo de nuevo.');
    }
});

  }
</script>
