<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tarjeta de Presentación Digital</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background-color: #f4f4f4;
        }

        .card {
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.5);
            max-width: 350px;
            text-align: center;
            padding: 20px;
            color: #ffffff;
            background-color: #ffffff; /* Color de fondo de la tarjeta */
        }

        .profile-img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            margin-top: -50px;
            border: 3px solid #ffffff;
        }

        .title {
            font-size: 18px;
            color: grey;
        }

        .contact p {
            margin: 10px 0;
            font-size: 14px;
            color: #ffffff;
        }

        .social-media {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-around;
            margin-top: 20px;
        }

        .social-media a {
            text-decoration: none;
            margin: 10px;
            font-size: 32px; /* Tamaño de ícono aumentado */
            color: inherit;
        }

        .social-media a:hover {
            color: #007bb5; /* Color de hover para iconos sociales */
        }

        .fa {
            margin-right: 5px;
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
            justify-content: center;
            align-items: center;
        }

        .modal-content {
            margin: auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-width: 600px;
            text-align: center;
            background-color: #ffffff; /* Color de fondo del modal */
            color: #000000;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: #ffffff;
            text-decoration: none;
            cursor: pointer;
        }

        .qr-img {
            width: 100%;
            height: auto;
        }

        .qr-container {
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #ffffff; /* Fondo blanco para el QR */
            padding: 10px;
            margin: 0 auto;
            width: fit-content;
        }

        #map-container {
            width: 100%;
            height: 400px;
            margin-top: 20px;
            background-color: #ffffff;
        }

        .map-buttons {
            text-align: center;
            margin-top: 10px;
        }

        .map-buttons button {
            background-color: #007bb5;
            color: #ffffff;
            border: none;
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
            border-radius: 5px;
        }

        .map-buttons button:hover {
            background-color: #005f8d;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/leaflet@1.7.1/dist/leaflet.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet@1.7.1/dist/leaflet.css" />
</head>
<body>
    <div class="card" id="profile-card">
        <img src="https://via.placeholder.com/100" alt="Profile Image" class="profile-img">
        <h1 id="name"></h1>
        <p class="title" id="title"></p>
        <p id="company"></p>
        <div class="contact">
            <p id="phone-container"><i class="fa fa-phone"></i> <span id="phone"></span></p>
            <p id="email-container"><i class="fa fa-envelope"></i> <span id="email"></span></p>
			<p id="direccion-container"><i class="fa fa-map-marker"></i> <span id="direccion"></span></p>
            <p id="whatsapp-container"><i class="fa fa-whatsapp"></i> <span id="whatsapp"></span></p>
        </div>
        <div class="social-media">
            <a id="catalog" href="#" target="_blank"><i class="fa fa-list"></i></a>
		
<a id="bank" href="javascript:void(0);" target="_blank"><i class="fa fa-university"></i></a>

            <a id="instagram" href="#" target="_blank"><i class="fa fa-instagram"></i></a>
            <a id="twitter" href="#" target="_blank"><i class="fa fa-twitter"></i></a>
            <a id="facebook" href="#" target="_blank"><i class="fa fa-facebook"></i></a>
            <a id="whatsapp-link" href="#" target="_blank"><i class="fa fa-whatsapp"></i></a>
            <a id="phone-link" href="#"><i class="fa fa-phone"></i></a>
            
            <a id="app-icon" href="#"><i class="fa fa-mobile"></i></a>
            <a id="delivery-icon" href="#"><i class="fa fa-truck"></i></a>
            <a href="#" id="gps-button"><i class="fa fa-map-marker"></i></a>
			<a href="#" class="qr-code" id="qr-button"><i class="fa fa-qrcode"></i></a>
        </div>
    </div>

    <!-- QR Code Modal -->
    <div id="qrModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Compartir Tarjeta</h2>
            <div id="qrcode" class="qr-container"></div>
        </div>
    </div>

    <!-- GPS Modal -->
    <div id="gpsModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Ubicación en MapStreetView</h2>
            <div id="map-container"></div>
            <div class="map-buttons">
                <button id="open-google-maps">Ir a Google Maps</button>
            </div>
        </div>
    </div>
	
	    <!-- Banco Modal -->
    <div id="bankModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>Datos Bancarios</h2>
            <p id="bank-name"></p>
            <p id="bank-account"></p>
            <p id="bank-clabe"></p>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var colors = {
                "background": "#1c1c1c",
                "text": "#ffffff",
                "title": "grey",
                "contact": "#ffffff",
                "socialMedia": "#ffffff",
                "socialMediaHover": "#007bb5",
                "qrBackground": "#ffffff",
                "qrForeground": "#000000",
                "cardBackground": "#ffffff"
            };

   var data = {
    "name": "Juan Pérez",
    "title": "Desarrollador Web",
    "company": "Compañía XYZ",
    "phone": "+1 234 567 890",
    "email": "juan.perez@xyz.com",
    "whatsapp": "+1 234 567 890",
    "catalog": "https://example.com/catalog",
    "instagram": "https://instagram.com",
    "twitter": "https://twitter.com",
    "facebook": "https://facebook.com",
    "whatsappLink": "https://wa.me/1234567890",
    "phoneLink": "tel:+1234567890",
    "gps": "12.345678, -98.765432",
    "deliveryMethod": "Recoger en tienda",
    "appName": "Mi Aplicación",
    "direccion": "123 Calle Falsa, Ciudad, País",
    // Datos bancarios agrupados en una variable
    "banco": {
        "nombre": "Banco XYZ",
        "cuenta": "1234567890",
        "clabe": "012345678901234567"
    }
};

            colors = <?php echo json_encode($datosC[0]["Pagina_Colores"], JSON_PRETTY_PRINT); ?>;
            colors = JSON.parse(colors);
            profile = <?php echo json_encode($datosC[0]["Pagina_Datos"], JSON_PRETTY_PRINT); ?>;
            profile = JSON.parse(profile);

            // Aplicar colores
            document.body.style.backgroundColor = colors.background;
            var card = document.querySelector('.card');
            card.style.backgroundColor = colors.cardBackground;

            card.style.color = colors.text;
            var title = document.querySelector('.title');
            title.style.color = colors.title;
            var contact = document.querySelectorAll('.contact p');
            contact.forEach(function(el) {
                el.style.color = colors.contact;
            });
            var socialMediaLinks = document.querySelectorAll('.social-media a');
            socialMediaLinks.forEach(function(el) {
                el.style.color = colors.socialMedia;
            });
            socialMediaLinks.forEach(function(el) {
                el.addEventListener('mouseover', function() {
                    el.style.color = colors.socialMediaHover;
                });
                el.addEventListener('mouseout', function() {
                    el.style.color = colors.socialMedia;
                });
            });
            var qrCode = document.querySelector('.qr-container');
            qrCode.style.backgroundColor = colors.qrBackground;

            // Rellenar datos del perfil
            document.getElementById('name').innerText = profile.name;
            document.getElementById('title').innerText = profile.title;
            document.getElementById('company').innerText = profile.company;
            document.getElementById('phone').innerText = profile.phone;
            document.getElementById('email').innerText = profile.email;
            document.getElementById('whatsapp').innerText = profile.whatsapp;
			document.getElementById('direccion').innerText  = profile.direccion;
			     // Mostrar datos bancarios
            

            // Función para ocultar icono si el enlace está vacío
            function toggleIconVisibility(elementId, url) {
                var element = document.getElementById(elementId);
                if (!url) {
                    element.style.display = "none";
                } else {
                    element.href = url;
                }
            }

            toggleIconVisibility('catalog', profile.catalog);
            toggleIconVisibility('instagram', profile.instagram);
            toggleIconVisibility('twitter', profile.twitter);
            toggleIconVisibility('facebook', profile.facebook);
            toggleIconVisibility('whatsapp-link', profile.whatsappLink);
            toggleIconVisibility('phone-link', profile.phoneLink);
            toggleIconVisibility('app-icon', profile.appName ? "#" : "");
            toggleIconVisibility('delivery-icon', profile.deliveryMethod ? "#" : "");
            toggleIconVisibility('gps-button', profile.gps ? "#" : "");
			
			
			   // Mostrar modal de banco
            var bankButton = document.getElementById("bank");
			var bankModal = document.getElementById("bankModal");
			if (bankButton && bankModal) {
				var bankClose = bankModal.querySelector(".close");
				bankButton.onclick = function(event) {
					event.preventDefault(); // Prevenir que se abra un enlace en una nueva ventana
					document.getElementById("bank-name").innerText = "Nombre del Banco: " + profile.banco.nombre;
					document.getElementById("bank-account").innerText = "Cuenta: " + profile.banco.cuenta;
					document.getElementById("bank-clabe").innerText = "CLABE: " + profile.banco.clabe;
					bankModal.style.display = "block";
				};
				bankClose.onclick = function() {
					bankModal.style.display = "none";
				};
			}

			
            // QR Code generation
            var qrButton = document.getElementById("qr-button");
            var qrModal = document.getElementById("qrModal");
            var qrClose = document.getElementsByClassName("close")[0];
            qrButton.onclick = function() {
                qrModal.style.display = "block";
                var qrCode = new QRCode(document.getElementById("qrcode"), {
                    text: window.location.href,
                    width: 128,
                    height: 128,
                    colorDark : colors.qrForeground,
                    colorLight : colors.qrBackground
                });
            };
            qrClose.onclick = function() {
                qrModal.style.display = "none";
                document.getElementById("qrcode").innerHTML = ""; // Clear QR code
            };
            window.onclick = function(event) {
                if (event.target == qrModal) {
                    qrModal.style.display = "none";
                    document.getElementById("qrcode").innerHTML = ""; // Clear QR code
                }
            };

            // GPS Modal
            var gpsButton = document.getElementById("gps-button");
            var gpsModal = document.getElementById("gpsModal");
            var gpsClose = document.getElementsByClassName("close")[1];
            gpsButton.onclick = function() {
                gpsModal.style.display = "block";
                var mapContainer = document.getElementById("map-container");
                var map = L.map(mapContainer).setView([profile.gps.split(',')[0], profile.gps.split(',')[1]], 17);

                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
                }).addTo(map);

                L.marker([profile.gps.split(',')[0], profile.gps.split(',')[1]]).addTo(map)
                    .bindPopup('Ubicación')
                    .openPopup();
                
                // Agregar botón para abrir Google Maps 
                var openGoogleMapsButton = document.getElementById("open-google-maps");
                openGoogleMapsButton.onclick = function() {
                    var googleMapsUrl = "https://www.google.com/maps?q=" + profile.gps;
                    window.open(googleMapsUrl, '_blank');
                };
            };
            gpsClose.onclick = function() {
                gpsModal.style.display = "none";
                document.getElementById("map-container").innerHTML = ""; // Clear Map
            };
            window.onclick = function(event) {
                if (event.target == gpsModal) {
                    gpsModal.style.display = "none";
                    document.getElementById("map-container").innerHTML = ""; // Clear Map
                }
            };
        });
    </script>
</body>
</html>
