<!DOCTYPE HTML>
<html>
<head>
    <title>MicroSi - PaginaWEB</title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />
    <link rel="stylesheet" href="assets/css/main.css" />
    <noscript><link rel="stylesheet" href="assets/css/noscript.css" /></noscript>
    <style>
        /* Estilo CSS para redimensionar imágenes de la galería */
        .gallery .inner art: ;icle {
            width: 300px; /* Ancho deseado */
            height: 200px; /* Alto deseado */
            overflow: hidden;
        }
        .inner article img {
            width: 100%;
            height: auto;
        }
        #map {
             width: auto;
            height: 100%;
			overflow: hidden;/* Altura deseada para el mapa */
        }
    </style>
</head>
<body>

<!-- Contenedor principal -->
<div id="wrapper" class="divided">
</div>

<!-- Footer -->
<footer class="wrapper style1 align-center">
    <div class="inner">
        <ul class="icons">
            <li><a href="https://twitter.com/<?php echo $twi;?>" class="icon brands style2 fa-twitter"><span class="label">Twitter</span></a></li>
            <li><a href="https://www.facebook.com/<?php echo $fac;?>" class="icon brands style2 fa-facebook-f"><span class="label">Facebook</span></a></li>
            <li><a href="https://wa.me/<?php echo $wat;?>" class="icon brands style2 fa-whatsapp"><span class="label">WhatsApp</span></a></li>
            <li><a href="mailto:<?php echo $cor;?>" class="icon style2 fa-envelope"><span class="label">Email</span></a></li>
            <li><a href="tel:+<?php echo $tel;?>" class="icon style2 fa-fan"><span class="label">Teléfono</span></a></li>
        </ul>
        <p>&copy; Design: <a href="https://techsicom.tk">Techsicom</a>.</p>
    </div>
</footer>

<!-- Scripts -->
<script src="assets/js/jquery.min.js"></script>
<script src="assets/js/jquery.scrollex.min.js"></script>
<script src="assets/js/jquery.scrolly.min.js"></script>
<script src="assets/js/browser.min.js"></script>
<script src="assets/js/breakpoints.min.js"></script>
<script src="assets/js/util.js"></script>
<script src="assets/js/main.js"></script>

	<!-- OpenStreetMap Script -->
<script src="https://cdn.jsdelivr.net/npm/leaflet@1.7.1/dist/leaflet.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet@1.7.1/dist/leaflet.css" />

	
<script>
$(document).ready(function(){
    var datosP = <?php echo json_encode($datosP[0]["Pagina_Datos"], JSON_PRETTY_PRINT); ?>;
    var datas = JSON.parse(datosP); // Parsear los datos obtenidos de PHP, si es necesario

    var sections = datas.sections; // Obtener las secciones del JSON
    console.log(sections);

    var wrapper = $('#wrapper');

    // Función para agregar el contenido dinámico al wrapper
    function agregarContenido() {
        sections.forEach(function(section){
            var html = '';
            switch(section.type){
                case 'banner':
                    html = '<section class="banner style1 orient-left content-align-left image-position-right fullscreen">';
                    html += '<div class="content">';
                    html += '<h1>' + section.title + '</h1>';
                    html += '<p class="major">' + section.subtitle + '</p>';
                    html += '<ul class="actions stacked">';
                    html += '<li><a href="#first" class="button big wide">' + section.buttonText + '</a></li>';
                    html += '</ul>';
                    html += '</div>';
                    html += '<div class="image">';
                    html += '<img src="' + section.image + '" alt="" />';
                    html += '</div>';
                    html += '</section>';
                    break;
                case 'spotlight':
                    var orientClass = section.orient && section.orient === 'right' ? 'orient-right' : 'orient-left';
                    html = '<section class="spotlight style1 ' + orientClass + ' content-align-left image-position-center">';
                    html += '<div class="content">';
                    html += '<h2>' + section.title + '</h2>';
                    html += '<p>' + section.content + '</p>';
                    html += '<ul class="actions stacked">';
                    html += '<li><a href="#" class="button">' + section.buttonText + '</a></li>';
                    html += '</ul>';
                    html += '</div>';
                    html += '<div class="image">';
                    html += '<img src="' + section.image + '" alt="" />';
                    html += '</div>';
                    html += '</section>';
                    break;
                case 'gallery':
                    html = '<section class="wrapper style1 align-center">';
                    html += '<div class="inner">';
                    html += '<h2>' + section.title + '</h2>';
                    html += '<p>' + section.content + '</p>';
                    html += '<div class="gallery style2 medium lightbox onscroll-fade-in" style="overflow-x: auto;">';
                    section.images.forEach(function(image){
                        html += '<article>';
                        html += '<a href="' + image.full + '" class="image">';
                        html += '<img src="' + image.thumb + '" alt="' + image.caption + '" />';
                        html += '</a>';
                        html += '<div class="caption">';
                        html += '<h3>' + image.caption + '</h3>';
                        html += '</div>';
                        html += '</article>';
                    });
                    html += '</div>';
                    html += '</div>';
                    html += '</section>';
                    break;
			case 'items':
                html = '<section class="wrapper style1 align-center">';
                html += '<div class="inner">';
                html += '<h2>' + section.title + '</h2>';
                html += '<p>' + section.content + '</p>';
                html += '<div class="items style1 medium">';
                section.items.forEach(function(item){
                    html += '<section>';
                    html += '<span class="icon style2 major ' + item.icon + '"></span>';
                    html += '<h3>' + item.title + '</h3>';
                    html += '<p>' + item.content + '</p>';
                    html += '</section>';
                });
                html += '</div>';
                html += '</div>';
                html += '</section>';
                break;
				case 'map':
                    var orientClass = section.orient && section.orient === 'right' ? 'orient-right' : 'orient-left';
                    html = '<section class="spotlight style1 ' + orientClass + ' content-align-left image-position-right">';
                    html += '<div class="content">';
                    html += '<h2>' + section.title + '</h2>';
                    html += '<p>' + section.text + '</p>';
                    html += '<ul class="actions stacked">';
                    html += '<li><a href="https://www.google.com/maps?q=' + section.latitude + ',' + section.longitude + '" target="_blank" class="button">' + section.buttonText + '</a></li>';
                    html += '</ul>';
                    html += '</div>';
                    html += '<div class="image">';
                    html += '<div id="map" class="map-container"></div>'; // Contenedor del mapa
                    html += '</div>';
                    html += '</section>';
                    break;

                case 'contact':
    html = '<section class="wrapper style1 align-center">';
    html += '<div class="inner medium">';
    html += '<h2>' + section.title + '</h2>';
    html += '<form method="post" action="#" onsubmit="handleContactFormSubmission(event)">';
    html += '<div class="fields">';
    html += '<div class="field half">';
    html += '<label for="name">Nombre</label>';
    html += '<input type="text" name="name" id="name" value="" />';
    html += '</div>';
    html += '<div class="field half">';
    html += '<label for="email">Tu Correo</label>';
    html += '<input type="email" name="email" id="email" value="" />';
    html += '</div>';
    html += '<div class="field">';
    html += '<label for="message">Mensaje</label>';
    html += '<textarea name="message" id="message" rows="6"></textarea>';
    html += '</div>';
    html += '</div>';
    html += '<ul class="actions special">';
    html += '<li><input type="submit" name="submit" id="submit" value="Enviar Mensaje" /></li>';
    html += '</ul>';
    html += '</form>';
    html += '</div>';
    html += '</section>';
    break;

                default:
                    break;
            }

            wrapper.append(html);
        });
    }

    // Llamar a la función para agregar el contenido una vez que el DOM esté listo
    agregarContenido();

    // Inicialización de plugins de scroll después de agregar el contenido
    $('.spotlight').scrollex({
        mode: 'middle',
        top: '-10vh',
        bottom: '-10vh',
        initialize: function() { $(this).addClass('is-inactive'); },
        terminate: function() { $(this).removeClass('is-inactive'); },
        enter: function() { $(this).removeClass('is-inactive'); },
        leave: function() { $(this).addClass('is-inactive'); }
    });

    // Función para cargar el mapa de OpenStreetMap
    function loadMap() {
        var lat = sections.find(section => section.type === 'map').latitude;
        var lon = sections.find(section => section.type === 'map').longitude;

        var map = L.map('map').setView([lat, lon], 15);

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 40,
        }).addTo(map);

        L.marker([lat, lon]).addTo(map)
            .bindPopup('<?php echo $datosP[0]["Titulo"];?>')
            .openPopup();
    }

    // Llamar a la función para cargar el mapa cuando el DOM esté listo
    $(document).ready(function() {
        loadMap();
    });

});
	
function handleContactFormSubmission(event) {
    event.preventDefault(); // Evita el envío del formulario por defecto

    const name = document.getElementById('name').value;
    const email = document.getElementById('email').value;
    const message = document.getElementById('message').value;

    console.log('Name:', name);
    console.log('Email:', email);
    console.log('Message:', message);
	
	   const formData = {
        name: name,
        email: email,
        message: message
    };
	   const serializedData = JSON.stringify(formData);
    console.log('Serialized Data:', serializedData);
	
  // Datos a enviar al servidor
    var formData = {
        datos:  jsonFinal
    };

    // AJAX para enviar los datos al servidor 
    $.ajax({
        url: '<?php echo $urlajaxUpdate; ?>', // Reemplaza con la ruta correcta a tu script del servidor
        type: 'POST',
        data: formData,
        success: function(response) {
            // Maneja la respuesta del servidor
			$("#Mensaje").html(' <div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
			setTimeout(function() {$('#Mensaje').empty();}, 2000);
			//setTimeout(function() {location.reload();}, 1000);
            console.log(response);
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });


    // Aquí
}	
	
</script>

</body>
</html>
