<?php
// Arreglo de datos
$dataArray = [
    [
        "IDP" => 1,
        "IDe" => 1,
        "Titulo" => "Historial Clinico",
        "Bloque" => "Formulario",
        "Pagina" => "Pag",
        "Pagina_Datos" => [
            ["type" => "text", "name" => "Nombre", "label" => "¿Cuál es tu Nombre?", "placeholder" => "Juan Perez"],
            ["type" => "number", "name" => "Edad", "label" => "¿Cuál es tu edad?", "placeholder" => "99"],
            ["type" => "radio", "name" => "Sexo", "label" => "¿Cuál es tu sexo?", "options" => [["value" => "Fem", "text" => "Femenino"], ["value" => "Mas", "text" => "Masculino"]]],
            ["type" => "email", "name" => "Email", "label" => "¿Cuál es tu Correo?", "placeholder" => "jp@xyz.com"],
            ["type" => "select", "name" => "UltimaC", "label" => "¿Última consulta?", "options" => [["value" => "1mes", "text" => "Un Mes"], ["value" => "6meses", "text" => "6 Meses"], ["value" => "12meses", "text" => "1 Año"]]],
            ["type" => "textarea", "name" => "Problema", "label" => "Descripción del Problema.", "placeholder" => "Problema..."],
            ["type" => "checkbox", "name" => "Alergias", "label" => "¿Medicamentos a los que es alérgico?", "options" => [["value" => "opcion1", "text" => "Opción 1"], ["value" => "opcion2", "text" => "Opción 2"], ["value" => "opcion3", "text" => "Opción 3"]]],
            ["type" => "date", "name" => "Fecha", "label" => "Próxima Visita."],
            ["type" => "time", "name" => "Hora", "label" => "¿A qué Hora?"],
            ["type" => "password", "name" => "Pass", "label" => "Contraseña", "placeholder" => "12345"],
            ["type" => "tel", "name" => "Telefono", "label" => "Número Telefónico.", "placeholder" => "1234567890"],
        ],
        "Pagina_Colores" => "valor_pagina_c",
        "Pagina_Iconos" => "valor_pagina_i",
        "Datos" => "",
        "Conjunto_A" => "",
        "Conjunto_B" => "",
        "Token" => ""
    ]
];

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Formulario Dinámico</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
	
	<style>
.category-card {
    cursor: pointer;
}
.category-card:hover {
    box-shadow: 0px 0px 15px rgba(0,0,0,0.1);
}
.card-img-top {
    height: 100px; /* Ajustamos la altura de la imagen de la tarjeta */
    object-fit: cover;
}
.card-body {
    text-align: center;
    padding: 1rem; /* Espacio interno de la tarjeta */
}
.product-card {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
    padding: 0.5rem;
    border: 1px solid #ddd;
    border-radius: 0.5rem;
}
.product-image {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    margin-right: 1rem;
}
.product-info {
    flex: 1;
}
.product-price {
    font-weight: bold;
}
.add-to-cart {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    background-color: #28a745;
    color: white;
    border-radius: 50%;
    cursor: pointer;
}
.scrollmenu {
    overflow-x: auto;
    white-space: nowrap;
}
footer {
    position: fixed;
    bottom: 0;
    width: 100%;
    background-color: #f8f9fa;
}
img.lazy {
    opacity: 0;
    transition: opacity 0.3s;
}
img.lazy.loaded {
    opacity: 1;
		}
		
   .navbar {
            background: linear-gradient(to right, #000000, gray);
        }
        .navbar-brand {
            font-size: 1.5rem;
            color: #fff !important;
        }
        .navbar-nav .nav-link {
            color: #fff !important;
            font-size: 1.1rem;
            margin-left: 15px;
        }
        .navbar-nav .nav-link:hover {
            color: #ffd700 !important;
        }
        .navbar-toggler-icon {
            background-image: url("data:image/svg+xml;charset=utf8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3E%3Cpath stroke='rgba(255,255,255,.7)' stroke-width='2' d='M5 7h20M5 15h20M5 23h20'/%3E%3C/svg%3E");
        }
</style>
</head>
<body>

    <!-- Banner -->
<nav class="navbar navbar-expand-lg">
        <a class="navbar-brand" href="#"><?php echo $primerElemento['Nombre_Empresa']; ?></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="navbar-nav mr-auto">
                <!-- Puedes añadir más elementos de navegación aquí -->
            </ul>
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" data-toggle="modal" data-target="#loginModal">
                        <i class="fas fa-sign-in-alt"></i> Login
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-toggle="modal" data-target="#registerModal">
                        <i class="fas fa-user-plus"></i> Registro
                    </a>
                </li>
            </ul>
        </div>
    </nav>
	
 <div id="clientBanner" class="alert alert-info" style="display: none;"> 
    <!-- Aquí se mostrarán los datos del cliente --> 
  </div>	

    <!-- Formulario Dinámico -->
    <div class="container mt-4">
        <h2><?php echo $dataArray[0]['Titulo']; ?></h2>
        <form id="dynamicForm">
            <?php
            foreach ($dataArray[0]['Pagina_Datos'] as $field) {
                echo '<div class="mb-3">';
                echo '<label class="form-label">' . $field['label'] . '</label>';

                switch ($field['type']) {
                    case 'text':
                    case 'number':
                    case 'email':
                    case 'password':
                    case 'tel':
                    case 'date':
                    case 'time':
                        echo '<input type="' . $field['type'] . '" name="' . $field['name'] . '" class="form-control" placeholder="' . $field['placeholder'] . '">';
                        break;
                    
                    case 'textarea':
                        echo '<textarea name="' . $field['name'] . '" class="form-control" placeholder="' . $field['placeholder'] . '"></textarea>';
                        break;
                    
                    case 'radio':
                    case 'checkbox':
                        foreach ($field['options'] as $option) {
                            echo '<div class="' . $field['type'] . '">';
                            echo '<input class="form-check-input" type="' . $field['type'] . '" name="' . $field['name'] . '" value="' . $option['value'] . '">';
                            echo '<label class="form-check-label">' . $option['text'] . '</label>';
                            echo '</div>';
                        }
                        break;

                    case 'select':
                        echo '<select name="' . $field['name'] . '" class="form-select">';
                        foreach ($field['options'] as $option) {
                            echo '<option value="' . $option['value'] . '">' . $option['text'] . '</option>';
                        }
                        echo '</select>';
                        break;
                }
                echo '</div>';
            }
            ?>
            <button type="button" class="btn btn-success btn-lg" onclick="serializeForm()">Guardar</button>
            <button type="reset" class="btn btn-danger btn-lg">Limpiar Formulario</button>
        </form>

        <!-- Espacio para mostrar la serialización -->
        <div class="mt-4">
            <h4>Datos Serializados:</h4>
            <pre id="serializedData"></pre>
        </div>
    </div>
	<?php 	
	include("app/reg.php");
	include("app/login.php");
?>

   <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        function serializeForm() {
            var form = document.getElementById('dynamicForm');
            var formData = new FormData(form);
            var serializedData = {};

            formData.forEach(function(value, key) {
                if(serializedData[key]) {
                    if(Array.isArray(serializedData[key])) {
                        serializedData[key].push(value);
                    } else {
                        serializedData[key] = [serializedData[key], value];
                    }
                } else {
                    serializedData[key] = value;
                }
            });

            document.getElementById('serializedData').textContent = JSON.stringify(serializedData, null, 2);
        }
    </script>
</body>
</html>
