<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agendar Cita</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f4f9;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .container {
            margin-top: 50px;
        }

        #calendar {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
        }

        .user-info {
            text-align: center;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }

        .user-info img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            margin-bottom: 10px;
        }

        .user-info h4 {
            margin-bottom: 5px;
            font-size: 1.5em;
        }

        .user-info p {
            margin-bottom: 0;
            font-size: 1.2em;
        }

        #availableTimes button {
            margin-bottom: 10px;
            width: 100%;
            text-align: left;
            background-color: #ecf0f1;
            color: #2c3e50;
            border: 1px solid #bdc3c7;
            padding: 15px;
            border-radius: 5px;
            transition: background-color 0.3s ease;
        }

        #availableTimes button:hover {
            background-color: #bdc3c7;
        }

        .modal-header {
            background-color: #007bff;
            color: white;
            border-top-left-radius: 10px;
            border-top-right-radius: 10px;
        }

        .modal-content {
            border-radius: 10px;
        }

        .modal-footer {
            justify-content: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row">
            <!-- Columna Izquierda -->
            <div class="col-md-6">
                <div class="user-info">
                    <img src="https://via.placeholder.com/80" alt="Usuario">
                    <h4>Reunión con Vanessa Suarez</h4>
                    <p>noviembre</p>
                </div>
                <div id="calendar"></div>
            </div>

            <!-- Columna Derecha -->
            <div class="col-md-6">
                <h5 class="mb-4">Horas disponibles</h5>
                <div id="availableTimes" class="list-group"></div>
            </div>
        </div>
    </div>

    <!-- Modal para agendar cita -->
    <div class="modal fade" id="appointmentForm" tabindex="-1" aria-labelledby="appointmentFormLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="appointmentFormLabel">Agendar Cita</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="appointmentFormContent">
                        <div class="mb-3">
                            <label for="name" class="form-label">Nombre</label>
                            <input type="text" class="form-control" id="name" required>
                        </div>
                        <div class="mb-3">
                            <label for="phone" class="form-label">Número Telefónico</label>
                            <input type="text" class="form-control" id="phone" required>
                        </div>
                        <input type="hidden" id="selectedDate">
                        <input type="hidden" id="selectedTime">
                        <button type="submit" class="btn btn-primary w-100">Agendar Cita</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                selectable: true,
                events: [
                    { title: 'Disponible', start: '2024-08-17', backgroundColor: '#1abc9c' },
                    { title: 'Disponible', start: '2024-08-18', backgroundColor: '#1abc9c' }
                ],
                dateClick: function(info) {
                    fetchAvailableTimes(info.dateStr);
                }
            });

            calendar.render();

            function fetchAvailableTimes(date) {
                const agenda = {
                    "2024-08-17": ["03:00 PM", "03:15 PM", "03:30 PM", "03:45 PM", "04:00 PM", "04:15 PM"],
                    "2024-08-18": ["01:00 PM", "02:00 PM", "03:00 PM"]
                };

                $('#availableTimes').empty();

                if (agenda[date]) {
                    agenda[date].forEach(time => {
                        $('#availableTimes').append(`<button class='time-btn list-group-item list-group-item-action' data-time='${time}'>${time}</button>`);
                    });
                } else {
                    $('#availableTimes').append(`<div class='alert alert-info'>No hay horas disponibles para esta fecha.</div>`);
                }

                $('.time-btn').on('click', function() {
                    $('#selectedDate').val(date);
                    $('#selectedTime').val($(this).data('time'));
                    $('#appointmentForm').modal('show');
                });
            }

            $('#appointmentFormContent').on('submit', function(e) {
                e.preventDefault();

                const formData = {
                    name: $('#name').val(),
                    phone: $('#phone').val(),
                    date: $('#selectedDate').val(),
                    time: $('#selectedTime').val()
                };

                // Aquí agregarías el AJAX para enviar los datos al servidor
                console.log(formData);

                alert('Cita agendada con éxito para ' + formData.date + ' a las ' + formData.time);
                $('#appointmentForm').modal('hide');
            });
        });
    </script>
</body>
</html>
