$(function () {



    /* =========================================

     * tooltip

     *  =======================================*/



    $('.customer img').tooltip();





    /* =========================================

     * counters

     *  =======================================*/



    $('.counter').counterUp({

        delay: 10,

        time: 1000

    });



    /* =================================================

     * Preventing URL update on navigation link click

     *  ==============================================*/



    $('.link-scroll').on('click', function (e) {

        var anchor = $(this);

        $('html, body').stop().animate({

            scrollTop: $(anchor.attr('href')).offset().top

        }, 1000);

        e.preventDefault();

    });





    /* =========================================

     *  Scroll Spy

     *  =======================================*/



    $('body').scrollspy({

        target: '#navbarcollapse',

        offset: 80

    });





    /* =========================================

     * testimonial slider

     *  =======================================*/



    $(".testimonials").owlCarousel({

        nav: false,

        dots: true,

        responsiveClass: true,

        responsive: {

            0: {

                items: 1

            },

            600: {

                items: 1

            },

            1000: {

                items: 3

            },

            1200: {

                items: 4

            }

        }

    });





    /* =========================================

     * google map

     *  =======================================*/

    map();





    /* =========================================

     * parallax

     *  =======================================*/

    $(window).scroll(function () {



        var scroll = $(this).scrollTop();



        if ($(window).width() > 1250) {

            $('.parallax').css({

                'background-position': 'left -' + scroll / 8 + 'px'

            });

        } else {

            $('.parallax').css({

                'background-position': 'center center'

            });

        }

    });



    /* =========================================

     * filter

     *  =======================================*/



    $('#filter a').click(function (e) {

        e.preventDefault();



        $('#filter li').removeClass('active');

        $(this).parent('li').addClass('active');



        var categoryToFilter = $(this).attr('data-filter');



        $('.reference-item').each(function () {



            if ($(this).data('category') === categoryToFilter || categoryToFilter === 'all') {

                $(this).show();

            } else {

                $(this).hide();

            }

        });



    });





    /* =========================================

     * reference functionality

     *  =======================================*/

    $('.reference a').on('click', function (e) {



        e.preventDefault();



        var title = $(this).find('.reference-title').text(),

            description = $(this).siblings('.reference-description').html();



        $('#detail-title').text(title);

        $('#detail-content').html(description);



        var images = $(this).siblings('.reference-description').data('images').split(',');

        if (images.length > 0) {

            sliderContent = '';

            for (var i = 0; i < images.length; ++i) {

                sliderContent = sliderContent + '<div class="item"><img src=' + images[i] + ' alt="" class="img-fluid"></div>';

            }

        } else {

            sliderContent = '';

        }



        openReference(sliderContent);



    });



    function openReference(sliderContent) {

        $('#detail').slideDown();

        $('#references-masonry').slideUp();





        if (sliderContent !== '') {



            var slider = $('#detail-slider');



            if (slider.hasClass('owl-loaded')) {

                slider.trigger('replace.owl.carousel', sliderContent);

            } else {

                slider.html(sliderContent);

                slider.owlCarousel({

                    nav: false,

                    dots: true,

                    items: 1

                });



            }

        }

    }





    function closeReference() {

        $('#references-masonry').slideDown();

        $('#detail').slideUp();

    }



    $('#filter button, #detail .close').on('click', function () {

        closeReference();

    });





    /* =========================================

     *  animations

     *  =======================================*/



    delayTime = 0;



    $('[data-animate]').waypoint(function (direction) {

        delayTime += 250;



        var element = $(this.element);



        $(this.element).delay(delayTime).queue(function (next) {

            element.addClass('animated');

            element.addClass(element.data('animate'));

            delayTime = 0;

            next();

        });



        this.destroy();



    }, {

        offset: '90%'

    });

    

    $('[data-animate-hover]').hover(function () {

        $(this).css({

            opacity: 1

        });

        $(this).addClass('animated');

        $(this).removeClass($(this).data('animate'));

        $(this).addClass($(this).data('animate-hover'));

    }, function () {

        $(this).removeClass('animated');

        $(this).removeClass($(this).data('animate-hover'));

    });



    /* =========================================

     * for demo purpose

     *  =======================================*/



    var stylesheet = $('link#theme-stylesheet');

    $("<link id='new-stylesheet' rel='stylesheet'>").insertAfter(stylesheet);

    var alternateColour = $('link#new-stylesheet');



    if ($.cookie("theme_csspath")) {

        alternateColour.attr("href", $.cookie("theme_csspath"));

    }



    $("#colour").change(function () {



        if ($(this).val() !== '') {



            var theme_csspath = 'css/style.' + $(this).val() + '.css';



            alternateColour.attr("href", theme_csspath);



            $.cookie("theme_csspath", theme_csspath, {

                expires: 365,

                path: document.URL.substr(0, document.URL.lastIndexOf('/'))

            });



        }



        return false;

    });



});







/* =========================================

 * styled Google Map

 *  =======================================*/



function map() {



    if ($('#map').length > 0) {





        function initMap() {



            var location = new google.maps.LatLng(50.0875726, 14.4189987);



            var mapCanvas = document.getElementById('map');

            var mapOptions = {

                center: location,

                zoom: 16,

                panControl: false,

                mapTypeId: google.maps.MapTypeId.ROADMAP

            }

            var map = new google.maps.Map(mapCanvas, mapOptions);



            var markerImage = 'img/marker.png';



            var marker = new google.maps.Marker({

                position: location,

                map: map,

                icon: markerImage

            });



            var contentString = '<div class="info-window">' +

                '<h3>Info Window Content</h3>' +

                '<div class="info-content">' +

                '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>' +

                '</div>' +

                '</div>';



            var infowindow = new google.maps.InfoWindow({

                content: contentString,

                maxWidth: 400

            });



            marker.addListener('click', function () {

                infowindow.open(map, marker);

            });



            var styles = [{

                "featureType": "landscape",

                "stylers": [{

                    "saturation": -100

                }, {

                    "lightness": 65

                }, {

                    "visibility": "on"

                }]

            }, {

                "featureType": "poi",

                "stylers": [{

                    "saturation": -100

                }, {

                    "lightness": 51

                }, {

                    "visibility": "simplified"

                }]

            }, {

                "featureType": "road.highway",

                "stylers": [{

                    "saturation": -100

                }, {

                    "visibility": "simplified"

                }]

            }, {

                "featureType": "road.arterial",

                "stylers": [{

                    "saturation": -100

                }, {

                    "lightness": 30

                }, {

                    "visibility": "on"

                }]

            }, {

                "featureType": "road.local",

                "stylers": [{

                    "saturation": -100

                }, {

                    "lightness": 40

                }, {

                    "visibility": "on"

                }]

            }, {

                "featureType": "transit",

                "stylers": [{

                    "saturation": -100

                }, {

                    "visibility": "simplified"

                }]

            }, {

                "featureType": "administrative.province",

                "stylers": [{

                    "visibility": "off"

                }]

            }, {

                "featureType": "water",

                "elementType": "labels",

                "stylers": [{

                    "visibility": "on"

                }, {

                    "lightness": -25

                }, {

                    "saturation": -100

                }]

            }, {

                "featureType": "water",

                "elementType": "geometry",

                "stylers": [{

                    "hue": "#ffff00"

                }, {

                    "lightness": -25

                }, {

                    "saturation": -97

                }]

            }];



            map.set('styles', styles);

        }



        google.maps.event.addDomListener(window, 'load', initMap);

    }



}