<?php
// Historial simulado (puedes sustituir esto por una consulta a BD más adelante)
$historial = [
  ["presencia" => true,  "hora" => "2025-04-19 10:30:15"],
  ["presencia" => false, "hora" => "2025-04-19 10:35:45"],
  ["presencia" => true,  "hora" => "2025-04-19 10:40:10"],
  ["presencia" => false, "hora" => "2025-04-19 10:50:05"],
];
?>

  <style>
    body {
      background-color: #f0f2f5;
      font-family: 'Segoe UI', sans-serif;
    }

    .status-box {
      padding: 2rem;
      border-radius: 1.5rem;
      text-align: center;
      transition: all 0.3s ease;
      box-shadow: 0 10px 20px rgba(0, 0, 0, 0.05);
    }

    .status-box.presencia {
      background-color: #d1e7dd;
      color: #0f5132;
    }

    .status-box.no-presencia {
      background-color: #f8d7da;
      color: #842029;
    }

    .status-icon {
      font-size: 4rem;
      margin-bottom: 1rem;
    }

    .historial-table {
      margin-top: 2.5rem;
      border-radius: 1rem;
      overflow: hidden;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
  </style>

  <div class="container">
    <h1 class="text-center mb-5">
      <i class="fas fa-eye text-primary"></i> Visualizador de Presencia
    </h1>

    <!-- Estado actual -->
    <div id="estado" class="status-box no-presencia">
      <div id="icono" class="status-icon">
        <i class="fas fa-user-slash"></i>
      </div>
      <h2 id="mensaje">Sin presencia detectada</h2>
      <p id="hora" class="text-muted mb-0 small">Cargando hora...</p>
    </div>

    <!-- Historial -->
    <div class="historial-table mt-4">
      <table class="table table-striped table-hover">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Estado</th>
            <th>Fecha y Hora</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($historial as $i => $registro): ?>
            <tr>
              <td><?= $i + 1 ?></td>
              <td><?= $registro['presencia'] ? 'Presente' : 'Ausente' ?></td>
              <td><?= $registro['hora'] ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <script>
    async function cargarEstado() {
      try {
        const res = await fetch('datos_actuales.php');
        const data = await res.json();

        const box = document.getElementById('estado');
        const icono = document.getElementById('icono');
        const mensaje = document.getElementById('mensaje');
        const hora = document.getElementById('hora');

        if (data.presencia) {
          box.className = 'status-box presencia';
          icono.innerHTML = '<i class="fas fa-user-check"></i>';
          mensaje.textContent = '¡Presencia detectada!';
        } else {
          box.className = 'status-box no-presencia';
          icono.innerHTML = '<i class="fas fa-user-slash"></i>';
          mensaje.textContent = 'Sin presencia detectada';
        }

        hora.textContent = 'Última lectura: ' + data.hora;
      } catch (e) {
        console.error('Error al cargar estado:', e);
      }
    }

    setInterval(cargarEstado, 2000);
    cargarEstado();
  </script>


