<?php
// =============================================================================
// CATALOGO MAESTRO DE ACCIONES (TablaSimple)
// =============================================================================

$CATALOGO_ACCIONES = [

    // --- ACCIONES GLOBALES ---

    'recargar' => [
        'def' => ['titulo'=>'Refrescar','icono'=>'fas fa-sync-alt','color'=>'secondary','onclick'=>'accionRecargar()'],
        'js' => <<<JS
function accionRecargar() {
    console.log("🔄 [Acción] Recargando tabla...");
    tsManager.refresh();
    const Toast = Swal.mixin({toast: true, position: 'top-end', showConfirmButton: false, timer: 1000});
    Toast.fire({icon: 'success', title: 'Datos actualizados'});
}
JS
    ],

    'excel' => [
        'def' => ['titulo'=>'Exportar CSV','icono'=>'fas fa-file-csv','color'=>'success','onclick'=>'accionExportarExcel()'],
        'js' => <<<JS
function accionExportarExcel() {
    console.log("📊 [Acción] Iniciando exportación a CSV...");
    let csv = [];
    let rows = document.querySelectorAll("table tr");
    console.log("   Se encontraron " + rows.length + " filas para exportar.");

    for (let i = 0; i < rows.length; i++) {
        let row = [], cols = rows[i].querySelectorAll("td, th");
        for (let j = 0; j < cols.length - 1; j++) 
            row.push('"' + cols[j].innerText + '"');
        csv.push(row.join(","));
    }
    let csvFile = new Blob([csv.join("\\n")], {type: "text/csv"});
    let downloadLink = document.createElement("a");
    downloadLink.download = "export_" + new Date().toISOString() + ".csv";
    downloadLink.href = window.URL.createObjectURL(csvFile);
    downloadLink.style.display = "none";
    document.body.appendChild(downloadLink);
    downloadLink.click();
    console.log("✅ [Acción] Exportación completada.");
}
JS
    ],

    'crear' => [
        'def' => ['titulo'=>'Nuevo','icono'=>'fas fa-plus','color'=>'primary','onclick'=>'accionAbrirModalCrear()'],
        'js' => <<<JS
function accionAbrirModalCrear() { 
    console.log("➕ [Acción] Abriendo modal de creación.");
    tsManager.abrirModalCrear(); 
}
JS
    ],

    // --- ACCIONES DE FILA ---

    'eliminar' => [
        'def' => ['titulo'=>'Borrar','icono'=>'fas fa-trash-alt','color'=>'danger','onclick'=>"accionEliminar('{ID}')"],
        'js' => <<<JS
function accionEliminar(id) {
    console.log("🗑️ [Acción] Solicitud eliminar ID:", id);
    Swal.fire({
        title: '¿Estás seguro?',
        text: "Se eliminará el registro #" + id,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#e74a3b',
        cancelButtonColor: '#858796',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            console.log("   Usuario confirmó eliminación. Enviando query...");
            tsManager.db.query("DELETE FROM " + tsManager.cfg.tableName + " WHERE " + tsManager.cfg.primaryKey + " = '" + id + "'")
            .then(res => {
                console.log("   Respuesta DB:", res);
                if (res.status === 'success') {
                    tsManager.refresh();
                    Swal.fire('Eliminado', 'El registro ha sido borrado.', 'success');
                } else {
                    console.error("❌ Error al eliminar:", res.error);
                    Swal.fire('Error', res.error, 'error');
                }
            });
        } else {
            console.log("   Cancelado por usuario.");
        }
    });
}
JS
    ],

    'inline-edit' => [
        'def' => ['titulo'=>'Editar','icono'=>'fas fa-pen','color'=>'warning','onclick'=>'accionEditarFila(this)'],
        'js' => <<<JS
function accionEditarFila(btnHTML) { 
    console.log("✏️ [Acción] Activando edición en línea para fila.");
    tsManager.activarEdicionFila(btnHTML); 
}
JS
    ],

    // --- GESTIÓN DE CREDENCIALES (LÓGICA CORREGIDA INSERT/UPDATE) ---
    'editar_acceso' => [
        'def' => [
            'titulo'  => 'Credenciales y Accesos',
            'icono'   => 'fas fa-user-lock', 
            'color'   => 'dark', 
            'onclick' => "gestionCredenciales('{IDU}')"
        ],
        'js' => <<<JS
async function gestionCredenciales(idu) {
    // Agrupamos logs en consola
    console.groupCollapsed("🔐 Gestión de Credenciales | IDU: " + idu);
    
    // CONFIGURACIÓN INTERNA
    const urlPass = '../librerias/AJAX/Pass.php'; 
    const tablaDatos = 'MS_Usuario.Usuarios_Datos'; 

    console.log("1. Iniciando proceso. Endpoint:", urlPass);

    // 1. Verificar si el registro ya existe
    Swal.fire({title: 'Cargando datos...', didOpen: () => Swal.showLoading()});
    
    const sqlGet = "SELECT User, Rol, Estado FROM " + tablaDatos + " WHERE IDU = '" + idu + "'";
    console.log("2. Verificando existencia:", sqlGet);
    
    const res = await tsManager.db.select(sqlGet);
    console.log("   Respuesta Consulta:", res);
    
    // Valores por defecto
    let d = { User: '', Rol: 'Consulta', Estado: 'Activo' };
    let existe = false; // Bandera para decidir si es INSERT o UPDATE
    
    if(res.status === 'success' && res.data && res.data.length > 0) {
        d = res.data[0];
        existe = true;
        console.log("   ✅ El registro YA EXISTE. Se realizará un UPDATE.");
    } else {
        console.warn("   ⚠️ El registro NO EXISTE. Se realizará un INSERT.");
    }

    Swal.close();

    // 2. Mostrar Modal
    console.log("3. Mostrando formulario...");
    const { value: formValues } = await Swal.fire({
        title: 'Gestión de Acceso',
        html: `
            <div class="text-start fs-6">
                <label class="fw-bold mb-1">Usuario (Login)</label>
                <input id="swal-user" class="form-control mb-3" placeholder="Ej. juan.perez" value="\${d.User || ''}">
                
                <div class="row">
                    <div class="col-6">
                        <label class="fw-bold mb-1">Rol</label>
                        <select id="swal-rol" class="form-select mb-3">
                            <option value="Admin" \${d.Rol === 'Admin' ? 'selected' : ''}>Admin</option>
                            <option value="Operador" \${d.Rol === 'Operador' ? 'selected' : ''}>Operador</option>
                            <option value="Consulta" \${d.Rol === 'Consulta' ? 'selected' : ''}>Consulta</option>
                        </select>
                    </div>
                    <div class="col-6">
                        <label class="fw-bold mb-1">Estado</label>
                        <select id="swal-estado" class="form-select mb-3">
                            <option value="Activo" \${d.Estado === 'Activo' ? 'selected' : ''}>Activo</option>
                            <option value="Suspendido" \${d.Estado === 'Suspendido' ? 'selected' : ''}>Suspendido</option>
                        </select>
                    </div>
                </div>

                <hr>
                <label class="fw-bold mb-1 text-danger">Contraseña</label>
                <input id="swal-pass" type="password" class="form-control" placeholder="Vacío para mantener actual">
                <small class="text-muted" style="font-size:0.75rem">Solo escribe si deseas cambiarla/asignarla.</small>
            </div>
        `,
        focusConfirm: false,
        showCancelButton: true,
        confirmButtonText: 'Guardar Credenciales',
        confirmButtonColor: '#212529',
        preConfirm: () => {
            return {
                user: document.getElementById('swal-user').value,
                rol: document.getElementById('swal-rol').value,
                estado: document.getElementById('swal-estado').value,
                pass: document.getElementById('swal-pass').value
            }
        }
    });

    if (!formValues) {
        console.log("⛔ Cancelado por el usuario.");
        console.groupEnd();
        return; 
    }
    
    console.log("4. Datos capturados:", formValues);

    // 3. Encriptación (Solo si escribió algo en pass)
    Swal.fire({title: 'Guardando...', didOpen: () => Swal.showLoading()});

    let hashFinal = null;

    if (formValues.pass) {
        console.log("🔑 Contraseña detectada. Solicitando encriptación...");
        try {
            const respHash = await fetch(urlPass, { 
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ passwordCliente: formValues.pass })
            });
            const jsonHash = await respHash.json();
            console.log("   Respuesta Server:", jsonHash);
            
            if(jsonHash.hash_guardado) {
                hashFinal = jsonHash.hash_guardado;
            } else {
                throw new Error("API retornó éxito pero no hash");
            }
        } catch (e) {
            console.error("❌ Error CRÍTICO en encriptación:", e);
            Swal.fire('Error', 'No se pudo encriptar la contraseña: ' + e.message, 'error');
            console.groupEnd();
            return;
        }
    }

    // 4. Construcción SQL (Separada Insert vs Update)
    let sql = "";
    
    if (existe) {
        // --- LOGICA UPDATE ---
        console.log("🛠️ Generando query UPDATE...");
        
        let updates = [
            "User = '" + formValues.user + "'",
            "Rol = '" + formValues.rol + "'",
            "Estado = '" + formValues.estado + "'"
        ];
        
        // Solo actualizamos password si se generó un hash nuevo
        if (hashFinal) {
            updates.push("Password = '" + hashFinal + "'");
        }
        
        sql = "UPDATE " + tablaDatos + " SET " + updates.join(", ") + " WHERE IDU = '" + idu + "'";

    } else {
        // --- LOGICA INSERT ---
        console.log("🛠️ Generando query INSERT...");
        
        if (hashFinal) {
            sql = "INSERT INTO " + tablaDatos + " (IDU, User, Rol, Estado, Password) VALUES " +
                  "('" + idu + "', '" + formValues.user + "', '" + formValues.rol + "', '" + formValues.estado + "', '" + hashFinal + "')";
        } else {
            // Insert sin password (o null)
            sql = "INSERT INTO " + tablaDatos + " (IDU, User, Rol, Estado) VALUES " +
                  "('" + idu + "', '" + formValues.user + "', '" + formValues.rol + "', '" + formValues.estado + "')";
        }
    }

    console.log("   Query Final:", sql);

    // 5. Ejecución
    tsManager.db.query(sql).then(r => {
        console.log("5. Resultado DB:", r);
        if(r.status === 'success') {
            Swal.fire({
                icon: 'success', 
                title: 'Guardado', 
                text: 'La información se actualizó correctamente.',
                showConfirmButton: false, 
                timer: 1500
            });
            console.log("✅ Proceso exitoso.");
        } else {
            console.error("❌ Error SQL:", r.error);
            Swal.fire('Error SQL', r.error, 'error');
        }
        console.groupEnd();
    });
}
JS
    ]
];

// -----------------------------------------------------------------------------
// FUNCIONES CONSTRUCTORAS (Helpers)
// -----------------------------------------------------------------------------

function construirScriptsAcciones($solicitadasGlobales, $solicitadasFila) {
    global $CATALOGO_ACCIONES;
    $todas = array_unique(array_merge($solicitadasGlobales, $solicitadasFila));
    $js = "";
    foreach ($todas as $k) {
        if (is_string($k) && isset($CATALOGO_ACCIONES[$k])) {
            $js .= "\n// $k \n" . $CATALOGO_ACCIONES[$k]['js'] . "\n";
        }
    }
    return $js;
}

function construirHTMLGlobales($solicitadas) {
    global $CATALOGO_ACCIONES;
    $html = '<div class="d-flex align-items-center gap-2">'; 
    foreach ($solicitadas as $item) {
        $def = (is_string($item) && isset($CATALOGO_ACCIONES[$item])) ? $CATALOGO_ACCIONES[$item]['def'] : (is_array($item) ? $item : null);
        if ($def) {
            $html .= "<button class='btn btn-light text-{$def['color']} border shadow-sm d-flex align-items-center justify-content-center rounded-circle' 
                             onclick=\"{$def['onclick']}\" 
                             title='{$def['titulo']}' 
                             data-bs-toggle='tooltip' 
                             data-bs-placement='top'
                             style='width: 38px; height: 38px;'>
                        <i class='{$def['icono']}'></i>
                      </button>";
        }
    }
    return $html . '</div>';
}

function construirConfigRenglon($solicitadas) {
    global $CATALOGO_ACCIONES;
    $res = [];
    foreach ($solicitadas as $item) {
        if (is_string($item) && isset($CATALOGO_ACCIONES[$item])) $res[] = $CATALOGO_ACCIONES[$item]['def'];
        elseif (is_array($item)) $res[] = $item;
    }
    return $res;
}
?>