<?php
try {
    $dbImp = $_SESSION['BD'] ?? "MS_Datos";
    $idPropietario = $_SESSION['IDUg'] ?? '1'; // Usamos el ID de propietario para el prefijo de tablas
    $pdoImp = new PDO("mysql:host=localhost;dbname=$dbImp;charset=utf8", "root", "33comRxXMysql");
    // Seleccionamos las impresoras activas del propietario
    $stmtImp = $pdoImp->query("SELECT * FROM `{$idPropietario}-Configuracion_Impresoras` WHERE Activo = 1");
    $impresorasData = $stmtImp->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) { $impresorasData = []; }
?>

<style>
    .pe-preview-bg { background-color: #525659; display: flex; justify-content: center; padding: 20px; height: 75vh; overflow-y: auto; }
    .pe-paper { background: white; box-shadow: 0 0 25px rgba(0,0,0,0.5); padding: 30px; color: #000; height: fit-content; margin-bottom: 50px; box-sizing: border-box; }
    .pe-p-58mm { width: 58mm; padding: 10px; font-size: 10px; }
    .pe-p-80mm { width: 80mm; padding: 15px; font-size: 12px; }
    .pe-p-a4.portrait  { width: 210mm; min-height: 297mm; }
    .pe-table-pro { width: 100%; border-collapse: collapse; margin-top: 15px; table-layout: fixed; word-wrap: break-word; }
    .pe-table-pro th { background-color: #f26522 !important; color: white !important; padding: 8px 4px; border: 1px solid #f26522; font-size: 0.9em; }
    .pe-table-pro td { padding: 6px 4px; border: 1px solid #eee; vertical-align: top; }
</style>

<div class="modal fade" id="modalPrintEngine" tabindex="-1" data-backdrop="static">
    <div class="modal-dialog modal-xl" style="max-width: 95%;">
        <div class="modal-content border-0">
            <div class="modal-header bg-dark text-white p-2">
                <h6 class="modal-title font-weight-bold ml-2">VISOR DE DOCUMENTOS</h6>
                <select id="pe-select-config" class="form-control form-control-sm ml-auto" style="width:280px;" onchange="PrintEngine.render()"></select>
            </div>
            <div class="modal-body p-0">
                <div class="pe-preview-bg"><div id="pe-hoja-digital" class="pe-paper"></div></div>
            </div>
            <div class="modal-footer bg-light p-2">
                <button class="btn btn-outline-dark px-4 font-weight-bold" onclick="PrintEngine.printNow()">IMPRIMIR WEB (PDF)</button>
                
                <button class="btn btn-success px-4 font-weight-bold" onclick="PrintEngine.saveToApp()">
                    <i class="feather icon-smartphone mr-1"></i> ENVIAR A LA APP
                </button>
                
                <button class="btn btn-secondary px-4" onclick="location.reload()">CERRAR / NUEVA ORDEN</button>
            </div>
        </div>
    </div>
</div>

<script>
const PrintEngine = {
    saleInfo: null,
    configs: <?php echo json_encode($impresorasData); ?>,
    show: function(data) {
        this.saleInfo = data;
        const select = document.getElementById('pe-select-config');
        select.innerHTML = this.configs.map(c => `<option value="${c.ID_Config}" data-conf='${JSON.stringify(c)}'>${c.Nombre_Perfil} (${c.Tipo_Papel})</option>`).join('');
        this.render(); 
        $('#modalPrintEngine').modal('show');
    },
    render: function() {
        const select = document.getElementById('pe-select-config');
        if(!select.selectedOptions[0]) return;
        const conf = JSON.parse(select.selectedOptions[0].dataset.conf);
        const info = this.saleInfo; 
        const hoja = document.getElementById('pe-hoja-digital');
        const money = n => new Intl.NumberFormat('es-MX', { style: 'currency', currency: 'MXN' }).format(n);
        
        hoja.className = `pe-paper pe-p-${conf.Tipo_Papel.toLowerCase()} ${conf.Orientacion.toLowerCase()}`;
        
        // QR de seguimiento para el ticket
        const apiQR = `https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=${encodeURIComponent('https://tusitio.com/check.php?f='+info.folio)}`;

        // Renderizado según si es OS (Orden de Servicio) o Venta normal
        if(info.isOS) {
            hoja.innerHTML = `
                <div style="text-align:center;">
                    <img src="${conf.Logo_Base64||''}" style="max-width:120px; display:${conf.Logo_Base64?'block':'none'}; margin:0 auto 10px;">
                    <h3 style="margin:0; color:#f26522;">ORDEN DE SERVICIO</h3>
                    <div style="font-size:10px;">${conf.Cabecera_Texto||''}</div>
                    <div style="border:1px dashed #000; margin:10px 0; padding:5px;"><b>FOLIO: ${info.folio}</b></div>
                </div>
                <div style="font-size:11px; margin-bottom:10px;">
                    <b>CLIENTE:</b> ${info.cliente}<br>
                    <b>EQUIPO:</b> ${info.equipo}<br>
                    <b>S/N:</b> ${info.serie}<br>
                    ------------------------------------<br>
                    <b>FALLA:</b> ${info.falla}
                </div>
                <div style="text-align:right; font-weight:bold; font-size:12px;">
                    TOTAL: ${money(info.costo)}<br>
                    ANTICIPO: ${money(info.adelanto)}<br>
                    RESTA: ${money(info.resta)}
                </div>
                <center style="margin-top:15px;">
                    <img src="${apiQR}" style="width:100px;"><br>
                    <small>CONSULTAR ESTATUS</small>
                </center>
                <div style="font-size:8px; margin-top:15px; text-align:justify; color:#555;">${conf.Pie_Pagina_Texto || ''}</div>
            `;
        } else {
            // ... Aquí iría el render normal de ventas que ya tenías ...
            hoja.innerHTML = `<h4>Nota de Venta: ${info.folio}</h4>`; 
        }
    },
    
    // FUNCIÓN PARA GUARDAR EN LA COLA DE LA APP
  saveToApp: async function() {
        const select = document.getElementById('pe-select-config');
        const idConfig = select.value;
        const info = this.saleInfo;
        
        // 1. Preparamos los datos. El UUID es el Folio: OS-YYMMDD-XXX
        const uuid = info.folio; 
        const jsonContent = JSON.stringify(info).replace(/'/g, "\\'"); 
        
        // 2. Construimos el SQL con el prefijo del propietario y el ID de referencia correcto (idRef)
        const sql = `INSERT INTO \`<?php echo $idPropietario; ?>-Documentos_Generados\` 
                    (UUID_Unico, Modulo_Origen, ID_Referencia, ID_Config_Impresora, Contenido_JSON, Estado) 
                    VALUES ('${uuid}', 'OrdenServicio', ${info.idRef || 0}, ${idConfig}, '${jsonContent}', 'PENDIENTE')`;
        console.log(sql);
        const fd = new FormData();
        fd.append('db', '<?php echo $dbName; ?>');
        fd.append('sql', sql);

        try {
            const resp = await fetch('../librerias/AJAX/Execute.php', { method: 'POST', body: fd }).then(r => r.json());
            if(resp.status === 'success' || resp.last_id) {
                alert("¡Orden enviada a la App con éxito! Folio: " + uuid);
                location.reload();
            } else {
                alert("Error al enviar a la app: " + (resp.message || "Verifique conexión"));
            }
        } catch (e) { 
            alert("Error de comunicación con el servidor."); 
        }
    },
    printNow: function() {
        const win = window.open('', 'Print', 'width=1100,height=800');
        win.document.write(`<html><head><style>body{font-family:Arial; padding:10px;}</style></head><body>${document.getElementById('pe-hoja-digital').innerHTML}</body></html>`);
        win.document.close(); win.print(); win.close(); location.reload();
    }
};
</script>